/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhaseStoneSpawnProcedure {
    private static final double CHANCE_PER_TICK = 1.0E-4;
    private static final int SCAN_RADIUS = 10;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase < 1 || phase > 3) {
            return;
        }
        if (Math.random() >= 1.0E-4) {
            return;
        }
        BlockPos ppos = player.m_20183_();
        BlockPos nearestStone = null;
        double minDistSq = Double.MAX_VALUE;
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -10; dz <= 10; ++dz) {
                    double d2;
                    BlockPos pos = ppos.m_7918_(dx, dy, dz);
                    if (level.m_8055_(pos).m_60734_() != Blocks.f_50069_ || !((d2 = pos.m_123331_((Vec3i)ppos)) < minDistSq)) continue;
                    minDistSq = d2;
                    nearestStone = pos;
                }
            }
        }
        if (nearestStone == null) {
            return;
        }
        BlockPos spawnPos = null;
        for (Direction dir : Direction.values()) {
            BlockPos cand = nearestStone.m_121945_(dir);
            if (!level.m_8055_(cand).m_60795_()) continue;
            spawnPos = cand;
            break;
        }
        if (spawnPos == null) {
            return;
        }
        Entity e = ((EntityType)FromTheCavesModEntities.FROMTHECAVESSTONE.get()).m_262496_(level, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (!(e instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)e;
        Vec3 dir = Vec3.m_82512_(nearestStone).m_82546_(mob.m_20182_()).m_82541_();
        float yaw = (float)(Math.atan2(dir.f_82481_, dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.asin(dir.f_82480_) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.m_146926_(pitch);
        mob.m_5616_(yaw);
        mob.m_21557_(true);
        mob.m_20049_("phaseStone");
    }
}

