/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossesedBehaviorProcedure {
    private static final int LIFETIME_TICKS = 700;
    private static final double LOOK_RADIUS = 50.0;

    @SubscribeEvent
    public static void onPossessedTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        if (!mob.m_19880_().contains("phase2Possessed")) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long start = data.m_128454_("possessStart");
        long now = level.m_46467_();
        Player target = level.m_45930_((Entity)mob, 50.0);
        if (target != null) {
            Vec3 dir = target.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            float yaw = (float)(Math.atan2(dir.f_82481_, dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-Math.asin(dir.f_82480_) * 180.0 / Math.PI);
            mob.m_5616_(yaw);
            mob.m_146926_(pitch);
        }
        mob.m_20256_(Vec3.f_82478_);
        if (now - start >= 700L) {
            CompoundTag origNBT = data.m_128469_("origNBT");
            origNBT.m_128359_("id", data.m_128461_("origID"));
            Entity reverted = EntityType.m_20645_((CompoundTag)origNBT, (Level)level, e -> e);
            if (reverted != null) {
                level.m_7967_(reverted);
            } else {
                Entity raw;
                EntityType type;
                ResourceLocation origRL = ResourceLocation.m_135820_((String)data.m_128461_("origID"));
                if (origRL != null && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(origRL)) != null && (raw = type.m_20615_((Level)level)) instanceof Mob) {
                    Mob original = (Mob)raw;
                    original.m_20258_(origNBT);
                    original.m_7678_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), mob.m_146908_(), mob.m_146909_());
                    level.m_7967_((Entity)original);
                }
            }
            mob.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

