/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CauldronEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 200;
    private static final Map<Integer, CauldronEventState> activeEvents = new HashMap<Integer, CauldronEventState>();
    private static final Map<BlockPos, Long> cauldronCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validCauldrons = CauldronEventsProcedure.findValidCauldrons(server, player);
        if (validCauldrons.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validCauldrons.removeIf(pos -> cauldronCooldowns.containsKey(pos) && currentTime < cauldronCooldowns.get(pos));
        if (validCauldrons.isEmpty()) {
            return;
        }
        BlockPos chosen = validCauldrons.get(server.m_213780_().m_188503_(validCauldrons.size()));
        CauldronEvent event = CauldronEvent.values()[server.m_213780_().m_188503_(CauldronEvent.values().length)];
        cauldronCooldowns.put(chosen, currentTime + 200L);
        activeEvents.put(eventIdCounter++, new CauldronEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.getServer().m_129921_() % 200 == 0) {
            long currentTime = ev.getServer().m_129783_().m_46467_();
            cauldronCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        }
        Iterator<Map.Entry<Integer, CauldronEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, CauldronEventState> entry2 = iterator.next();
            CauldronEventState state = entry2.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case BUBBLING: {
                    CauldronEventsProcedure.handleBubbling(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                    break;
                }
                case CAVE_SOUNDS: {
                    CauldronEventsProcedure.handleCaveSounds(server, state);
                    if (state.tickCount < 60) break;
                    iterator.remove();
                    break;
                }
                case BLINDNESS_EFFECT: {
                    CauldronEventsProcedure.handleBlindnessEffect(server, state);
                    if (state.tickCount < 60) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidCauldrons(ServerLevel server, Player player) {
        ArrayList<BlockPos> cauldrons = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof LayeredCauldronBlock)) continue;
                    cauldrons.add(pos.m_7949_());
                }
            }
        }
        return cauldrons;
    }

    private static void handleBubbling(ServerLevel server, CauldronEventState state) {
        if (state.player.m_20275_((double)state.cauldronPos.m_123341_() + 0.5, (double)state.cauldronPos.m_123342_() + 0.5, (double)state.cauldronPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount % 10 == 0) {
            double x = (double)state.cauldronPos.m_123341_() + 0.5;
            double y = (double)state.cauldronPos.m_123342_() + 0.8;
            double z = (double)state.cauldronPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 2, 0.2, 0.05, 0.2, 0.05);
        }
    }

    private static void handleCaveSounds(ServerLevel server, CauldronEventState state) {
        if (state.player.m_20275_((double)state.cauldronPos.m_123341_() + 0.5, (double)state.cauldronPos.m_123342_() + 0.5, (double)state.cauldronPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount == 1 || state.tickCount == 40) {
            server.m_5594_(null, state.cauldronPos, (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.BLOCKS, 0.4f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
        }
    }

    private static void handleBlindnessEffect(ServerLevel server, CauldronEventState state) {
        double distance;
        if (state.tickCount == 30 && (distance = state.player.m_20275_((double)state.cauldronPos.m_123341_() + 0.5, (double)state.cauldronPos.m_123342_() + 0.5, (double)state.cauldronPos.m_123343_() + 0.5)) <= 9.0) {
            double cauldronYaw;
            double dx = state.player.m_20185_() - ((double)state.cauldronPos.m_123341_() + 0.5);
            double dy = state.player.m_20188_() - ((double)state.cauldronPos.m_123342_() + 0.5);
            double dz = state.player.m_20189_() - ((double)state.cauldronPos.m_123343_() + 0.5);
            double playerYaw = Math.toDegrees(Mth.m_14136_((double)(-dx), (double)dz));
            double yawDiff = Math.abs(Mth.m_14175_((double)(playerYaw - (cauldronYaw = Math.toDegrees(Mth.m_14136_((double)(-dz), (double)(-dx))) + 90.0))));
            if (yawDiff < 45.0) {
                state.player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false));
                server.m_5594_(null, state.cauldronPos, SoundEvents.f_12404_, SoundSource.BLOCKS, 0.5f, 0.5f);
            }
        }
    }

    private static enum CauldronEvent {
        BUBBLING,
        CAVE_SOUNDS,
        BLINDNESS_EFFECT;

    }

    private static class CauldronEventState {
        CauldronEvent event;
        Player player;
        BlockPos cauldronPos;
        int tickCount;

        CauldronEventState(CauldronEvent event, Player player, BlockPos cauldronPos) {
            this.event = event;
            this.player = player;
            this.cauldronPos = cauldronPos;
            this.tickCount = 0;
        }
    }
}

