/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ExorcismPhaseAdvancerProcedure {
    public static void incrementAndAdvance(LevelAccessor worldAcc) {
        if (!(worldAcc instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)worldAcc;
        ExorcismData data = ExorcismPhaseAdvancerProcedure.getExorcismData(serverLevel);
        String dimKey = serverLevel.m_46472_().m_135782_().toString();
        int prevCount = data.getSuccessCount(dimKey);
        int newCount = prevCount + 1;
        data.setSuccessCount(dimKey, newCount);
        if (newCount >= 100) {
            PhaseManagerProcedure.setManualPhase(worldAcc, 3);
        } else if (newCount >= 1) {
            PhaseManagerProcedure.setManualPhase(worldAcc, 2);
        }
    }

    public static void resetCounter(LevelAccessor worldAcc) {
        if (!(worldAcc instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)worldAcc;
        ExorcismData data = ExorcismPhaseAdvancerProcedure.getExorcismData(serverLevel);
        String dimKey = serverLevel.m_46472_().m_135782_().toString();
        data.resetCounter(dimKey);
    }

    public static void resetAllCounters(LevelAccessor worldAcc) {
        if (!(worldAcc instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)worldAcc;
        ExorcismData data = ExorcismPhaseAdvancerProcedure.getExorcismData(serverLevel);
        data.resetAllCounters();
    }

    public static int getSuccessCount(LevelAccessor worldAcc) {
        if (!(worldAcc instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)worldAcc;
        ExorcismData data = ExorcismPhaseAdvancerProcedure.getExorcismData(serverLevel);
        String dimKey = serverLevel.m_46472_().m_135782_().toString();
        return data.getSuccessCount(dimKey);
    }

    private static ExorcismData getExorcismData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (ExorcismData)storage.m_164861_(ExorcismData::load, ExorcismData::new, "fromthecaves_exorcism_data");
    }

    public static class ExorcismData
    extends SavedData {
        public static final String NAME = "fromthecaves_exorcism_data";
        private final CompoundTag successCounts = new CompoundTag();

        public static ExorcismData load(CompoundTag tag) {
            ExorcismData data = new ExorcismData();
            if (tag.m_128441_("successCounts")) {
                data.successCounts.m_128391_(tag.m_128469_("successCounts"));
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128365_("successCounts", (Tag)this.successCounts);
            return tag;
        }

        public int getSuccessCount(String dimensionKey) {
            return this.successCounts.m_128451_(dimensionKey);
        }

        public void setSuccessCount(String dimensionKey, int count) {
            this.successCounts.m_128405_(dimensionKey, count);
            this.m_77762_();
        }

        public void resetAllCounters() {
            for (String key : this.successCounts.m_128431_()) {
                this.successCounts.m_128405_(key, 0);
            }
            this.m_77762_();
        }

        public void resetCounter(String dimensionKey) {
            this.successCounts.m_128405_(dimensionKey, 0);
            this.m_77762_();
        }
    }
}

