/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SculkShriekerEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 300;
    private static final Map<Integer, SculkShriekerEventState> activeEvents = new HashMap<Integer, SculkShriekerEventState>();
    private static final Map<BlockPos, Long> shriekerCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validShriekers = SculkShriekerEventsProcedure.findValidSculkShriekers(server, player);
        if (validShriekers.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validShriekers.removeIf(pos -> shriekerCooldowns.containsKey(pos) && currentTime < shriekerCooldowns.get(pos));
        if (validShriekers.isEmpty()) {
            return;
        }
        BlockPos chosen = validShriekers.get(server.m_213780_().m_188503_(validShriekers.size()));
        SculkShriekerEvent event = SculkShriekerEvent.values()[server.m_213780_().m_188503_(SculkShriekerEvent.values().length)];
        shriekerCooldowns.put(chosen, currentTime + 300L);
        activeEvents.put(eventIdCounter++, new SculkShriekerEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.getServer().m_129921_() % 200 == 0) {
            long currentTime = ev.getServer().m_129783_().m_46467_();
            shriekerCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        }
        Iterator<Map.Entry<Integer, SculkShriekerEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SculkShriekerEventState> entry2 = iterator.next();
            SculkShriekerEventState state = entry2.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case DEEP_SHRIEK: {
                    SculkShriekerEventsProcedure.handleDeepShriek(server, state);
                    if (state.tickCount < 40) break;
                    iterator.remove();
                    break;
                }
                case SOUL_PARTICLES: {
                    SculkShriekerEventsProcedure.handleSoulParticles(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidSculkShriekers(ServerLevel server, Player player) {
        ArrayList<BlockPos> shriekers = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof SculkShriekerBlock)) continue;
                    shriekers.add(pos.m_7949_());
                }
            }
        }
        return shriekers;
    }

    private static void handleDeepShriek(ServerLevel server, SculkShriekerEventState state) {
        if (state.tickCount == 1 && state.player.m_20275_((double)state.shriekerPos.m_123341_() + 0.5, (double)state.shriekerPos.m_123342_() + 0.5, (double)state.shriekerPos.m_123343_() + 0.5) <= 36.0) {
            server.m_5594_(null, state.shriekerPos, SoundEvents.f_215769_, SoundSource.BLOCKS, 0.6f, 0.5f);
        }
    }

    private static void handleSoulParticles(ServerLevel server, SculkShriekerEventState state) {
        if (state.player.m_20275_((double)state.shriekerPos.m_123341_() + 0.5, (double)state.shriekerPos.m_123342_() + 0.5, (double)state.shriekerPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount % 8 == 0) {
            double x = (double)state.shriekerPos.m_123341_() + 0.5;
            double y = (double)state.shriekerPos.m_123342_() + 0.5;
            double z = (double)state.shriekerPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_235898_, x, y, z, 2, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private static enum SculkShriekerEvent {
        DEEP_SHRIEK,
        SOUL_PARTICLES;

    }

    private static class SculkShriekerEventState {
        SculkShriekerEvent event;
        Player player;
        BlockPos shriekerPos;
        int tickCount;

        SculkShriekerEventState(SculkShriekerEvent event, Player player, BlockPos shriekerPos) {
            this.event = event;
            this.player = player;
            this.shriekerPos = shriekerPos;
            this.tickCount = 0;
        }
    }
}

