/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVES3DOPPELEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnMirrorDoppelgangerProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final int MIN_SPAWN_DIST = 8;
    private static final int MAX_SPAWN_DIST = 16;
    private static final int MIRROR_DELAY_TICKS = 2;
    private static final long FORCE_DELAY_TICKS = 400L;
    private static final double CHARGE_SPEED = 1.2;
    private static final double FALLBACK_SPEED_MULT = 1.0;
    private static final int TOUCH_BLIND_TICKS = 120;
    private static final int COLLISION_BLIND_TICKS = 100;
    private static final double TOUCH_DISTANCE_SQ = 16.0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        int mz;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        long dayTime = level.m_6106_().m_6792_() % 24000L;
        if (dayTime <= 12000L) {
            return;
        }
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 5.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        RandomSource rand = server.m_213780_();
        double angle = rand.m_188500_() * Math.PI * 2.0;
        double dist = 8.0 + rand.m_188500_() * 8.0;
        double dx = Math.cos(angle) * dist;
        double dz = Math.sin(angle) * dist;
        Vec3 spawnPos = player.m_20182_().m_82492_(dx, 0.0, dz);
        int mx = (int)Math.floor(spawnPos.f_82479_);
        int my = server.m_6924_(Heightmap.Types.WORLD_SURFACE, mx, mz = (int)Math.floor(spawnPos.f_82481_));
        if (my < server.m_141937_() + 5 || my > server.m_151558_() - 5) {
            return;
        }
        FROMTHECAVES3DOPPELEntity doppel = (FROMTHECAVES3DOPPELEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVES_3_DOPPEL.get()).m_20615_((Level)server);
        if (doppel == null) {
            return;
        }
        float yaw = player.m_146908_();
        doppel.m_7678_(spawnPos.f_82479_, my, spawnPos.f_82481_, yaw, 0.0f);
        doppel.m_146922_(yaw);
        doppel.f_20885_ = yaw;
        doppel.f_20883_ = yaw;
        long now = server.m_46467_();
        CompoundTag nbt = doppel.getPersistentData();
        nbt.m_128379_("isMirror", true);
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128347_("prevX", player.m_20185_());
        nbt.m_128347_("prevZ", player.m_20189_());
        nbt.m_128405_("tickDelay", 0);
        nbt.m_128379_("forceApplied", false);
        nbt.m_128379_("isChasingFallback", false);
        doppel.m_21557_(true);
        doppel.m_21530_();
        server.m_7967_((Entity)doppel);
    }

    @SubscribeEvent
    public static void onMirrorTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVES3DOPPELEntity)) {
            return;
        }
        FROMTHECAVES3DOPPELEntity mob = (FROMTHECAVES3DOPPELEntity)e;
        Level level = mob.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        CompoundTag nbt = mob.getPersistentData();
        boolean isMirror = nbt.m_128471_("isMirror");
        boolean forceApplied = nbt.m_128471_("forceApplied");
        boolean chasingFallback = nbt.m_128471_("isChasingFallback");
        if (!(isMirror || forceApplied || chasingFallback)) {
            return;
        }
        UUID targetId = nbt.m_128342_("targetUUID");
        Player target = server.m_46003_(targetId);
        long now = server.m_46467_();
        long spawnTick = nbt.m_128454_("spawnTick");
        if (target == null) {
            mob.m_146870_();
            return;
        }
        if (forceApplied || chasingFallback) {
            SpawnMirrorDoppelgangerProcedure.handleChargingPhase(server, (Mob)mob, target, nbt);
            return;
        }
        int tickDelay = nbt.m_128451_("tickDelay");
        if (++tickDelay >= 2) {
            int nz;
            tickDelay = 0;
            double prevX = nbt.m_128459_("prevX");
            double prevZ = nbt.m_128459_("prevZ");
            double mdx = target.m_20185_() - prevX;
            double mdz = target.m_20189_() - prevZ;
            Vec3 newPos = mob.m_20182_().m_82492_(mdx, 0.0, mdz);
            int nx = (int)Math.floor(newPos.f_82479_);
            int ny = server.m_6924_(Heightmap.Types.WORLD_SURFACE, nx, nz = (int)Math.floor(newPos.f_82481_));
            if (ny >= server.m_141937_() && ny <= server.m_151558_() - 2) {
                mob.m_7678_(newPos.f_82479_, ny, newPos.f_82481_, mob.m_146908_(), mob.m_146909_());
            }
            nbt.m_128347_("prevX", target.m_20185_());
            nbt.m_128347_("prevZ", target.m_20189_());
        }
        nbt.m_128405_("tickDelay", tickDelay);
        Vec3 diff = target.m_20182_().m_82546_(mob.m_20182_());
        float yaw = (float)Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20885_ = yaw;
        mob.f_20883_ = yaw;
        double distSq = diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_;
        if (distSq <= 16.0 && !forceApplied) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 120, 0, false, true));
            SoundEvent cave = SpawnMirrorDoppelgangerProcedure.resolveSound(SoundEvents.f_11689_);
            if (cave != null) {
                server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.85f);
            }
            mob.m_146870_();
            return;
        }
        if (!forceApplied && now >= spawnTick + 400L) {
            SpawnMirrorDoppelgangerProcedure.activateChargePhase((Mob)mob, target, nbt);
        }
    }

    private static void activateChargePhase(Mob mob, Player target, CompoundTag nbt) {
        nbt.m_128379_("forceApplied", true);
        mob.m_20256_(mob.m_20184_().m_82520_(0.0, 0.08, 0.0));
        mob.m_21557_(false);
        boolean navWorked = false;
        try {
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_5624_((Entity)target, 1.2);
                navWorked = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!navWorked) {
            nbt.m_128379_("isChasingFallback", true);
        }
        mob.m_6710_((LivingEntity)target);
    }

    private static void handleChargingPhase(ServerLevel server, Mob mob, Player target, CompoundTag nbt) {
        boolean chasingFallback = nbt.m_128471_("isChasingFallback");
        mob.m_21557_(false);
        boolean navIssued = false;
        try {
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_5624_((Entity)target, 1.2);
                navIssued = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!navIssued || chasingFallback) {
            nbt.m_128379_("isChasingFallback", true);
            Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
            double dist = Math.max(toPlayer.m_82553_(), 1.0E-6);
            Vec3 dir = toPlayer.m_82490_(1.0 / dist);
            double speed = 1.2;
            Vec3 motion = new Vec3(dir.f_82479_ * speed, mob.m_20184_().f_82480_, dir.f_82481_ * speed);
            mob.m_20256_(motion);
            try {
                mob.m_6478_(MoverType.SELF, motion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mob.m_6710_((LivingEntity)target);
        Vec3 diffFacing = target.m_20182_().m_82546_(mob.m_20182_());
        float yaw = (float)Math.toDegrees(Math.atan2(diffFacing.f_82481_, diffFacing.f_82479_)) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20885_ = yaw;
        mob.f_20883_ = yaw;
        if (mob.m_20191_().m_82381_(target.m_20191_())) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
            SoundEvent cave = SpawnMirrorDoppelgangerProcedure.resolveSound(SoundEvents.f_11689_);
            if (cave != null) {
                server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.85f);
            }
            mob.m_146870_();
        }
    }

    private static SoundEvent resolveSound(Object soundConst) {
        Object res;
        Method m2;
        if (soundConst instanceof SoundEvent) {
            SoundEvent se = (SoundEvent)soundConst;
            return se;
        }
        try {
            m2 = soundConst.getClass().getMethod("get", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("value", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void forceSpawn(ServerLevel level, Player player) {
        RandomSource rand = level.m_213780_();
        double angle = rand.m_188500_() * Math.PI * 2.0;
        double dist = 8.0 + rand.m_188500_() * 8.0;
        double dx = Math.cos(angle) * dist;
        double dz = Math.sin(angle) * dist;
        Vec3 spawnPos = player.m_20182_().m_82492_(dx, 0.0, dz);
        int mx = (int)Math.floor(spawnPos.f_82479_);
        int mz = (int)Math.floor(spawnPos.f_82481_);
        int my = level.m_6924_(Heightmap.Types.WORLD_SURFACE, mx, mz);
        FROMTHECAVES3DOPPELEntity doppel = (FROMTHECAVES3DOPPELEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVES_3_DOPPEL.get()).m_20615_((Level)level);
        if (doppel == null) {
            return;
        }
        float yaw = player.m_146908_();
        doppel.m_7678_(spawnPos.f_82479_, my, spawnPos.f_82481_, yaw, 0.0f);
        doppel.m_146922_(yaw);
        doppel.f_20885_ = yaw;
        doppel.f_20883_ = yaw;
        long now = level.m_46467_();
        CompoundTag nbt = doppel.getPersistentData();
        nbt.m_128379_("isMirror", true);
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128347_("prevX", player.m_20185_());
        nbt.m_128347_("prevZ", player.m_20189_());
        nbt.m_128405_("tickDelay", 0);
        nbt.m_128379_("forceApplied", false);
        nbt.m_128379_("isChasingFallback", false);
        doppel.m_21557_(true);
        doppel.m_21530_();
        level.m_7967_((Entity)doppel);
    }

    public static int getMirrorDelayTicks() {
        return 2;
    }

    public static int getForceDelaySeconds() {
        return 20;
    }
}

