/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TrapdoorEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int TOGGLE_DURATION = 160;
    private static final Map<Integer, TrapdoorEventState> activeEvents = new HashMap<Integer, TrapdoorEventState>();
    private static final Map<BlockPos, Long> trapdoorCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, player, baseProb, maxProb);
        if (serverLevel.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validTrapdoors = TrapdoorEventsProcedure.findValidTrapdoors(serverLevel, player);
        if (validTrapdoors.isEmpty()) {
            return;
        }
        long currentTime = serverLevel.m_46467_();
        validTrapdoors.removeIf(pos -> {
            Long cooldownUntil = trapdoorCooldowns.get(pos);
            return cooldownUntil != null && currentTime < cooldownUntil;
        });
        if (validTrapdoors.isEmpty()) {
            return;
        }
        BlockPos chosenPos = validTrapdoors.get(serverLevel.m_213780_().m_188503_(validTrapdoors.size()));
        TrapdoorEvent selectedEvent = TrapdoorEvent.values()[serverLevel.m_213780_().m_188503_(TrapdoorEvent.values().length)];
        trapdoorCooldowns.put(chosenPos, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new TrapdoorEventState(selectedEvent, player, chosenPos));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129921_() % 200 == 0) {
            long currentTime = event.getServer().m_129783_().m_46467_();
            trapdoorCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        }
        Iterator<Map.Entry<Integer, TrapdoorEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, TrapdoorEventState> entry2 = iterator.next();
            TrapdoorEventState state = entry2.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel serverLevel = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case TRAPDOOR_TOGGLE: {
                    TrapdoorEventsProcedure.handleTrapdoorToggle(serverLevel, state);
                    break;
                }
                case TRAPDOOR_ZOMBIE_SOUND: {
                    TrapdoorEventsProcedure.handleZombieSound(serverLevel, state);
                    break;
                }
                case TRAPDOOR_OPEN_EFFECTS: {
                    TrapdoorEventsProcedure.handleOpenEffects(serverLevel, state);
                }
            }
            if (state.tickCount < 160) continue;
            BlockState currentState = serverLevel.m_8055_(state.trapdoorPos);
            if (currentState.m_60734_() instanceof TrapDoorBlock) {
                serverLevel.m_7731_(state.trapdoorPos, state.originalState, 3);
            }
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidTrapdoors(ServerLevel serverLevel, Player player) {
        ArrayList<BlockPos> trapdoors = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)serverLevel.m_141937_(), (int)(serverLevel.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)serverLevel.m_141937_(), (int)(serverLevel.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = serverLevel.m_8055_(pos);
                    if (!(state.m_60734_() instanceof TrapDoorBlock)) continue;
                    trapdoors.add(pos.m_7949_());
                }
            }
        }
        return trapdoors;
    }

    private static void handleTrapdoorToggle(ServerLevel serverLevel, TrapdoorEventState state) {
        BlockState currentState;
        if (state.tickCount % 20 == 0 && (currentState = serverLevel.m_8055_(state.trapdoorPos)).m_60734_() instanceof TrapDoorBlock) {
            boolean currentlyOpen = (Boolean)currentState.m_61143_((Property)TrapDoorBlock.f_57514_);
            BlockState newState = (BlockState)currentState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(!currentlyOpen));
            serverLevel.m_7731_(state.trapdoorPos, newState, 3);
            SoundEvent soundEvent = currentlyOpen ? SoundEvents.f_12628_ : SoundEvents.f_12629_;
            serverLevel.m_5594_(null, state.trapdoorPos, soundEvent, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static void handleZombieSound(ServerLevel serverLevel, TrapdoorEventState state) {
        if (state.tickCount % 40 == 0) {
            BlockPos belowPos = state.trapdoorPos.m_7495_();
            SoundEvent soundEvent = SoundEvents.f_12599_;
            serverLevel.m_5594_(null, belowPos, soundEvent, SoundSource.HOSTILE, 0.5f, 1.0f);
        }
    }

    private static void handleOpenEffects(ServerLevel serverLevel, TrapdoorEventState state) {
        if (state.tickCount == 1) {
            BlockState currentState = serverLevel.m_8055_(state.trapdoorPos);
            if (currentState.m_60734_() instanceof TrapDoorBlock && !((Boolean)currentState.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
                serverLevel.m_7731_(state.trapdoorPos, (BlockState)currentState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true)), 3);
                SoundEvent trapdoorSound = SoundEvents.f_12629_;
                serverLevel.m_5594_(null, state.trapdoorPos, trapdoorSound, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            SoundEvent caveSound = (SoundEvent)SoundEvents.f_11689_.get();
            serverLevel.m_5594_(null, state.trapdoorPos, caveSound, SoundSource.AMBIENT, 0.5f, 1.0f);
            double x = (double)state.trapdoorPos.m_123341_() + 0.5;
            double y = (double)state.trapdoorPos.m_123342_() + 0.5;
            double z = (double)state.trapdoorPos.m_123343_() + 0.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, x, y, z, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private static enum TrapdoorEvent {
        TRAPDOOR_TOGGLE,
        TRAPDOOR_ZOMBIE_SOUND,
        TRAPDOOR_OPEN_EFFECTS;

    }

    private static class TrapdoorEventState {
        final TrapdoorEvent event;
        final Player player;
        final BlockPos trapdoorPos;
        int tickCount;
        final BlockState originalState;

        TrapdoorEventState(TrapdoorEvent event, Player player, BlockPos trapdoorPos) {
            this.event = event;
            this.player = player;
            this.trapdoorPos = trapdoorPos.m_7949_();
            this.tickCount = 0;
            this.originalState = player.m_9236_().m_8055_(trapdoorPos);
        }
    }
}

