/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase2PossessionProcedure {
    private static final double PROBABILITY = 9.0E-5;
    private static final int SEARCH_RADIUS = 10;
    private static final int RECOVERY_DELAY_TICKS = 600;
    private static final Map<Mob, SavedData> SAVED = new ConcurrentHashMap<Mob, SavedData>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.player.m_9236_().f_46443_) {
            return;
        }
        Player player = ev.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        long now = level.m_46467_();
        Iterator<Map.Entry<Mob, SavedData>> it = SAVED.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Mob, SavedData> entry = it.next();
            SavedData sd = entry.getValue();
            if (now < sd.revertAt) continue;
            Mob possessed = entry.getKey();
            BlockPos lastPos = possessed.m_20183_();
            possessed.m_146870_();
            Mob original = (Mob)sd.originalType.m_20615_((Level)level);
            if (original != null) {
                original.m_20258_(sd.nbt);
                original.m_7678_((double)lastPos.m_123341_() + 0.5, (double)lastPos.m_123342_() + 0.1, (double)lastPos.m_123343_() + 0.5, possessed.m_146908_(), possessed.m_146909_());
                level.m_7967_((Entity)original);
            }
            it.remove();
        }
        if (level.f_46441_.m_188500_() >= 9.0E-5) {
            return;
        }
        List near = level.m_6443_(Mob.class, player2.m_20191_().m_82400_(10.0), m -> m instanceof Villager || m instanceof Pig || m instanceof Cow || m instanceof Sheep || m instanceof Wolf || m instanceof WanderingTrader || m instanceof IronGolem);
        if (near.isEmpty()) {
            return;
        }
        Mob target = (Mob)near.get(level.f_46441_.m_188503_(near.size()));
        CompoundTag tag = new CompoundTag();
        target.m_20240_(tag);
        EntityType origType = target.m_6095_();
        BlockPos spawnPos = target.m_20183_();
        float yaw = target.m_146908_();
        float pitch = target.m_146909_();
        target.m_146870_();
        EntityType possessedType = null;
        if (origType == EntityType.f_20492_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_V.get();
        } else if (origType == EntityType.f_20510_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_P.get();
        } else if (origType == EntityType.f_20494_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_SURVIVOR.get();
        } else if (origType == EntityType.f_20557_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_C.get();
        } else if (origType == EntityType.f_20520_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_S.get();
        } else if (origType == EntityType.f_20499_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_W.get();
        } else if (origType == EntityType.f_20460_) {
            possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_IG.get();
        }
        if (possessedType == null) {
            return;
        }
        Mob possessed = (Mob)possessedType.m_20615_((Level)level);
        if (possessed == null) {
            return;
        }
        possessed.m_20258_(tag);
        possessed.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5, yaw, pitch);
        level.m_7967_((Entity)possessed);
        SAVED.put(possessed, new SavedData(tag, (EntityType<? extends Mob>)origType, now + 600L));
    }

    private static class SavedData {
        final CompoundTag nbt;
        final EntityType<? extends Mob> originalType;
        final long revertAt;

        SavedData(CompoundTag tag, EntityType<? extends Mob> type, long time) {
            this.nbt = tag;
            this.originalType = type;
            this.revertAt = time;
        }
    }
}

