/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVES3STABEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase3StabBehaviourProcedure {
    private static final double CHASE_SPEED = 0.65;
    private static final int DAMAGE_INTERVAL = 30;
    private static final int MAX_DURATION_TICKS = 275;
    private static final double TINY_SPEED = 1.0E-7;

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        int phase;
        boolean client;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVES3STABEntity)) {
            return;
        }
        FROMTHECAVES3STABEntity stab = (FROMTHECAVES3STABEntity)ent;
        Player closest = stab.m_9236_().m_45930_((Entity)stab, 64.0);
        if (closest != null) {
            double dx = closest.m_20185_() - stab.m_20185_();
            double dz = closest.m_20189_() - stab.m_20189_();
            double dy = closest.m_20186_() + (double)closest.m_20192_() - (stab.m_20186_() + (double)stab.m_20192_());
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float flat = (float)Math.sqrt(dx * dx + dz * dz);
            float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
            stab.m_146922_(yaw);
            stab.f_20883_ = yaw;
            stab.f_20885_ = yaw;
            stab.m_146926_(pitch);
        }
        ServerLevel level = (client = stab.m_9236_().f_46443_) ? null : (ServerLevel)stab.m_9236_();
        CompoundTag data = stab.getPersistentData();
        if (!data.m_128441_("stabStart")) {
            long now = level != null ? level.m_46467_() : 0L;
            data.m_128356_("stabStart", now);
            data.m_128405_("stabPhase", 0);
        }
        if ((phase = data.m_128451_("stabPhase")) == 0 && !client) {
            Player tgt = stab.m_9236_().m_45930_((Entity)stab, 64.0);
            if (tgt != null) {
                stab.m_21573_().m_5624_((Entity)tgt, 0.65);
                stab.m_6710_((LivingEntity)tgt);
                if ((double)stab.m_20270_((Entity)tgt) < 1.0) {
                    data.m_128405_("stabPhase", 1);
                    data.m_128356_("stabStart", level.m_46467_());
                    double orig = tgt.m_21051_(Attributes.f_22279_).m_22115_();
                    tgt.getPersistentData().m_128347_("origSpeed", orig);
                    float origWalking = tgt.m_150110_().m_35947_();
                    tgt.getPersistentData().m_128350_("origWalking", origWalking);
                    MobEffectInstance oldJump = tgt.m_21124_(MobEffects.f_19603_);
                    if (oldJump != null) {
                        tgt.getPersistentData().m_128405_("origJumpAmp", oldJump.m_19564_());
                        tgt.getPersistentData().m_128405_("origJumpDur", oldJump.m_19557_());
                        tgt.getPersistentData().m_128379_("hadJumpEffect", true);
                        tgt.m_21195_(MobEffects.f_19603_);
                    }
                    tgt.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 550, -11, false, false));
                    tgt.m_21051_(Attributes.f_22279_).m_22100_(1.0E-7);
                    tgt.m_150110_().m_35948_(1.0E-7f);
                    if (tgt instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)tgt;
                        sp.m_6885_();
                    }
                    Vec3 look = tgt.m_20154_();
                    stab.m_6021_(tgt.m_20185_() + look.f_82479_, tgt.m_20186_(), tgt.m_20189_() + look.f_82481_);
                    stab.setAnimation("animation.model.stab");
                    level.m_5594_(null, stab.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "stabbing")), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
            return;
        }
        if (phase == 1 && !client) {
            long last;
            Player tgt = level.m_45930_((Entity)stab, 2.5);
            if (tgt == null) {
                return;
            }
            tgt.m_21051_(Attributes.f_22279_).m_22100_(1.0E-7);
            tgt.m_150110_().m_35948_(1.0E-7f);
            if (tgt instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)tgt;
                sp.m_6885_();
            }
            if ((last = data.m_128454_("lastDmg")) == 0L || level.m_46467_() - last >= 30L) {
                tgt.m_6469_(stab.m_269291_().m_269333_((LivingEntity)stab), 5.0f);
                data.m_128356_("lastDmg", level.m_46467_());
                if (tgt.m_21224_()) {
                    Phase3StabBehaviourProcedure.cleanup(stab, tgt, false);
                    return;
                }
            }
            if (level.m_46467_() - data.m_128454_("stabStart") >= 275L) {
                Phase3StabBehaviourProcedure.cleanup(stab, tgt, true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof FROMTHECAVES3STABEntity)) {
            return;
        }
        FROMTHECAVES3STABEntity stab = (FROMTHECAVES3STABEntity)livingEntity;
        Entity entity = ev.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player tgt = (Player)entity;
        if (stab.m_9236_().f_46443_) {
            return;
        }
        CompoundTag data = stab.getPersistentData();
        int hits = data.m_128451_("stabHits") + 1;
        data.m_128405_("stabHits", hits);
        if (hits >= 5) {
            Phase3StabBehaviourProcedure.cleanup(stab, tgt, true);
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent ev) {
        LivingEntity target = ev.getEntity();
        LivingEntity attacker = target.m_21188_();
        if (target instanceof Player && attacker instanceof FROMTHECAVES3STABEntity) {
            ev.setCanceled(true);
        }
    }

    private static void cleanup(FROMTHECAVES3STABEntity stab, Player tgt, boolean playSound) {
        CompoundTag pd = tgt.getPersistentData();
        double orig = pd.m_128441_("origSpeed") ? pd.m_128459_("origSpeed") : 0.1;
        float origWalking = pd.m_128441_("origWalking") ? pd.m_128457_("origWalking") : 0.1f;
        tgt.m_21051_(Attributes.f_22279_).m_22100_(orig);
        tgt.m_150110_().m_35948_(origWalking);
        if (tgt instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)tgt;
            sp.m_6885_();
        }
        pd.m_128473_("origSpeed");
        pd.m_128473_("origWalking");
        tgt.m_21195_(MobEffects.f_19603_);
        if (pd.m_128471_("hadJumpEffect")) {
            int dur = pd.m_128451_("origJumpDur");
            int amp = pd.m_128451_("origJumpAmp");
            tgt.m_7292_(new MobEffectInstance(MobEffects.f_19603_, dur, amp, false, false));
            pd.m_128473_("hadJumpEffect");
            pd.m_128473_("origJumpAmp");
            pd.m_128473_("origJumpDur");
        }
        if (playSound) {
            BlockPos pos = tgt.m_20183_();
            stab.m_9236_().m_5594_(null, pos, (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        stab.m_146870_();
    }
}

