/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVESSPIDEREntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpiderAIProcedure {
    private static final double DETECT_DIST = 16.0;
    private static final double LOOK_THRESHOLD = 0.95;
    private static final double FLEE_DISTANCE = 10.0;
    private static final double MOVE_SPEED = 0.7;
    private static final int BREAK_HORIZONTAL_INTERVAL = 2;
    private static final int BREAK_VERTICAL_INTERVAL = 5;
    private static final int VERTICAL_PHASE_DURATION = 100;

    @SubscribeEvent
    public static void onSpiderTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVESSPIDEREntity)) {
            return;
        }
        FROMTHECAVESSPIDEREntity mob = (FROMTHECAVESSPIDEREntity)ent;
        Level level = mob.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        long tick = server.m_46467_();
        Player lookTarget = server.m_45930_((Entity)mob, 32.0);
        if (lookTarget != null) {
            mob.m_21563_().m_24950_(lookTarget.m_20185_(), lookTarget.m_20188_(), lookTarget.m_20189_(), 10.0f, 10.0f);
        }
        if (!data.m_128471_("startedFlee")) {
            Player p = server.m_45930_((Entity)mob, 16.0);
            boolean inRange = p != null && (double)p.m_20270_((Entity)mob) <= 16.0;
            boolean looking = false;
            if (p != null) {
                Vec3 toMob = new Vec3(mob.m_20185_() - p.m_20185_(), mob.m_20188_() - p.m_20188_(), mob.m_20189_() - p.m_20189_()).m_82541_();
                boolean bl = looking = toMob.m_82526_(p.m_20154_()) > 0.95;
            }
            if (!inRange && !looking) {
                return;
            }
            Vec3 dir = new Vec3(mob.m_20185_() - p.m_20185_(), 0.0, mob.m_20189_() - p.m_20189_()).m_82541_();
            double destX = mob.m_20185_() + dir.f_82479_ * 10.0;
            double destY = mob.m_20186_();
            double destZ = mob.m_20189_() + dir.f_82481_ * 10.0;
            data.m_128379_("startedFlee", true);
            data.m_128356_("startTick", tick);
            data.m_128379_("reachedDest", false);
            data.m_128356_("nextHorizontalBreakTick", tick);
            PathNavigation nav = mob.m_21573_();
            nav.m_26519_(destX, destY, destZ, 0.7);
            return;
        }
        if (!data.m_128471_("reachedDest")) {
            PathNavigation nav = mob.m_21573_();
            long nextHB = data.m_128454_("nextHorizontalBreakTick");
            if (tick >= nextHB) {
                data.m_128356_("nextHorizontalBreakTick", tick + 2L);
                Vec3 lookVec = mob.m_20184_().m_82541_();
                Direction step = Direction.m_122366_((double)lookVec.f_82479_, (double)0.0, (double)lookVec.f_82481_);
                BlockPos target = mob.m_20183_().m_121945_(step);
                server.m_46961_(target, false);
            }
            if (nav.m_26571_()) {
                data.m_128379_("reachedDest", true);
                data.m_128356_("nextVerticalBreakTick", tick);
            }
            return;
        }
        long start = data.m_128454_("startTick");
        if (tick - start >= 100L) {
            mob.m_146870_();
            return;
        }
        long nextVB = data.m_128454_("nextVerticalBreakTick");
        if (tick >= nextVB) {
            data.m_128356_("nextVerticalBreakTick", tick + 5L);
            BlockPos below = mob.m_20183_().m_7495_();
            for (int dx = 0; dx <= 1; ++dx) {
                for (int dz = 0; dz <= 1; ++dz) {
                    BlockPos toBreak = below.m_7918_(dx, 0, dz);
                    server.m_46961_(toBreak, false);
                }
            }
        }
    }
}

