/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CrossFloorTriggerProcedure {
    private static final double MAX_TENSION = 0.1;
    private static final double EPS_CHECK = 1.0E-9;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1) {
            return;
        }
        int chunkX = (int)Math.floor(player.m_20185_() / 16.0);
        int chunkZ = (int)Math.floor(player.m_20189_() / 16.0);
        String key = "tension_" + chunkX + "_" + chunkZ;
        ChunkTensionProcedure.TensionSavedData tensionData = (ChunkTensionProcedure.TensionSavedData)server.m_8895_().m_164861_(ChunkTensionProcedure.TensionSavedData::new, ChunkTensionProcedure.TensionSavedData::new, "from_the_caves_tension");
        double tension = tensionData.getTension(key);
        if (tension + 1.0E-9 >= 0.1) {
            tensionData.setTension(key, 0.1);
            boolean found = CrossFloorTriggerProcedure.handleChunkCrossFloor(server, chunkX, chunkZ, tensionData, key, player);
            if (found) {
                // empty if block
            }
        }
    }

    public static boolean handleChunkCrossFloor(ServerLevel server, int chunkX, int chunkZ, ChunkTensionProcedure.TensionSavedData tensionData, String key, Player debugPlayerIfAny) {
        int baseX = chunkX * 16;
        int baseZ = chunkZ * 16;
        int minY = Math.max(server.m_141937_(), 0);
        int maxY = CrossFloorTriggerProcedure.worldMaxYFallback(server);
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int worldX = baseX + dx;
                int worldZ = baseZ + dz;
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos p = new BlockPos(worldX, y, worldZ);
                    if (!server.m_46749_(p)) continue;
                    try {
                        if (!server.m_8055_(p).m_60713_((Block)FromTheCavesModBlocks.CROSS_FLOOR.get())) continue;
                        server.m_46597_(p, Blocks.f_50016_.m_49966_());
                        server.m_6263_(null, (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        tensionData.setTension(key, 0.0);
                        if (debugPlayerIfAny instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)debugPlayerIfAny;
                            if (debugPlayerIfAny.getPersistentData().m_128471_("debugAdaptiveAI")) {
                                sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 60, 0));
                                sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)" ")));
                                sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)"Cross floor triggered! Chunk tension reset.")));
                                sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)("Cross at: " + p.m_123341_() + "," + p.m_123342_() + "," + p.m_123343_()))));
                            }
                        }
                        return true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if (debugPlayerIfAny instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)debugPlayerIfAny;
            if (debugPlayerIfAny.getPersistentData().m_128471_("debugAdaptiveAI")) {
                sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)("No cross_floor found at MAX tension in chunk " + chunkX + "," + chunkZ))));
            }
        }
        return false;
    }

    private static int worldMaxYFallback(ServerLevel server) {
        try {
            return Math.min(server.m_151558_() - 1, 320);
        }
        catch (Throwable t) {
            return 255;
        }
    }
}

