/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BuiltBlocksCleanupProcedure {
    private static final long LIFETIME_TICKS = 400L;
    private static final Map<ServerLevel, Map<BlockPos, Long>> BUILT_MAPS = new ConcurrentHashMap<ServerLevel, Map<BlockPos, Long>>();

    public static void registerBuiltBlock(ServerLevel server, BlockPos pos) {
        if (server == null || pos == null) {
            return;
        }
        Map map = BUILT_MAPS.computeIfAbsent(server, s -> new ConcurrentHashMap());
        long removalTick = server.m_46467_() + 400L;
        map.put(pos.m_7949_(), removalTick);
        SoundEvent place = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.place"));
        if (place == null) {
            place = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.break"));
        }
        if (place != null) {
            server.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, place, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Map<BlockPos, Long> map = BUILT_MAPS.get(server);
        if (map == null || map.isEmpty()) {
            return;
        }
        long tick = server.m_46467_();
        Iterator<Map.Entry<BlockPos, Long>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, Long> entry = it.next();
            BlockPos pos = entry.getKey();
            long removalTick = entry.getValue();
            if (tick < removalTick) continue;
            BlockState state = server.m_8055_(pos);
            boolean isWoodPlank = state.m_60713_(Blocks.f_50705_);
            boolean isOakStairs = state.m_60713_(Blocks.f_50086_);
            if (isWoodPlank || isOakStairs) {
                SoundEvent breakSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.break"));
                if (breakSound != null) {
                    server.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, breakSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                server.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            it.remove();
        }
        if (map.isEmpty()) {
            BUILT_MAPS.remove(server);
        }
    }
}

