/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.AudioCapture;
import net.mcreator.fromthecaves.FromTheCavesMod;
import net.mcreator.fromthecaves.SessionVariables;
import net.mcreator.fromthecaves.network.FromTheCavesModMessages;
import net.mcreator.fromthecaves.network.MicrophoneLevelMessage;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves", value={Dist.CLIENT})
public class CaptureAudioProcedure {
    private static final int UPDATE_FREQUENCY = 5;
    private static String lastMixer = "";

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        UUID pid = mc.f_91074_.m_20148_();
        int tick = SessionVariables.tickCounters.getOrDefault(pid, 0);
        SessionVariables.tickCounters.put(pid, ++tick);
        String currentMixer = mc.f_91074_.getPersistentData().m_128461_("fromthecaves_selectedMixer");
        if (currentMixer == null || currentMixer.isEmpty()) {
            currentMixer = "Microphone";
            mc.f_91074_.getPersistentData().m_128359_("fromthecaves_selectedMixer", currentMixer);
        }
        if (!lastMixer.equals(currentMixer)) {
            FromTheCavesMod.LOGGER.info("Mixer changed to: " + currentMixer);
            AudioCapture.startCapture(currentMixer);
            lastMixer = currentMixer;
        }
        if (!AudioCapture.isCapturing()) {
            AudioCapture.startCapture(currentMixer);
        }
        if (tick % 5 == 0) {
            double dbLevel = AudioCapture.getDbLevel();
            SessionVariables.currentDbLevels.put(pid, dbLevel);
            try {
                FromTheCavesModMessages.sendToServer(new MicrophoneLevelMessage(pid, dbLevel));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

