/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSHADOWEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChestEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int BREATHE_DURATION = 16;
    private static final int FAKE_ITEM_DURATION = 100;
    private static final int SLAM_DISTANCE_SQR = 25;
    private static final int SLAM_TIMEOUT = 100;
    private static final int LOCKED_DURATION = 300;
    private static final int JUMPSCARE_DURATION = 16;
    private static final int CAMERA_LOCK_DURATION = 20;
    private static final int EVENT_DURATION = 240;
    private static final ResourceLocation UPSIDE_DOWN_CROSS_RL = new ResourceLocation("from_the_caves", "upside_down_cross");
    private static final Map<Integer, ChestEventState> activeEvents = new HashMap<Integer, ChestEventState>();
    private static final Map<BlockPos, Long> chestCooldowns = new HashMap<BlockPos, Long>();
    private static final Map<BlockPos, Long> lockedChests = new HashMap<BlockPos, Long>();
    private static final Map<BlockPos, Boolean> jumpscareReadyChests = new HashMap<BlockPos, Boolean>();
    private static final Map<UUID, JumpscareState> activeJumpscares = new HashMap<UUID, JumpscareState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        ChestEvent event;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validChests = ChestEventsProcedure.findValidChests(server, player);
        if (validChests.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validChests.removeIf(pos -> chestCooldowns.containsKey(pos) && currentTime < chestCooldowns.get(pos));
        if (validChests.isEmpty()) {
            return;
        }
        BlockPos chosen = validChests.get(server.m_213780_().m_188503_(validChests.size()));
        if (server.m_213780_().m_188499_()) {
            event = ChestEvent.FAKE_ITEM;
        } else {
            ChestEvent[] otherEvents = new ChestEvent[]{ChestEvent.CHEST_BREATHE, ChestEvent.CHEST_SLAM, ChestEvent.CHEST_LOCKED, ChestEvent.CHEST_LOCKED_JUMPSCARE, ChestEvent.CHEST_KNOCKING, ChestEvent.CHEST_CREAKING, ChestEvent.CHEST_VIOLENT_SHAKING};
            event = otherEvents[server.m_213780_().m_188503_(otherEvents.length)];
        }
        chestCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new ChestEventState(event, player, chosen, -1));
        ChestEventsProcedure.processJumpscares(server, currentTime);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<Map.Entry<Integer, ChestEventState>> entriesSnapshot = new ArrayList<Map.Entry<Integer, ChestEventState>>(activeEvents.entrySet());
        for (Map.Entry entry2 : entriesSnapshot) {
            Integer entryId = (Integer)entry2.getKey();
            ChestEventState state = (ChestEventState)entry2.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                activeEvents.remove(entryId);
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case CHEST_BREATHE: {
                    ChestEventsProcedure.handleChestBreathe(server, state);
                    if (state.breatheCycles > 0) break;
                    activeEvents.remove(entryId);
                    break;
                }
                case FAKE_ITEM: {
                    ChestEventsProcedure.handleFakeItem(server, state);
                    if (state.tickCount < 100 && !state.diamondPickedUp) break;
                    activeEvents.remove(entryId);
                    break;
                }
                case CHEST_SLAM: {
                    ChestEventsProcedure.handleChestSlam(server, state, entryId);
                    break;
                }
                case CHEST_LOCKED: {
                    ChestEventsProcedure.handleChestLocked(server, state, entryId);
                    break;
                }
                case CHEST_LOCKED_JUMPSCARE: {
                    ChestEventsProcedure.handleChestLockedJumpscare(server, state, entryId);
                    break;
                }
                case CHEST_KNOCKING: {
                    ChestEventsProcedure.handleChestKnocking(server, state);
                    if (state.tickCount < 240) break;
                    activeEvents.remove(entryId);
                    break;
                }
                case CHEST_CREAKING: {
                    ChestEventsProcedure.handleChestCreaking(server, state);
                    if (state.tickCount < 240) break;
                    activeEvents.remove(entryId);
                    break;
                }
                case CHEST_VIOLENT_SHAKING: {
                    ChestEventsProcedure.handleChestViolentShaking(server, state);
                    if (state.tickCount < 240) break;
                    activeEvents.remove(entryId);
                }
            }
        }
        long currentTime = ev.getServer().m_129783_().m_46467_();
        lockedChests.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        ChestEventsProcedure.processJumpscares(ev.getServer().m_129783_(), currentTime);
    }

    @SubscribeEvent
    public static void onPlayerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        ServerLevel server = (ServerLevel)level;
        long currentTime = server.m_46467_();
        if (lockedChests.containsKey(pos)) {
            if (currentTime < lockedChests.get(pos)) {
                event.setCanceled(true);
                level.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, 1.0f);
                level.m_5594_(null, pos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.8f, 0.8f);
            }
            return;
        }
        if (jumpscareReadyChests.containsKey(pos) && jumpscareReadyChests.get(pos).booleanValue() && (state = level.m_8055_(pos)).m_60734_() instanceof ChestBlock) {
            event.setCanceled(true);
            ChestEventsProcedure.triggerJumpscare(server, player, pos, currentTime);
            jumpscareReadyChests.remove(pos);
        }
    }

    private static void triggerJumpscare(ServerLevel server, Player player, BlockPos chestPos, long now) {
        FROMTHECAVESSHADOWEntity shadow = (FROMTHECAVESSHADOWEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get()).m_20615_((Level)server);
        if (shadow == null) {
            return;
        }
        shadow.m_7678_((double)chestPos.m_123341_() + 0.5, chestPos.m_123342_(), (double)chestPos.m_123343_() + 0.5, 0.0f, 0.0f);
        Vec3 toPlayer = player.m_20182_().m_82546_(shadow.m_20182_());
        float yaw = (float)(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_) * 180.0 / Math.PI) - 90.0f;
        shadow.m_146922_(yaw);
        shadow.f_20885_ = yaw;
        shadow.f_20883_ = yaw;
        shadow.m_21557_(true);
        shadow.m_20242_(true);
        shadow.m_20124_(Pose.CROUCHING);
        shadow.m_20225_(true);
        CompoundTag nbt = shadow.getPersistentData();
        nbt.m_128356_("jumpscareSpawnTick", now);
        nbt.m_128356_("jumpscareDespawnTick", now + 16L);
        nbt.m_128379_("isJumpscare", true);
        server.m_7967_((Entity)shadow);
        Vec3 playerEye = player.m_146892_();
        Vec3 mobEye = shadow.m_20182_().m_82520_(0.0, (double)shadow.m_20192_(), 0.0);
        Vec3 toMob = mobEye.m_82546_(playerEye);
        float targetYaw = (float)(Math.atan2(toMob.f_82481_, toMob.f_82479_) * 180.0 / Math.PI) - 90.0f;
        float targetPitch = (float)(-Math.atan2(toMob.f_82480_, Math.sqrt(toMob.f_82479_ * toMob.f_82479_ + toMob.f_82481_ * toMob.f_82481_)) * 180.0 / Math.PI);
        JumpscareState jumpscareState = new JumpscareState(shadow, player.m_20148_(), now, targetYaw, targetPitch);
        activeJumpscares.put(player.m_20148_(), jumpscareState);
        ResourceLocation scareSound = new ResourceLocation("from_the_caves", "it_16");
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(scareSound);
        if (sound != null) {
            server.m_5594_(null, chestPos, sound, SoundSource.AMBIENT, 1.0f, 0.6f);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
        }
    }

    private static void processJumpscares(ServerLevel server, long now) {
        activeJumpscares.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            JumpscareState state = (JumpscareState)entry.getValue();
            Player player = server.m_46003_(playerId);
            if (player == null) {
                if (state.mob != null && state.mob.m_6084_()) {
                    state.mob.m_146870_();
                }
                return true;
            }
            if (now < state.cameraLockEnd) {
                player.m_146922_(state.targetYaw);
                player.m_146926_(state.targetPitch);
                player.m_5618_(state.targetYaw);
                player.m_5616_(state.targetYaw);
                player.f_19864_ = true;
            }
            if (now >= state.startTick + 16L) {
                if (state.mob != null && state.mob.m_6084_()) {
                    state.mob.m_146870_();
                }
                return true;
            }
            return false;
        });
    }

    private static List<BlockPos> findValidChests(ServerLevel server, Player player) {
        ArrayList<BlockPos> chests = new ArrayList<BlockPos>();
        int chunkX = player.m_146902_().f_45578_;
        int chunkZ = player.m_146902_().f_45579_;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                LevelChunk chunk = server.m_6325_(chunkX + dx, chunkZ + dz);
                for (BlockPos pos : chunk.m_62954_().keySet()) {
                    if (!(server.m_8055_(pos).m_60734_() instanceof ChestBlock)) continue;
                    chests.add(pos.m_7949_());
                }
            }
        }
        return chests;
    }

    private static void handleChestBreathe(ServerLevel server, ChestEventState state) {
        if (state.tickCount % 16 == 0) {
            if (state.tickCount / 16 % 2 == 0) {
                ChestEventsProcedure.openChest(server, state.chestPos);
            } else {
                ChestEventsProcedure.closeChest(server, state.chestPos);
                --state.breatheCycles;
            }
        }
    }

    private static void handleFakeItem(ServerLevel server, ChestEventState state) {
        BlockEntity be = server.m_7702_(state.chestPos);
        if (!(be instanceof ChestBlockEntity)) {
            state.diamondPickedUp = true;
            return;
        }
        ChestBlockEntity chest = (ChestBlockEntity)be;
        if (state.tickCount == 1) {
            int emptySlot = -1;
            for (int i = 0; i < chest.m_6643_(); ++i) {
                if (!chest.m_8020_(i).m_41619_()) continue;
                emptySlot = i;
                break;
            }
            if (emptySlot == -1) {
                state.diamondPickedUp = true;
                return;
            }
            state.slot = emptySlot;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(UPSIDE_DOWN_CROSS_RL);
            if (item == null || item == Items.f_41852_) {
                state.diamondPickedUp = true;
                return;
            }
            ItemStack fakeItem = new ItemStack((ItemLike)item, 1);
            fakeItem.m_41784_().m_128379_("FromTheCavesFake", true);
            chest.m_6836_(emptySlot, fakeItem);
            chest.m_6596_();
        } else {
            ItemStack current = chest.m_8020_(state.slot);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(UPSIDE_DOWN_CROSS_RL);
            if (current.m_41619_() || item != null && current.m_41720_() != item || !current.m_41784_().m_128471_("FromTheCavesFake")) {
                state.player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                ResourceLocation ambientRL = new ResourceLocation("minecraft", "ambient.cave");
                SoundEvent ambientSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ambientRL);
                if (ambientSound != null) {
                    server.m_5594_(null, state.player.m_20183_(), ambientSound, SoundSource.AMBIENT, 1.0f, 0.5f);
                }
                state.diamondPickedUp = true;
            }
        }
    }

    private static void handleChestSlam(ServerLevel server, ChestEventState state, int entryId) {
        if (state.tickCount == 1) {
            ChestEventsProcedure.openChest(server, state.chestPos);
        } else if (state.player.m_20183_().m_123331_((Vec3i)state.chestPos) <= 25.0) {
            ChestEventsProcedure.closeChest(server, state.chestPos);
            server.m_5594_(null, state.chestPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 1.5f);
            activeEvents.remove(entryId);
        } else if (state.tickCount >= 100) {
            activeEvents.remove(entryId);
        }
    }

    private static void handleChestLocked(ServerLevel server, ChestEventState state, int entryId) {
        if (state.tickCount == 1) {
            long currentTime = server.m_46467_();
            state.lockedUntil = currentTime + 300L;
            lockedChests.put(state.chestPos, state.lockedUntil);
            server.m_5594_(null, state.chestPos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.8f, 0.8f);
            ChestEventsProcedure.closeChest(server, state.chestPos);
        }
        if (state.tickCount >= 300) {
            lockedChests.remove(state.chestPos);
            server.m_5594_(null, state.chestPos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.3f, 1.2f);
            activeEvents.remove(entryId);
        }
    }

    private static void handleChestLockedJumpscare(ServerLevel server, ChestEventState state, int entryId) {
        if (state.tickCount == 1) {
            long currentTime = server.m_46467_();
            state.lockedUntil = currentTime + 300L;
            lockedChests.put(state.chestPos, state.lockedUntil);
            state.waitingForOpen = false;
            server.m_5594_(null, state.chestPos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.8f, 0.8f);
            ChestEventsProcedure.closeChest(server, state.chestPos);
        }
        if (state.tickCount >= 300 && !state.waitingForOpen) {
            lockedChests.remove(state.chestPos);
            jumpscareReadyChests.put(state.chestPos, true);
            state.waitingForOpen = true;
            server.m_5594_(null, state.chestPos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.3f, 1.2f);
        }
        if (state.tickCount >= 1500) {
            jumpscareReadyChests.remove(state.chestPos);
            activeEvents.remove(entryId);
        }
    }

    private static void handleChestKnocking(ServerLevel server, ChestEventState state) {
        if (state.tickCount % 40 == 0 && state.knockCount > 0) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.7f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
            --state.knockCount;
        }
        if (state.knockCount == 0 && state.tickCount % 80 == 0) {
            state.knockCount = 3;
        }
    }

    private static void handleChestCreaking(ServerLevel server, ChestEventState state) {
        if (state.tickCount % 30 == 0) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.3f, 0.6f + server.m_213780_().m_188501_() * 0.3f);
        }
        if (state.tickCount % 60 == 0) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.2f, 0.5f);
        }
    }

    private static void handleChestViolentShaking(ServerLevel server, ChestEventState state) {
        if (state.tickCount % 8 == 0) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 1.0f + server.m_213780_().m_188501_() * 0.3f, 0.7f + server.m_213780_().m_188501_() * 0.4f);
            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, server.m_8055_(state.chestPos)), (double)state.chestPos.m_123341_() + 0.5, (double)state.chestPos.m_123342_() + 1.0, (double)state.chestPos.m_123343_() + 0.5, 5, 0.2, 0.3, 0.2, 0.1);
        }
        if (state.tickCount % 40 == 0) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_12599_, SoundSource.BLOCKS, 0.8f, 0.6f);
        }
        if (state.tickCount == 220) {
            server.m_5594_(null, state.chestPos, SoundEvents.f_11922_, SoundSource.HOSTILE, 0.5f, 0.4f);
        }
    }

    private static void openChest(ServerLevel server, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        if (state.m_60734_() instanceof ChestBlock) {
            server.m_7696_(pos, state.m_60734_(), 1, 1);
            server.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static void closeChest(ServerLevel server, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        if (state.m_60734_() instanceof ChestBlock) {
            server.m_7696_(pos, state.m_60734_(), 1, 0);
            server.m_5594_(null, pos, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static enum ChestEvent {
        CHEST_BREATHE,
        FAKE_ITEM,
        CHEST_SLAM,
        CHEST_LOCKED,
        CHEST_LOCKED_JUMPSCARE,
        CHEST_KNOCKING,
        CHEST_CREAKING,
        CHEST_VIOLENT_SHAKING;

    }

    private static class ChestEventState {
        ChestEvent event;
        Player player;
        BlockPos chestPos;
        int tickCount;
        int slot;
        int breatheCycles;
        boolean diamondPickedUp;
        long lockedUntil;
        boolean waitingForOpen;
        int knockCount;

        ChestEventState(ChestEvent event, Player player, BlockPos chestPos, int slot) {
            this.event = event;
            this.player = player;
            this.chestPos = chestPos;
            this.tickCount = 0;
            this.slot = slot;
            this.breatheCycles = event == ChestEvent.CHEST_BREATHE ? 3 : 0;
            this.diamondPickedUp = false;
            this.lockedUntil = 0L;
            this.waitingForOpen = false;
            this.knockCount = event == ChestEvent.CHEST_KNOCKING ? 3 : 0;
        }
    }

    private static class JumpscareState {
        FROMTHECAVESSHADOWEntity mob;
        UUID playerId;
        long startTick;
        long cameraLockEnd;
        float targetYaw;
        float targetPitch;

        JumpscareState(FROMTHECAVESSHADOWEntity mob, UUID playerId, long tick, float yaw, float pitch) {
            this.mob = mob;
            this.playerId = playerId;
            this.startTick = tick;
            this.cameraLockEnd = tick + 20L;
            this.targetYaw = yaw;
            this.targetPitch = pitch;
        }
    }
}

