/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase2PossessionProcedure {
    private static final double BASE_PROB = 2.5E-5;
    private static final double MAX_PROB = 4.0E-5;
    private static final int SEARCH_RADIUS = 20;
    private static final int RECOVERY_DELAY_TICKS = 600;
    private static final int HOSTILE_RECOVERY_DELAY_TICKS = 4400;
    private static final Map<UUID, SavedData> SAVED = new ConcurrentHashMap<UUID, SavedData>();
    private static final Map<String, SpawnTracker> SPAWN_TRACKING = new ConcurrentHashMap<String, SpawnTracker>();
    private static final Set<UUID> PROCESSING = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> POSSESSED_MOBS = ConcurrentHashMap.newKeySet();

    public static void registerExternalSpawn(BlockPos pos, EntityType<?> type, UUID uuid, long time) {
        String key = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":" + type.toString();
        SpawnTracker tracker = SPAWN_TRACKING.get(key);
        if (tracker != null && time - tracker.timestamp < 10L) {
            tracker.spawnedUUIDs.add(uuid);
        } else {
            SpawnTracker newTracker = new SpawnTracker(time);
            newTracker.spawnedUUIDs.add(uuid);
            SPAWN_TRACKING.put(key, newTracker);
        }
        if (time % 100L == 0L) {
            long now = time;
            SPAWN_TRACKING.entrySet().removeIf(entry -> now - ((SpawnTracker)entry.getValue()).timestamp > 100L);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onVanillaSpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        EntityType type = mob.m_6095_();
        if (Phase2PossessionProcedure.isPossessedMob(type)) {
            POSSESSED_MOBS.add(mob.m_20148_());
            return;
        }
        if (type != EntityType.f_20492_ && type != EntityType.f_20510_ && type != EntityType.f_20557_ && type != EntityType.f_20520_ && type != EntityType.f_20499_ && type != EntityType.f_20494_ && type != EntityType.f_20460_ && type != EntityType.f_20555_ && type != EntityType.f_20566_ && type != EntityType.f_20501_ && type != EntityType.f_20524_ && type != EntityType.f_20479_ && type != EntityType.f_20554_ && type != EntityType.f_20518_ && type != EntityType.f_20558_) {
            return;
        }
        BlockPos pos = mob.m_20183_();
        String key = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":" + type.toString();
        long now = level2.m_46467_();
        SpawnTracker tracker = SPAWN_TRACKING.get(key);
        if (tracker != null && now - tracker.timestamp < 20L) {
            if (tracker.spawnedUUIDs.contains(mob.m_20148_())) {
                event.setCanceled(true);
                return;
            }
            AABB box = new AABB(pos).m_82400_(2.0);
            List existingMobs = level2.m_6443_(mob.getClass(), box, m -> m != mob && m.m_6095_() == type);
            if (!existingMobs.isEmpty()) {
                event.setCanceled(true);
                return;
            }
            tracker.spawnedUUIDs.add(mob.m_20148_());
        } else {
            AABB box = new AABB(pos).m_82400_(2.0);
            List existingMobs = level2.m_6443_(mob.getClass(), box, m -> m != mob && m.m_6095_() == type);
            if (existingMobs.isEmpty()) {
                SpawnTracker newTracker = new SpawnTracker(now);
                newTracker.spawnedUUIDs.add(mob.m_20148_());
                SPAWN_TRACKING.put(key, newTracker);
            } else {
                event.setCanceled(true);
                return;
            }
        }
        if (now % 100L == 0L) {
            SPAWN_TRACKING.entrySet().removeIf(entry -> now - ((SpawnTracker)entry.getValue()).timestamp > 100L);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.level == null) {
            return;
        }
        if (event.level.m_5776_()) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level2) != 2) {
            return;
        }
        if (!level2.m_6042_().f_63858_()) {
            return;
        }
        long now = level2.m_46467_();
        Iterator<Map.Entry<UUID, SavedData>> it = SAVED.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, SavedData> entry = it.next();
            SavedData sd = entry.getValue();
            if (now < sd.revertAt) continue;
            Entity e = level2.m_8791_(sd.possessedUUID);
            if (!(e instanceof Mob)) {
                it.remove();
                POSSESSED_MOBS.remove(sd.possessedUUID);
                continue;
            }
            Mob possessed = (Mob)e;
            possessed.m_146870_();
            POSSESSED_MOBS.remove(sd.possessedUUID);
            Mob original = (Mob)sd.originalType.m_20615_((Level)level2);
            if (original != null) {
                original.m_20258_(sd.nbt);
                original.m_7678_((double)sd.pos.m_123341_() + 0.5, (double)sd.pos.m_123342_() + 0.1, (double)sd.pos.m_123343_() + 0.5, sd.yaw, sd.pitch);
                Phase2PossessionProcedure.registerExternalSpawn(sd.pos, sd.originalType, original.m_20148_(), now);
                level2.m_7967_((Entity)original);
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player == null) {
            return;
        }
        if (event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        if (!level.m_6042_().f_63858_()) {
            return;
        }
        long now = level.m_46467_();
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, (Player)player2, 2.5E-5, 4.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        List near = level.m_6443_(Mob.class, player2.m_20191_().m_82400_(20.0), m -> !POSSESSED_MOBS.contains(m.m_20148_()) && !PROCESSING.contains(m.m_20148_()) && (m instanceof Villager || m instanceof Pig || m instanceof Cow || m instanceof Sheep || m instanceof Wolf || m instanceof WanderingTrader || m instanceof IronGolem || m instanceof Chicken || m instanceof EnderMan || m instanceof Zombie || m instanceof Skeleton || m instanceof Spider || m instanceof CaveSpider || m instanceof Ravager || m instanceof Creeper));
        if (near.isEmpty()) {
            return;
        }
        Mob target = (Mob)near.get(level.f_46441_.m_188503_(near.size()));
        UUID origId = target.m_20148_();
        if (!PROCESSING.add(origId)) {
            return;
        }
        try {
            CompoundTag tag = new CompoundTag();
            target.m_20240_(tag);
            EntityType origType = target.m_6095_();
            BlockPos spawnPos = target.m_20183_();
            float yaw = target.m_146908_();
            float pitch = target.m_146909_();
            target.m_146870_();
            EntityType possessedType = null;
            boolean isHostileMob = false;
            if (origType == EntityType.f_20492_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_V.get();
            } else if (origType == EntityType.f_20510_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_P.get();
            } else if (origType == EntityType.f_20494_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_SURVIVOR.get();
            } else if (origType == EntityType.f_20557_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_C.get();
            } else if (origType == EntityType.f_20520_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_S.get();
            } else if (origType == EntityType.f_20499_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_W.get();
            } else if (origType == EntityType.f_20555_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_CKN.get();
            } else if (origType == EntityType.f_20460_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_IG.get();
            } else if (origType == EntityType.f_20501_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_Z.get();
                isHostileMob = true;
            } else if (origType == EntityType.f_20479_ || origType == EntityType.f_20554_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_SP.get();
                isHostileMob = true;
            } else if (origType == EntityType.f_20524_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_SK.get();
                isHostileMob = true;
            } else if (origType == EntityType.f_20566_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_END.get();
                isHostileMob = true;
            } else if (origType == EntityType.f_20558_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_CRP.get();
                isHostileMob = true;
            } else if (origType == EntityType.f_20518_) {
                possessedType = (EntityType)FromTheCavesModEntities.POSSESSED_RAVAGER.get();
                isHostileMob = true;
            }
            if (possessedType == null) {
                return;
            }
            Mob possessed = (Mob)possessedType.m_20615_((Level)level);
            if (possessed == null) {
                return;
            }
            possessed.m_20258_(tag);
            possessed.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5, yaw, pitch);
            level.m_7967_((Entity)possessed);
            POSSESSED_MOBS.add(possessed.m_20148_());
            int jitter = level.f_46441_.m_188503_(5);
            int baseDelay = isHostileMob ? 4400 : 600;
            long revertAt = now + (long)baseDelay + (long)jitter;
            SAVED.put(possessed.m_20148_(), new SavedData(tag, (EntityType<? extends Mob>)origType, revertAt, possessed.m_20148_(), spawnPos, yaw, pitch));
        }
        finally {
            PROCESSING.remove(origId);
        }
    }

    private static boolean isPossessedMob(EntityType<?> type) {
        return type == FromTheCavesModEntities.POSSESSED_V.get() || type == FromTheCavesModEntities.POSSESSED_P.get() || type == FromTheCavesModEntities.POSSESSED_C.get() || type == FromTheCavesModEntities.POSSESSED_CKN.get() || type == FromTheCavesModEntities.POSSESSED_S.get() || type == FromTheCavesModEntities.POSSESSED_SURVIVOR.get() || type == FromTheCavesModEntities.POSSESSED_W.get() || type == FromTheCavesModEntities.POSSESSED_IG.get() || type == FromTheCavesModEntities.POSSESSED_Z.get() || type == FromTheCavesModEntities.POSSESSED_SK.get() || type == FromTheCavesModEntities.POSSESSED_SP.get() || type == FromTheCavesModEntities.POSSESSED_CRP.get() || type == FromTheCavesModEntities.POSSESSED_END.get() || type == FromTheCavesModEntities.POSSESSED_RAVAGER.get();
    }

    private static class SpawnTracker {
        final Set<UUID> spawnedUUIDs = new HashSet<UUID>();
        final long timestamp;

        SpawnTracker(long time) {
            this.timestamp = time;
        }
    }

    private static class SavedData {
        final CompoundTag nbt;
        final EntityType<? extends Mob> originalType;
        final long revertAt;
        final UUID possessedUUID;
        final BlockPos pos;
        final float yaw;
        final float pitch;

        SavedData(CompoundTag tag, EntityType<? extends Mob> type, long time, UUID possessedUUID, BlockPos pos, float yaw, float pitch) {
            this.nbt = tag;
            this.originalType = type;
            this.revertAt = time;
            this.possessedUUID = possessedUUID;
            this.pos = pos;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

