/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhotosensitiveSafetyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LightEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 4.0E-5;
    private static final double BASE_PROB_PHASE2 = 4.0E-5;
    private static final double MAX_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_SOUND_DISTANCE = 10.0;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 600;
    private static final int EXTINGUISH_DURATION = 200;
    private static final int MORSE_DOT_TICKS = 4;
    private static final int MORSE_DASH_TICKS = 12;
    private static final int MORSE_GAP_TICKS = 8;
    private static final int DARKNESS_PULSE_RADIUS = 8;
    private static final int DARKNESS_PULSE_DURATION = 600;
    private static final Map<Integer, LightEventState> activeEvents = new HashMap<Integer, LightEventState>();
    private static final Map<BlockPos, Long> torchCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        List<TorchInfo> torches;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        if (PhotosensitiveSafetyProcedure.isPhotosensitiveModeEnabled((LevelAccessor)level)) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 4.0E-5;
        double maxProb = phase == 1 ? 4.0E-5 : 4.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        LightEvent event = LightEvent.values()[server.m_213780_().m_188503_(LightEvent.values().length)];
        List<TorchInfo> list = torches = event != LightEvent.DARKNESS_PULSE ? LightEventsProcedure.findNearbyTorches(server, player) : null;
        if (!(event != LightEvent.TORCH_EXTINGUISH && event != LightEvent.LIGHT_FLICKER_MORSE && event != LightEvent.SHADOW_SWEEP && event != LightEvent.TORCH_FADE_TRAIL || torches != null && !torches.isEmpty())) {
            return;
        }
        if (event != LightEvent.DARKNESS_PULSE) {
            long currentTime = server.m_46467_();
            torches.removeIf(torch -> torchCooldowns.containsKey(torch.pos) && currentTime < torchCooldowns.get(torch.pos));
            if (torches.isEmpty()) {
                return;
            }
            torches.forEach(torch -> torchCooldowns.put(torch.pos, currentTime + 600L));
        }
        LightEventState st = new LightEventState(event, player, torches);
        if (event == LightEvent.SHADOW_SWEEP) {
            LightEventsProcedure.prepareShadowSweepQueue(server, st);
        }
        if (event == LightEvent.TORCH_FADE_TRAIL) {
            LightEventsProcedure.prepareTorchFadeTrailQueue(server, st);
        }
        activeEvents.put(eventIdCounter++, st);
    }

    private static List<TorchInfo> findNearbyTorches(ServerLevel server, Player player) {
        ArrayList<TorchInfo> torches = new ArrayList<TorchInfo>();
        int radiusBlocks = 32;
        int minX = player.m_20183_().m_123341_() - radiusBlocks;
        int maxX = player.m_20183_().m_123341_() + radiusBlocks;
        int minZ = player.m_20183_().m_123343_() - radiusBlocks;
        int maxZ = player.m_20183_().m_123343_() + radiusBlocks;
        int minY = Math.max(0, player.m_20183_().m_123342_() - 6);
        int maxY = Math.min(server.m_151558_() - 1, player.m_20183_().m_123342_() + 6);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof TorchBlock && !(block instanceof WallTorchBlock)) {
                        torches.add(new TorchInfo(pos.m_7949_(), state, false, null, false, false));
                        continue;
                    }
                    if (block instanceof WallTorchBlock) {
                        Direction facing = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
                        torches.add(new TorchInfo(pos.m_7949_(), state, true, facing, false, false));
                        continue;
                    }
                    if (block instanceof CandleBlock) {
                        torches.add(new TorchInfo(pos.m_7949_(), state, false, null, true, false));
                        continue;
                    }
                    if (!(block instanceof CandleCakeBlock)) continue;
                    torches.add(new TorchInfo(pos.m_7949_(), state, false, null, false, true));
                }
            }
        }
        return torches;
    }

    private static void prepareShadowSweepQueue(ServerLevel server, LightEventState state) {
        BlockPos center = state.player.m_20183_();
        Direction dir = Direction.Plane.HORIZONTAL.m_122557_().skip(server.m_213780_().m_188503_(4)).findFirst().orElse(Direction.NORTH);
        int maxSteps = 10;
        for (int s = 1; s <= maxSteps; ++s) {
            BlockPos p = center.m_5484_(dir, s);
            BlockState st = server.m_8055_(p);
            Block block = st.m_60734_();
            if (!(block instanceof TorchBlock) && !(block instanceof WallTorchBlock) && !(block instanceof CandleBlock) && !(block instanceof CandleCakeBlock)) continue;
            state.queue.add(p.m_7949_());
        }
        Collections.shuffle(state.queue, new Random(server.m_213780_().m_188505_()));
    }

    private static void prepareTorchFadeTrailQueue(ServerLevel server, LightEventState state) {
        BlockPos center = state.player.m_20183_();
        Direction look = state.player.m_6350_();
        int maxSteps = 12;
        for (int s = 1; s <= maxSteps; ++s) {
            BlockPos p = center.m_5484_(look.m_122424_(), s);
            BlockState st = server.m_8055_(p);
            Block block = st.m_60734_();
            if (!(block instanceof TorchBlock) && !(block instanceof WallTorchBlock) && !(block instanceof CandleBlock) && !(block instanceof CandleCakeBlock)) continue;
            state.queue.add(p.m_7949_());
        }
        Collections.shuffle(state.queue, new Random(server.m_213780_().m_188505_()));
    }

    private static void handleTorchExtinguish(ServerLevel server, LightEventState state, Block unlitFloor, Block unlitWall) {
        if (state.tickCount == 1) {
            BlockPos soundPos;
            Player p;
            for (TorchInfo torch : state.torches) {
                BlockState newState;
                if (torch.isWall) {
                    newState = (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)torch.facing);
                    server.m_7731_(torch.pos, newState, 3);
                    continue;
                }
                if (torch.isCandle || torch.isCandleCake) {
                    newState = (BlockState)torch.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                    server.m_7731_(torch.pos, newState, 3);
                    continue;
                }
                server.m_7731_(torch.pos, unlitFloor.m_49966_(), 3);
            }
            if (!state.soundPlayed && !state.torches.isEmpty() && (p = server.m_45924_((double)(soundPos = state.torches.get((int)0).pos).m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false)) != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 1.0f);
                state.soundPlayed = true;
            }
        } else if (state.tickCount >= 200) {
            Player p;
            BlockPos soundPos = state.torches.iterator();
            while (soundPos.hasNext()) {
                TorchInfo torch = soundPos.next();
                Block current = server.m_8055_(torch.pos).m_60734_();
                if (current == unlitFloor || current == unlitWall) {
                    server.m_7731_(torch.pos, torch.state, 3);
                    continue;
                }
                if (!torch.isCandle && !torch.isCandleCake) continue;
                BlockState newState = (BlockState)torch.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                server.m_7731_(torch.pos, newState, 3);
            }
            if (!state.torches.isEmpty() && (p = server.m_45924_((double)(soundPos = state.torches.get((int)0).pos).m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false)) != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 1.5f);
            }
        }
    }

    private static void handleLightFlickerMorse(ServerLevel server, LightEventState state, Block unlitFloor, Block unlitWall) {
        if (state.morseIndex >= state.morseCode.length()) {
            return;
        }
        char c = state.morseCode.charAt(state.morseIndex);
        int ticksPerAction = c == '.' ? 4 : (c == '-' ? 12 : 8);
        int cycle = ticksPerAction + 8;
        int phaseInCycle = (state.tickCount - 1) % cycle;
        if (phaseInCycle < ticksPerAction) {
            BlockPos soundPos;
            Player p;
            if (phaseInCycle == 0 && !state.torches.isEmpty() && (p = server.m_45924_((double)(soundPos = state.torches.get((int)0).pos).m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false)) != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 0.8f);
            }
            for (TorchInfo torch : state.torches) {
                BlockState newState;
                if (torch.isWall) {
                    newState = (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)torch.facing);
                    server.m_7731_(torch.pos, newState, 3);
                    continue;
                }
                if (torch.isCandle || torch.isCandleCake) {
                    newState = (BlockState)torch.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                    server.m_7731_(torch.pos, newState, 3);
                    continue;
                }
                server.m_7731_(torch.pos, unlitFloor.m_49966_(), 3);
            }
        } else if (phaseInCycle == ticksPerAction) {
            BlockPos soundPos;
            Player p;
            if (!state.torches.isEmpty() && (p = server.m_45924_((double)(soundPos = state.torches.get((int)0).pos).m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false)) != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 1.2f);
            }
            for (TorchInfo torch : state.torches) {
                Block current = server.m_8055_(torch.pos).m_60734_();
                if (current == unlitFloor || current == unlitWall) {
                    server.m_7731_(torch.pos, torch.state, 3);
                    continue;
                }
                if (!torch.isCandle && !torch.isCandleCake) continue;
                BlockState newState = (BlockState)torch.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                server.m_7731_(torch.pos, newState, 3);
            }
            ++state.morseIndex;
        }
    }

    private static void handleDarknessPulse(ServerLevel server, LightEventState state) {
        if (state.tickCount == 1) {
            BlockPos soundPos;
            Player p;
            BlockPos center = state.player.m_20183_();
            state.lightLevels = new HashMap<BlockPos, Integer>();
            int r = 8;
            int r2 = r * r;
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    for (int z = -r; z <= r; ++z) {
                        int dz;
                        int dy;
                        BlockPos pos = center.m_7918_(x, y, z);
                        int dx = center.m_123341_() - pos.m_123341_();
                        if (dx * dx + (dy = center.m_123342_() - pos.m_123342_()) * dy + (dz = center.m_123343_() - pos.m_123343_()) * dz > r2) continue;
                        int lightLevel = server.m_7146_(pos);
                        state.lightLevels.put(pos.m_7949_(), lightLevel);
                        server.m_7260_(pos, server.m_8055_(pos), server.m_8055_(pos), 3);
                    }
                }
            }
            if (!state.soundPlayed && (p = server.m_45924_((double)(soundPos = state.player.m_20183_()).m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false)) != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.AMBIENT, 0.1f, 0.5f);
                state.soundPlayed = true;
            }
        } else if (state.tickCount >= 600) {
            for (BlockPos pos : state.lightLevels.keySet()) {
                server.m_7260_(pos, server.m_8055_(pos), server.m_8055_(pos), 3);
            }
            BlockPos soundPos = state.player.m_20183_();
            Player p = server.m_45924_((double)soundPos.m_123341_() + 0.5, (double)soundPos.m_123342_() + 0.5, (double)soundPos.m_123343_() + 0.5, 10.0, false);
            if (p != null) {
                server.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.AMBIENT, 0.1f, 1.5f);
            }
        }
    }

    private static void handleShadowSweep(ServerLevel server, LightEventState state, Block unlitFloor, Block unlitWall) {
        int INTERVAL = 6;
        if (state.tickCount % 6 == 1 && state.queueIndex < state.queue.size()) {
            BlockPos target = state.queue.get(state.queueIndex);
            BlockState cur = server.m_8055_(target);
            Block block = cur.m_60734_();
            if (block instanceof WallTorchBlock) {
                Direction facing = (Direction)cur.m_61143_((Property)WallTorchBlock.f_58119_);
                server.m_7731_(target, (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)facing), 3);
            } else if (block instanceof TorchBlock) {
                server.m_7731_(target, unlitFloor.m_49966_(), 3);
            } else if (block instanceof CandleBlock || block instanceof CandleCakeBlock) {
                BlockState newState = (BlockState)cur.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                server.m_7731_(target, newState, 3);
            }
            double px = (double)target.m_123341_() + 0.5;
            double py = (double)target.m_123342_() + 0.7;
            double pz = (double)target.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 6, 0.1, 0.1, 0.1, 0.02);
            Player p = server.m_45924_(px, py, pz, 10.0, false);
            if (p != null) {
                server.m_5594_(null, target, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 0.8f);
            }
            ++state.queueIndex;
        }
    }

    private static void handleTorchFadeTrail(ServerLevel server, LightEventState state, Block unlitFloor, Block unlitWall) {
        int INTERVAL = 8;
        if (state.tickCount % 8 == 1 && state.queueIndex < state.queue.size()) {
            BlockPos target = state.queue.get(state.queueIndex);
            BlockState cur = server.m_8055_(target);
            Block block = cur.m_60734_();
            if (block instanceof WallTorchBlock) {
                Direction facing = (Direction)cur.m_61143_((Property)WallTorchBlock.f_58119_);
                server.m_7731_(target, (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)facing), 3);
            } else if (block instanceof TorchBlock) {
                server.m_7731_(target, unlitFloor.m_49966_(), 3);
            } else if (block instanceof CandleBlock || block instanceof CandleCakeBlock) {
                BlockState newState = (BlockState)cur.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                server.m_7731_(target, newState, 3);
            }
            double px = (double)target.m_123341_() + 0.5;
            double py = (double)target.m_123342_() + 0.5;
            double pz = (double)target.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, 4, 0.1, 0.1, 0.1, 0.01);
            Player p = server.m_45924_(px, py, pz, 10.0, false);
            if (p != null) {
                server.m_5594_(null, target, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 0.9f);
            }
            ++state.queueIndex;
        }
    }

    private static String pickRandomMorse() {
        List<String> codes = Arrays.asList("...---...", ".-..-", "-.-..-", "..-..");
        Random r = new Random();
        return codes.get(r.nextInt(codes.size()));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, LightEventState>> iterator = activeEvents.entrySet().iterator();
        Block unlitFloor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
        Block unlitWall = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
        if (unlitFloor == null || unlitWall == null) {
            activeEvents.clear();
            return;
        }
        block7: while (iterator.hasNext()) {
            Map.Entry<Integer, LightEventState> entry = iterator.next();
            LightEventState state = entry.getValue();
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case TORCH_EXTINGUISH: {
                    LightEventsProcedure.handleTorchExtinguish(server, state, unlitFloor, unlitWall);
                    if (state.tickCount < 200) continue block7;
                    iterator.remove();
                    continue block7;
                }
                case LIGHT_FLICKER_MORSE: {
                    LightEventsProcedure.handleLightFlickerMorse(server, state, unlitFloor, unlitWall);
                    if (state.morseIndex < state.morseCode.length()) continue block7;
                    iterator.remove();
                    continue block7;
                }
                case DARKNESS_PULSE: {
                    LightEventsProcedure.handleDarknessPulse(server, state);
                    if (state.tickCount < 600) continue block7;
                    iterator.remove();
                    continue block7;
                }
                case SHADOW_SWEEP: {
                    LightEventsProcedure.handleShadowSweep(server, state, unlitFloor, unlitWall);
                    if (state.queueIndex < state.queue.size()) continue block7;
                    iterator.remove();
                    continue block7;
                }
                case TORCH_FADE_TRAIL: {
                    LightEventsProcedure.handleTorchFadeTrail(server, state, unlitFloor, unlitWall);
                    if (state.queueIndex < state.queue.size()) continue block7;
                    iterator.remove();
                    continue block7;
                }
            }
            iterator.remove();
        }
    }

    private static enum LightEvent {
        TORCH_EXTINGUISH,
        LIGHT_FLICKER_MORSE,
        DARKNESS_PULSE,
        SHADOW_SWEEP,
        TORCH_FADE_TRAIL;

    }

    private static class LightEventState {
        LightEvent event;
        Player player;
        List<TorchInfo> torches;
        int tickCount;
        String morseCode;
        int morseIndex;
        Map<BlockPos, Integer> lightLevels;
        boolean soundPlayed;
        List<BlockPos> queue;
        int queueIndex;

        LightEventState(LightEvent event, Player player, List<TorchInfo> torches) {
            this.event = event;
            this.player = player;
            this.torches = torches;
            this.tickCount = 0;
            this.morseCode = event == LightEvent.LIGHT_FLICKER_MORSE ? LightEventsProcedure.pickRandomMorse() : "";
            this.morseIndex = 0;
            this.lightLevels = event == LightEvent.DARKNESS_PULSE ? new HashMap() : null;
            this.soundPlayed = false;
            this.queue = new ArrayList<BlockPos>();
            this.queueIndex = 0;
        }
    }

    private static class TorchInfo {
        final BlockPos pos;
        final BlockState state;
        final boolean isWall;
        final Direction facing;
        final boolean isCandle;
        final boolean isCandleCake;

        TorchInfo(BlockPos pos, BlockState state, boolean isWall, Direction facing, boolean isCandle, boolean isCandleCake) {
            this.pos = pos;
            this.state = state;
            this.isWall = isWall;
            this.facing = facing;
            this.isCandle = isCandle;
            this.isCandleCake = isCandleCake;
        }
    }
}

