/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import net.mcreator.fromthecaves.entity.PossessedRavagerEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedRavagerChargeProcedure {
    private static final double NORMAL_SPEED = 1.0;
    private static final double CHARGE_SPEED = 1.6;
    private static final int STARE_DURATION = 16;
    private static final int MAX_CHARGE_DURATION = 200;
    private static final int ABILITY_COOLDOWN = 100;
    private static final double MOVEMENT_THRESHOLD = 0.005;
    private static final double CHARGE_PROBABILITY = 0.01;
    private static final double JUMP_PROBABILITY = 0.007;
    private static final double STOMP_PROBABILITY = 0.008;
    private static final double ROAR_PROBABILITY = 0.006;
    private static final double ATTACK_RANGE = 3.5;
    private static final float ATTACK_DAMAGE = 6.0f;
    private static final double CHARGE_TRIGGER_DISTANCE_MIN = 6.0;
    private static final double CHARGE_TRIGGER_DISTANCE_MAX = 18.0;
    private static final double JUMP_TRIGGER_DISTANCE_MIN = 10.0;
    private static final double JUMP_TRIGGER_DISTANCE_MAX = 25.0;
    private static final double STOMP_DAMAGE_RANGE = 5.0;
    private static final float STOMP_DAMAGE = 10.0f;
    private static final double ROAR_RANGE = 8.0;
    private static final float ROAR_DAMAGE = 4.0f;

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof PossessedRavagerEntity)) {
            return;
        }
        PossessedRavagerEntity ravager = (PossessedRavagerEntity)livingEntity;
        if (ravager.m_9236_().f_46443_) {
            return;
        }
        CompoundTag pd = ravager.getPersistentData();
        long now = ravager.m_9236_().m_46467_();
        pd.m_128356_("ravager_last_hit", now);
        pd.m_128379_("ravager_is_angry", true);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        long lastHit;
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof PossessedRavagerEntity)) {
            return;
        }
        PossessedRavagerEntity ravager = (PossessedRavagerEntity)livingEntity;
        if (ravager.m_9236_().f_46443_) {
            return;
        }
        ServerLevel server = (ServerLevel)ravager.m_9236_();
        Player tgt = server.m_45930_((Entity)ravager, 64.0);
        if (tgt == null) {
            PossessedRavagerChargeProcedure.resetRavagerState(ravager);
            return;
        }
        CompoundTag pd = ravager.getPersistentData();
        long now = server.m_46467_();
        boolean isAngry = now - (lastHit = pd.m_128454_("ravager_last_hit")) < 100L;
        pd.m_128379_("ravager_is_angry", isAngry);
        int abilityState = pd.m_128451_("ravager_ability_state");
        long abilityStart = pd.m_128454_("ravager_ability_start");
        double chargeYaw = pd.m_128459_("ravager_charge_yaw");
        Vec3 lastPos = new Vec3(pd.m_128459_("ravager_last_x"), pd.m_128459_("ravager_last_y"), pd.m_128459_("ravager_last_z"));
        long lastAbilityEnd = pd.m_128454_("ravager_last_ability_end");
        double dist = ravager.m_20270_((Entity)tgt);
        switch (abilityState) {
            case 0: {
                PossessedRavagerChargeProcedure.handleNormalState(ravager, tgt, pd, now, lastAbilityEnd, dist, server, isAngry);
                break;
            }
            case 1: {
                PossessedRavagerChargeProcedure.handleChargeStareState(ravager, tgt, pd, now, abilityStart);
                break;
            }
            case 2: {
                PossessedRavagerChargeProcedure.handleChargeRunState(ravager, tgt, pd, now, abilityStart, chargeYaw, lastPos, server);
                break;
            }
            case 3: {
                PossessedRavagerChargeProcedure.handleJumpPrepareState(ravager, tgt, pd, now, abilityStart);
                break;
            }
            case 4: {
                PossessedRavagerChargeProcedure.handleJumpAirState(ravager, tgt, pd, now, abilityStart, server);
                break;
            }
            case 5: {
                PossessedRavagerChargeProcedure.handleStompPrepareState(ravager, tgt, pd, now, abilityStart);
                break;
            }
            case 6: {
                PossessedRavagerChargeProcedure.handleStompExecuteState(ravager, tgt, pd, now, abilityStart, server);
                break;
            }
            case 7: {
                PossessedRavagerChargeProcedure.handleRoarPrepareState(ravager, tgt, pd, now, abilityStart);
                break;
            }
            case 8: {
                PossessedRavagerChargeProcedure.handleRoarExecuteState(ravager, tgt, pd, now, abilityStart, server);
            }
        }
    }

    private static void handleNormalState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long lastAbilityEnd, double dist, ServerLevel server, boolean isAngry) {
        double roarProbMod;
        int cooldown;
        double currentSpeed;
        ravager.m_6710_((LivingEntity)tgt);
        ravager.setCharging(false);
        double d = currentSpeed = isAngry ? 1.3 : 1.0;
        if (dist > 3.5) {
            ravager.m_21573_().m_5624_((Entity)tgt, currentSpeed);
        } else {
            ravager.m_21573_().m_26573_();
            long lastAttack = pd.m_128454_("ravager_last_attack");
            if (now - lastAttack >= 20L) {
                float damage = isAngry ? 7.7999997f : 6.0f;
                tgt.m_6469_(ravager.m_269291_().m_269333_((LivingEntity)ravager), damage);
                pd.m_128356_("ravager_last_attack", now);
                tgt.m_147240_(0.5, ravager.m_20185_() - tgt.m_20185_(), ravager.m_20189_() - tgt.m_20189_());
            }
        }
        int n = cooldown = isAngry ? 50 : 100;
        if (now - lastAbilityEnd < (long)cooldown) {
            return;
        }
        double chargeProbMod = isAngry ? 0.015 : 0.01;
        double jumpProbMod = isAngry ? 0.0105 : 0.007;
        double stompProbMod = isAngry ? 0.012 : 0.008;
        double d2 = roarProbMod = isAngry ? 0.0108 : 0.006;
        if (dist >= 6.0 && dist <= 18.0 && Math.random() < chargeProbMod) {
            PossessedRavagerChargeProcedure.startChargeAbility(ravager, tgt, pd, now);
            return;
        }
        if (dist >= 10.0 && dist <= 25.0 && Math.random() < jumpProbMod) {
            PossessedRavagerChargeProcedure.startJumpAbility(ravager, tgt, pd, now);
            return;
        }
        if (dist >= 3.0 && dist <= 8.0 && Math.random() < stompProbMod) {
            PossessedRavagerChargeProcedure.startStompAbility(ravager, tgt, pd, now);
            return;
        }
        if (dist >= 4.0 && dist <= 10.0 && Math.random() < roarProbMod) {
            PossessedRavagerChargeProcedure.startRoarAbility(ravager, tgt, pd, now);
            return;
        }
    }

    private static void startChargeAbility(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now) {
        pd.m_128405_("ravager_ability_state", 1);
        pd.m_128356_("ravager_ability_start", now);
        ravager.m_21573_().m_26573_();
        ravager.m_20334_(0.0, ravager.m_20184_().f_82480_, 0.0);
        double dx = tgt.m_20185_() - ravager.m_20185_();
        double dz = tgt.m_20189_() - ravager.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        pd.m_128347_("ravager_charge_yaw", (double)yaw);
        ravager.m_146922_(yaw);
        ravager.f_20883_ = yaw;
        ravager.f_20885_ = yaw;
        ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 2.0f, 0.7f);
    }

    private static void handleChargeStareState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart) {
        long elapsed = now - abilityStart;
        ravager.m_21573_().m_26573_();
        ravager.m_20334_(0.0, ravager.m_20184_().f_82480_, 0.0);
        double dx = tgt.m_20185_() - ravager.m_20185_();
        double dz = tgt.m_20189_() - ravager.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (ravager.m_20186_() + (double)ravager.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        ravager.m_146922_(yaw);
        ravager.f_20883_ = yaw;
        ravager.f_20885_ = yaw;
        ravager.m_146926_(pitch);
        pd.m_128347_("ravager_charge_yaw", (double)yaw);
        if (elapsed % 3L == 0L) {
            ServerLevel level = (ServerLevel)ravager.m_9236_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, ravager.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 0.5, ravager.m_20186_() + 1.8, ravager.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (elapsed >= 16L) {
            pd.m_128405_("ravager_ability_state", 2);
            pd.m_128356_("ravager_ability_start", now);
            ravager.setCharging(true);
            pd.m_128347_("ravager_last_x", ravager.m_20185_());
            pd.m_128347_("ravager_last_y", ravager.m_20186_());
            pd.m_128347_("ravager_last_z", ravager.m_20189_());
        }
    }

    private static void handleChargeRunState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart, double chargeYaw, Vec3 lastPos, ServerLevel server) {
        long elapsed = now - abilityStart;
        boolean isAngry = pd.m_128471_("ravager_is_angry");
        double currentChargeSpeed = isAngry ? 1.92 : 1.6;
        float targetYaw = (float)chargeYaw;
        ravager.m_146922_(targetYaw);
        ravager.f_20883_ = targetYaw;
        ravager.f_20885_ = targetYaw;
        double radYaw = Math.toRadians(targetYaw + 90.0f);
        double dirX = Math.cos(radYaw);
        double dirZ = Math.sin(radYaw);
        double targetX = ravager.m_20185_() + dirX * 100.0;
        double targetZ = ravager.m_20189_() + dirZ * 100.0;
        ravager.m_21573_().m_26519_(targetX, ravager.m_20186_(), targetZ, currentChargeSpeed);
        if (elapsed % 3L == 0L) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, ravager.m_20185_(), ravager.m_20186_() + 1.5, ravager.m_20189_(), 2, 0.3, 0.3, 0.3, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, ravager.m_20185_() - dirX * 0.5, ravager.m_20186_() + 0.2, ravager.m_20189_() - dirZ * 0.5, 3, 0.2, 0.1, 0.2, 0.02);
        }
        if (elapsed % 10L == 0L) {
            ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12361_, SoundSource.HOSTILE, 1.5f, 0.8f);
        }
        Vec3 currentPos = ravager.m_20182_();
        double distMoved = currentPos.m_82554_(lastPos);
        AABB hitbox = ravager.m_20191_().m_82400_(1.5);
        List hitEntities = server.m_6443_(LivingEntity.class, hitbox, e -> e != ravager && e instanceof Player);
        for (LivingEntity entity : hitEntities) {
            long lastHit = pd.m_128454_("ravager_charge_last_hit_" + String.valueOf(entity.m_20148_()));
            if (now - lastHit < 10L) continue;
            float damage = isAngry ? 15.0f : 12.0f;
            entity.m_6469_(ravager.m_269291_().m_269333_((LivingEntity)ravager), damage);
            entity.m_147240_(2.0, ravager.m_20185_() - entity.m_20185_(), ravager.m_20189_() - entity.m_20189_());
            pd.m_128356_("ravager_charge_last_hit_" + String.valueOf(entity.m_20148_()), now);
        }
        boolean hasStoppedMoving = distMoved < 0.005;
        pd.m_128347_("ravager_last_x", currentPos.f_82479_);
        pd.m_128347_("ravager_last_y", currentPos.f_82480_);
        pd.m_128347_("ravager_last_z", currentPos.f_82481_);
        if (elapsed >= 200L || hasStoppedMoving) {
            PossessedRavagerChargeProcedure.endAbility(ravager, pd, now);
        }
    }

    private static void startJumpAbility(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now) {
        pd.m_128405_("ravager_ability_state", 3);
        pd.m_128356_("ravager_ability_start", now);
        ravager.m_21573_().m_26573_();
        double dx = tgt.m_20185_() - ravager.m_20185_();
        double dz = tgt.m_20189_() - ravager.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        ravager.m_146922_(yaw);
        ravager.f_20883_ = yaw;
        ravager.f_20885_ = yaw;
        pd.m_128347_("jump_target_x", tgt.m_20185_());
        pd.m_128347_("jump_target_y", tgt.m_20186_());
        pd.m_128347_("jump_target_z", tgt.m_20189_());
        ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12362_, SoundSource.HOSTILE, 1.5f, 0.4f);
    }

    private static void handleJumpPrepareState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart) {
        long elapsed = now - abilityStart;
        ravager.m_21573_().m_26573_();
        if (elapsed % 2L == 0L && elapsed < 20L) {
            ServerLevel level = (ServerLevel)ravager.m_9236_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, ravager.m_20185_(), ravager.m_20186_() + 0.1, ravager.m_20189_(), 5, 0.3, 0.1, 0.3, 0.02);
        }
        if (elapsed >= 20L) {
            double lenXZ;
            double targetX = pd.m_128459_("jump_target_x");
            double targetY = pd.m_128459_("jump_target_y");
            double targetZ = pd.m_128459_("jump_target_z");
            double dx = targetX - ravager.m_20185_();
            double dy = targetY - ravager.m_20186_();
            double dz = targetZ - ravager.m_20189_();
            double dist = Math.sqrt(dx * dx + dz * dz);
            double velocityXZ = 1.2;
            double velocityY = 1.0 + dist * 0.04;
            if (dy > 0.0) {
                velocityY += dy * 0.15;
            }
            double nx = (lenXZ = Math.sqrt(dx * dx + dz * dz)) > 1.0E-6 ? dx / lenXZ : 0.0;
            double nz = lenXZ > 1.0E-6 ? dz / lenXZ : 0.0;
            Vec3 motion = new Vec3(nx * velocityXZ, velocityY, nz * velocityXZ);
            ravager.m_20256_(motion);
            pd.m_128405_("ravager_ability_state", 4);
            pd.m_128356_("ravager_ability_start", now);
            ServerLevel level = (ServerLevel)ravager.m_9236_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 8, 0.5, 0.1, 0.5, 0.0);
            ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12357_, SoundSource.HOSTILE, 2.0f, 0.6f);
        }
    }

    private static void handleJumpAirState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart, ServerLevel server) {
        long elapsed = now - abilityStart;
        if (elapsed % 2L == 0L) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 2, 0.2, 0.2, 0.2, 0.01);
        }
        if (ravager.m_20096_() || elapsed > 80L) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 15, 1.5, 0.5, 1.5, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 30, 2.0, 0.5, 2.0, 0.1);
            server.m_5594_(null, ravager.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.9f);
            boolean isAngry = pd.m_128471_("ravager_is_angry");
            float damage = isAngry ? 13.0f : 10.0f;
            for (Player player : server.m_6907_()) {
                if (!((double)player.m_20270_((Entity)ravager) <= 5.0)) continue;
                player.m_6469_(ravager.m_269291_().m_269333_((LivingEntity)ravager), damage);
                double kb = 1.5 + (5.0 - (double)player.m_20270_((Entity)ravager)) / 5.0;
                player.m_147240_(kb, ravager.m_20185_() - player.m_20185_(), ravager.m_20189_() - player.m_20189_());
            }
            PossessedRavagerChargeProcedure.endAbility(ravager, pd, now);
        }
    }

    private static void startStompAbility(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now) {
        pd.m_128405_("ravager_ability_state", 5);
        pd.m_128356_("ravager_ability_start", now);
        ravager.m_21573_().m_26573_();
        ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 1.5f, 1.0f);
    }

    private static void handleStompPrepareState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart) {
        long elapsed = now - abilityStart;
        ravager.m_21573_().m_26573_();
        if (elapsed % 3L == 0L && elapsed < 25L) {
            ServerLevel level = (ServerLevel)ravager.m_9236_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, ravager.m_20185_(), ravager.m_20186_() + 2.0, ravager.m_20189_(), 2, 0.3, 0.3, 0.3, 0.0);
        }
        if (elapsed >= 25L) {
            pd.m_128405_("ravager_ability_state", 6);
            pd.m_128356_("ravager_ability_start", now);
            ravager.m_20334_(ravager.m_20184_().f_82479_, 0.8, ravager.m_20184_().f_82481_);
        }
    }

    private static void handleStompExecuteState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart, ServerLevel level) {
        long elapsed = now - abilityStart;
        if (ravager.m_20096_() && elapsed > 5L) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 20, 2.5, 0.5, 2.5, 0.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, ravager.m_20185_(), ravager.m_20186_(), ravager.m_20189_(), 40, 2.5, 0.5, 2.5, 0.15);
            level.m_5594_(null, ravager.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.5f, 0.7f);
            boolean isAngry = pd.m_128471_("ravager_is_angry");
            float damage = isAngry ? 15.0f : 12.0f;
            for (Player player : level.m_6907_()) {
                if (!((double)player.m_20270_((Entity)ravager) <= 5.0)) continue;
                player.m_6469_(ravager.m_269291_().m_269333_((LivingEntity)ravager), damage);
                double kb = 2.0 + (5.0 - (double)player.m_20270_((Entity)ravager)) / 5.0;
                player.m_147240_(kb, ravager.m_20185_() - player.m_20185_(), ravager.m_20189_() - player.m_20189_());
            }
            PossessedRavagerChargeProcedure.endAbility(ravager, pd, now);
        } else if (elapsed > 50L) {
            PossessedRavagerChargeProcedure.endAbility(ravager, pd, now);
        }
    }

    private static void startRoarAbility(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now) {
        pd.m_128405_("ravager_ability_state", 7);
        pd.m_128356_("ravager_ability_start", now);
        ravager.m_21573_().m_26573_();
        ravager.m_9236_().m_5594_(null, ravager.m_20183_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 2.5f, 0.5f);
    }

    private static void handleRoarPrepareState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart) {
        long elapsed = now - abilityStart;
        ravager.m_21573_().m_26573_();
        if (elapsed % 2L == 0L && elapsed < 30L) {
            ServerLevel level = (ServerLevel)ravager.m_9236_();
            double angle = (double)elapsed * 0.3 % (Math.PI * 2);
            double radius = 1.5;
            double x = ravager.m_20185_() + Math.cos(angle) * radius;
            double z = ravager.m_20189_() + Math.sin(angle) * radius;
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, x, ravager.m_20186_() + 1.5, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (elapsed >= 30L) {
            pd.m_128405_("ravager_ability_state", 8);
            pd.m_128356_("ravager_ability_start", now);
        }
    }

    private static void handleRoarExecuteState(PossessedRavagerEntity ravager, Player tgt, CompoundTag pd, long now, long abilityStart, ServerLevel level) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, ravager.m_20185_(), ravager.m_20186_() + 1.5, ravager.m_20189_(), 20, 3.0, 1.0, 3.0, 0.2);
        level.m_5594_(null, ravager.m_20183_(), SoundEvents.f_215771_, SoundSource.HOSTILE, 2.0f, 1.0f);
        boolean isAngry = pd.m_128471_("ravager_is_angry");
        float damage = isAngry ? 6.0f : 4.0f;
        for (Player player : level.m_6907_()) {
            if (!((double)player.m_20270_((Entity)ravager) <= 8.0)) continue;
            player.m_6469_(ravager.m_269291_().m_269333_((LivingEntity)ravager), damage);
            player.m_147240_(1.0, ravager.m_20185_() - player.m_20185_(), ravager.m_20189_() - player.m_20189_());
        }
        PossessedRavagerChargeProcedure.endAbility(ravager, pd, now);
    }

    private static void endAbility(PossessedRavagerEntity ravager, CompoundTag pd, long now) {
        pd.m_128405_("ravager_ability_state", 0);
        pd.m_128356_("ravager_last_ability_end", now);
        ravager.setCharging(false);
        ravager.m_21573_().m_26573_();
    }

    private static void resetRavagerState(PossessedRavagerEntity ravager) {
        CompoundTag pd = ravager.getPersistentData();
        pd.m_128405_("ravager_ability_state", 0);
        ravager.setCharging(false);
        ravager.m_21573_().m_26573_();
    }
}

