/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Random;
import net.mcreator.fromthecaves.entity.FROMTHECAVESCAVESPIDEREntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPIDEREntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpiderAIProcedure {
    private static final double SPIDER_DETECT_DIST = 16.0;
    private static final double CAVE_SPIDER_DETECT_DIST = 8.0;
    private static final double LOOK_THRESHOLD = 0.95;
    private static final double SPIDER_FLEE_DISTANCE = 10.0;
    private static final double SPIDER_MOVE_SPEED = 0.7;
    private static final double CAVE_SPIDER_MOVE_SPEED = 0.8;
    private static final int SPIDER_BREAK_HORIZONTAL_INTERVAL = 2;
    private static final int SPIDER_BREAK_VERTICAL_INTERVAL = 5;
    private static final int SPIDER_VERTICAL_PHASE_DURATION = 100;
    private static final int CAVE_SPIDER_MIN_DISTANCE = 15;
    private static final int CAVE_SPIDER_MAX_DISTANCE = 20;
    private static final int CAVE_SPIDER_BREAK_DURATION = 60;
    private static final int CAVE_SPIDER_BREAK_INTERVAL = 1;
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        Level level = ent.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (ent instanceof FROMTHECAVESSPIDEREntity) {
            FROMTHECAVESSPIDEREntity spider = (FROMTHECAVESSPIDEREntity)ent;
            SpiderAIProcedure.handleSpiderAI(spider, server);
        } else if (ent instanceof FROMTHECAVESCAVESPIDEREntity) {
            FROMTHECAVESCAVESPIDEREntity caveSpider = (FROMTHECAVESCAVESPIDEREntity)ent;
            if (!caveSpider.getPersistentData().m_128471_("caveMode")) {
                return;
            }
            SpiderAIProcedure.handleCaveSpiderAI(caveSpider, server);
        }
    }

    private static void handleSpiderAI(FROMTHECAVESSPIDEREntity mob, ServerLevel server) {
        CompoundTag data = mob.getPersistentData();
        long tick = server.m_46467_();
        Player lookTarget = SpiderAIProcedure.findNearestPlayerInRange(server, (Entity)mob, 32.0);
        if (lookTarget != null) {
            SpiderAIProcedure.updateLookControl((Entity)mob, lookTarget);
        }
        if (!data.m_128471_("startedFlee")) {
            if (!SpiderAIProcedure.shouldStartFleeing((Entity)mob, server, 16.0, 0.95)) {
                return;
            }
            Player nearestPlayer = SpiderAIProcedure.findNearestPlayerInRange(server, (Entity)mob, 16.0);
            if (nearestPlayer == null) {
                return;
            }
            SpiderAIProcedure.initializeFleeState((Entity)mob, nearestPlayer, 10.0, 0.7, tick, data);
            return;
        }
        if (!data.m_128471_("reachedDest")) {
            SpiderAIProcedure.processHorizontalBreaking((Entity)mob, server, tick, data, 2);
            if (mob.m_21573_().m_26571_()) {
                data.m_128379_("reachedDest", true);
                data.m_128356_("nextVerticalBreakTick", tick);
            }
            return;
        }
        if (SpiderAIProcedure.shouldDespawn(tick, data.m_128454_("startTick"), 100)) {
            mob.m_146870_();
            return;
        }
        SpiderAIProcedure.processVerticalBreaking((Entity)mob, server, tick, data, 5);
    }

    private static void handleCaveSpiderAI(FROMTHECAVESCAVESPIDEREntity mob, ServerLevel server) {
        CompoundTag data = mob.getPersistentData();
        long tick = server.m_46467_();
        if (!data.m_128471_("fleeing")) {
            if (!SpiderAIProcedure.shouldStartFleeing((Entity)mob, server, 8.0, 0.95)) {
                return;
            }
            Player nearestPlayer = SpiderAIProcedure.findNearestPlayerInRange(server, (Entity)mob, 8.0);
            if (nearestPlayer == null) {
                return;
            }
            SpiderAIProcedure.initializeCaveSpiderFlee(mob, nearestPlayer, data);
            return;
        }
        if (!data.m_128471_("arrived")) {
            if (mob.m_21573_().m_26571_()) {
                data.m_128379_("arrived", true);
                data.m_128356_("breakStart", tick);
                data.m_128356_("nextBreak", tick);
            }
            return;
        }
        if (SpiderAIProcedure.shouldDespawn(tick, data.m_128454_("breakStart"), 60)) {
            mob.m_146870_();
            return;
        }
        SpiderAIProcedure.processCaveSpiderBreaking((Entity)mob, server, tick, data);
    }

    private static Player findNearestPlayerInRange(ServerLevel server, Entity mob, double range) {
        return server.m_45930_(mob, range);
    }

    private static void updateLookControl(Entity mob, Player target) {
        if (mob instanceof FROMTHECAVESSPIDEREntity) {
            FROMTHECAVESSPIDEREntity spider = (FROMTHECAVESSPIDEREntity)mob;
            spider.m_21563_().m_24950_(target.m_20185_(), target.m_20188_(), target.m_20189_(), 10.0f, 10.0f);
        }
    }

    private static boolean shouldStartFleeing(Entity mob, ServerLevel server, double detectRange, double lookThreshold) {
        Player nearestPlayer = SpiderAIProcedure.findNearestPlayerInRange(server, mob, detectRange);
        if (nearestPlayer == null) {
            return false;
        }
        boolean inRange = (double)nearestPlayer.m_20270_(mob) <= detectRange;
        boolean isLooking = SpiderAIProcedure.isPlayerLookingAtMob(nearestPlayer, mob, lookThreshold);
        return inRange || isLooking;
    }

    private static boolean isPlayerLookingAtMob(Player player, Entity mob, double threshold) {
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20188_() - player.m_20188_(), mob.m_20189_() - player.m_20189_()).m_82541_();
        return toMob.m_82526_(player.m_20154_()) > threshold;
    }

    private static void initializeFleeState(Entity mob, Player player, double fleeDistance, double speed, long tick, CompoundTag data) {
        PathNavigation nav;
        Vec3 fleeDirection = SpiderAIProcedure.calculateFleeDirection(mob, player);
        BlockPos destination = SpiderAIProcedure.calculateFleeDestination(mob, fleeDirection, fleeDistance);
        data.m_128379_("startedFlee", true);
        data.m_128356_("startTick", tick);
        data.m_128379_("reachedDest", false);
        data.m_128356_("nextHorizontalBreakTick", tick);
        if (mob instanceof FROMTHECAVESSPIDEREntity) {
            FROMTHECAVESSPIDEREntity spider = (FROMTHECAVESSPIDEREntity)mob;
            v0 = spider.m_21573_();
        } else {
            v0 = nav = null;
        }
        if (nav != null) {
            nav.m_26519_((double)destination.m_123341_() + 0.5, (double)destination.m_123342_(), (double)destination.m_123343_() + 0.5, speed);
        }
    }

    private static void initializeCaveSpiderFlee(FROMTHECAVESCAVESPIDEREntity mob, Player player, CompoundTag data) {
        Vec3 fleeDirection = SpiderAIProcedure.calculateFleeDirection((Entity)mob, player);
        double distance = 15.0 + RNG.nextDouble() * 5.0;
        BlockPos destination = SpiderAIProcedure.calculateFleeDestination((Entity)mob, fleeDirection, distance);
        PathNavigation nav = mob.m_21573_();
        nav.m_26519_((double)destination.m_123341_() + 0.5, mob.m_20186_(), (double)destination.m_123343_() + 0.5, 0.8);
        data.m_128379_("fleeing", true);
        data.m_128379_("arrived", false);
    }

    private static Vec3 calculateFleeDirection(Entity mob, Player player) {
        return new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_()).m_82541_();
    }

    private static BlockPos calculateFleeDestination(Entity mob, Vec3 direction, double distance) {
        double destX = mob.m_20185_() + direction.f_82479_ * distance;
        double destY = mob.m_20186_();
        double destZ = mob.m_20189_() + direction.f_82481_ * distance;
        return new BlockPos((int)destX, (int)destY, (int)destZ);
    }

    private static void processHorizontalBreaking(Entity mob, ServerLevel server, long tick, CompoundTag data, int interval) {
        long nextBreak = data.m_128454_("nextHorizontalBreakTick");
        if (tick < nextBreak) {
            return;
        }
        data.m_128356_("nextHorizontalBreakTick", tick + (long)interval);
        Vec3 movementDirection = mob.m_20184_().m_82541_();
        Direction facingDirection = Direction.m_122366_((double)movementDirection.f_82479_, (double)0.0, (double)movementDirection.f_82481_);
        BlockPos targetPos = mob.m_20183_().m_121945_(facingDirection);
        SpiderAIProcedure.tryBreakBlock(server, targetPos);
    }

    private static void processVerticalBreaking(Entity mob, ServerLevel server, long tick, CompoundTag data, int interval) {
        long nextBreak = data.m_128454_("nextVerticalBreakTick");
        if (tick < nextBreak) {
            return;
        }
        data.m_128356_("nextVerticalBreakTick", tick + (long)interval);
        BlockPos basePos = mob.m_20183_().m_7495_();
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dz = 0; dz <= 1; ++dz) {
                BlockPos targetPos = basePos.m_7918_(dx, 0, dz);
                if (!SpiderAIProcedure.tryBreakBlock(server, targetPos)) continue;
                return;
            }
        }
    }

    private static void processCaveSpiderBreaking(Entity mob, ServerLevel server, long tick, CompoundTag data) {
        long nextBreak = data.m_128454_("nextBreak");
        if (tick < nextBreak) {
            return;
        }
        data.m_128356_("nextBreak", tick + 1L);
        BlockPos basePos = mob.m_20183_();
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dz = 0; dz <= 1; ++dz) {
                for (int dy = -1; dy >= -2; --dy) {
                    BlockPos targetPos = basePos.m_7918_(dx, dy, dz);
                    if (!SpiderAIProcedure.tryBreakBlock(server, targetPos)) continue;
                    return;
                }
            }
        }
    }

    private static boolean tryBreakBlock(ServerLevel server, BlockPos pos) {
        if (!server.m_46749_(pos)) {
            return false;
        }
        BlockState state = server.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_50752_) {
            return false;
        }
        if (ProtectedBlocksProcedure.isProtected(state)) {
            return SpiderAIProcedure.tryBreakAlternativeBlock(server, pos);
        }
        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, pos, false);
        return true;
    }

    private static boolean tryBreakAlternativeBlock(ServerLevel server, BlockPos protectedPos) {
        for (Direction dir : Direction.values()) {
            BlockState state;
            BlockPos alternativePos;
            if (dir == Direction.UP || !server.m_46749_(alternativePos = protectedPos.m_121945_(dir)) || (state = server.m_8055_(alternativePos)).m_60795_() || state.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(state)) continue;
            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, alternativePos, false);
            return true;
        }
        return false;
    }

    private static boolean shouldDespawn(long currentTick, long startTick, int duration) {
        return currentTick - startTick >= (long)duration;
    }
}

