/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPIDEREntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpiderSpawnProcedure {
    private static final double BASE_PROB = 6.0E-5;
    private static final double MAX_PROB = 7.0E-5;
    private static final int MIN_SPAWN_DIST = 15;
    private static final int MAX_SPAWN_DIST = 30;
    private static final int MIN_STONE_COUNT = 5;
    private static final int MAX_SPAWN_ATTEMPTS = 15;
    private static final int STONE_SEARCH_RADIUS = 3;
    private static final int VERTICAL_SEARCH_MIN = -1;
    private static final int VERTICAL_SEARCH_MAX = 3;
    private static final int TELEPORT_MAX_RADIUS = 30;
    private static final int TELEPORT_VERTICAL_MIN = -2;
    private static final int TELEPORT_VERTICAL_MAX = 4;
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!SpiderSpawnProcedure.shouldAttemptSpawn(server, player)) {
            return;
        }
        BlockPos spawnPos = SpiderSpawnProcedure.findOptimalSpawnPosition(level, player);
        if (spawnPos == null) {
            return;
        }
        FROMTHECAVESSPIDEREntity spider = SpiderSpawnProcedure.createAndSpawnEntity(server, spawnPos);
        if (spider == null) {
            return;
        }
        SpiderSpawnProcedure.ensureEntityNotStuck(spider, player, server);
    }

    private static boolean shouldAttemptSpawn(ServerLevel server, Player player) {
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1) {
            return false;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 6.0E-5, 7.0E-5);
        return RNG.nextDouble() < dynamicProb;
    }

    private static BlockPos findOptimalSpawnPosition(Level level, Player player) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        BlockPos playerPos = player.m_20183_();
        for (int attempt = 0; attempt < 15; ++attempt) {
            BlockPos candidate = SpiderSpawnProcedure.generateSpawnPosition(player, playerPos);
            if (!SpiderSpawnProcedure.isChunkLoaded(level, candidate) || !SpiderSpawnProcedure.hasAirSpace(level, candidate) || !SpiderSpawnProcedure.hasSolidGround(level, candidate) || !SpiderSpawnProcedure.hasSufficientStone(level, candidate)) continue;
            validPositions.add(candidate);
            if (validPositions.size() >= 3) break;
        }
        return validPositions.isEmpty() ? null : SpiderSpawnProcedure.selectBestPosition(validPositions, player);
    }

    private static BlockPos generateSpawnPosition(Player player, BlockPos playerPos) {
        double angle = RNG.nextDouble() * Math.PI * 2.0;
        double distance = 15.0 + RNG.nextDouble() * 15.0;
        double dx = Math.cos(angle) * distance;
        double dz = Math.sin(angle) * distance;
        int cx = Mth.m_14107_((double)(player.m_20185_() + dx));
        int cz = Mth.m_14107_((double)(player.m_20189_() + dz));
        int cy = playerPos.m_123342_();
        return new BlockPos(cx, cy, cz);
    }

    private static boolean isChunkLoaded(Level level, BlockPos pos) {
        return level.m_46749_(pos);
    }

    private static boolean hasAirSpace(Level level, BlockPos pos) {
        if (!level.m_46859_(pos)) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        return level.m_46859_(above);
    }

    private static boolean hasSolidGround(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (!level.m_46749_(below)) {
            return false;
        }
        BlockState state = level.m_8055_(below);
        if (state.m_60795_()) {
            return false;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)level, below);
        return !shape.m_83281_();
    }

    private static boolean hasSufficientStone(Level level, BlockPos center) {
        int stoneCount = 0;
        int totalChecked = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -1; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos checkPos = center.m_7918_(x, y, z);
                    if (!level.m_46749_(checkPos)) continue;
                    ++totalChecked;
                    BlockState state = level.m_8055_(checkPos);
                    if (!SpiderSpawnProcedure.isNaturalStone(state) || ++stoneCount < 5) continue;
                    return true;
                }
            }
        }
        return stoneCount >= 5 && totalChecked > 0;
    }

    private static boolean isNaturalStone(BlockState state) {
        return state.m_60734_() == Blocks.f_50069_ || state.m_60734_() == Blocks.f_152550_ || state.m_60734_() == Blocks.f_50334_ || state.m_60734_() == Blocks.f_50228_ || state.m_60734_() == Blocks.f_50122_;
    }

    private static BlockPos selectBestPosition(List<BlockPos> positions, Player player) {
        if (positions.size() == 1) {
            return positions.get(0);
        }
        BlockPos playerPos = player.m_20183_();
        BlockPos best = positions.get(0);
        double bestScore = SpiderSpawnProcedure.evaluatePosition(best, playerPos);
        for (int i = 1; i < positions.size(); ++i) {
            BlockPos candidate = positions.get(i);
            double score = SpiderSpawnProcedure.evaluatePosition(candidate, playerPos);
            if (!(score > bestScore)) continue;
            best = candidate;
            bestScore = score;
        }
        return best;
    }

    private static double evaluatePosition(BlockPos pos, BlockPos playerPos) {
        double distance = Math.sqrt(pos.m_123331_((Vec3i)playerPos));
        double targetDist = 22.5;
        double distanceScore = 1.0 - Math.abs(distance - targetDist) / targetDist;
        return distanceScore;
    }

    private static FROMTHECAVESSPIDEREntity createAndSpawnEntity(ServerLevel server, BlockPos pos) {
        FROMTHECAVESSPIDEREntity spider = (FROMTHECAVESSPIDEREntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSPIDER.get()).m_20615_((Level)server);
        if (spider == null) {
            return null;
        }
        spider.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, RNG.nextFloat() * 360.0f, 0.0f);
        spider.m_21557_(false);
        spider.m_21530_();
        server.m_7967_((Entity)spider);
        return spider;
    }

    private static void ensureEntityNotStuck(FROMTHECAVESSPIDEREntity spider, Player player, ServerLevel server) {
        if (!SpiderSpawnProcedure.isEntityStuckInBlock(spider, (Level)server)) {
            return;
        }
        BlockPos safePosition = SpiderSpawnProcedure.findNearestSafePosition(spider, player, server);
        if (safePosition != null) {
            SpiderSpawnProcedure.teleportToSafePosition(spider, safePosition);
        }
    }

    private static boolean isEntityStuckInBlock(FROMTHECAVESSPIDEREntity spider, Level level) {
        BlockPos pos = spider.m_20183_();
        if (!level.m_46749_(pos)) {
            return false;
        }
        VoxelShape shape = level.m_8055_(pos).m_60812_((BlockGetter)level, pos);
        return !shape.m_83281_();
    }

    private static BlockPos findNearestSafePosition(FROMTHECAVESSPIDEREntity spider, Player player, ServerLevel server) {
        BlockPos spiderPos = spider.m_20183_();
        BlockPos playerPos = player.m_20183_();
        double minDistSq = 225.0;
        double maxDistSq = 900.0;
        for (int radius = 1; radius <= 30; ++radius) {
            ArrayList<BlockPos> candidatesAtRadius = new ArrayList<BlockPos>();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius) continue;
                    for (int dy = -2; dy <= 4; ++dy) {
                        BlockPos candidate = spiderPos.m_7918_(dx, dy, dz);
                        if (!server.m_46749_(candidate) || !server.m_46859_(candidate) || !SpiderSpawnProcedure.isWithinValidRange(candidate, playerPos, minDistSq, maxDistSq) || !SpiderSpawnProcedure.hasSolidGroundBelow((Level)server, candidate)) continue;
                        candidatesAtRadius.add(candidate);
                    }
                }
            }
            if (candidatesAtRadius.isEmpty()) continue;
            return (BlockPos)candidatesAtRadius.get(RNG.nextInt(candidatesAtRadius.size()));
        }
        return null;
    }

    private static boolean isWithinValidRange(BlockPos pos, BlockPos playerPos, double minDistSq, double maxDistSq) {
        double dz;
        double dy;
        double dx = (double)pos.m_123341_() + 0.5 - ((double)playerPos.m_123341_() + 0.5);
        double distSq = dx * dx + (dy = (double)pos.m_123342_() - ((double)playerPos.m_123342_() + 0.5)) * dy + (dz = (double)pos.m_123343_() + 0.5 - ((double)playerPos.m_123343_() + 0.5)) * dz;
        return distSq >= minDistSq && distSq <= maxDistSq;
    }

    private static boolean hasSolidGroundBelow(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (!level.m_46749_(below)) {
            return false;
        }
        BlockState state = level.m_8055_(below);
        if (state.m_60795_()) {
            return false;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)level, below);
        return !shape.m_83281_();
    }

    private static void teleportToSafePosition(FROMTHECAVESSPIDEREntity spider, BlockPos pos) {
        spider.m_6021_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }
}

