/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2BEDEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BedWakeDespawnProcedure {
    private static final int BLIND_TICKS = 100;
    private static final int AUTO_DESPAWN_TICKS = 140;
    private static final String[] CROSS_MESSAGES = new String[]{"That cross... it burns me.", "Why carry such a hated thing?", "The wooden cross enrages me."};

    private static void placeAngrySign(ServerLevel server, BlockPos pos, String message) {
        RandomSource rand = server.f_46441_;
        server.m_7731_(pos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rand.m_188503_(16))), 3);
        BlockEntity be = server.m_7702_(pos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            CompoundTag tag = sign.m_187482_();
            CompoundTag front = new CompoundTag();
            ListTag msgs = new ListTag();
            String[] words = message.split(" ");
            StringBuilder line1 = new StringBuilder();
            StringBuilder line2 = new StringBuilder();
            StringBuilder line3 = new StringBuilder();
            StringBuilder line4 = new StringBuilder();
            int wordIndex = 0;
            while (wordIndex < words.length && line1.length() + words[wordIndex].length() + 1 <= 15) {
                line1.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line2.length() + words[wordIndex].length() + 1 <= 15) {
                line2.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line3.length() + words[wordIndex].length() + 1 <= 15) {
                line3.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line4.length() + words[wordIndex].length() + 1 <= 15) {
                line4.append(words[wordIndex++]).append(" ");
            }
            BedWakeDespawnProcedure.addLine(msgs, line1.toString().trim());
            BedWakeDespawnProcedure.addLine(msgs, line2.toString().trim());
            BedWakeDespawnProcedure.addLine(msgs, line3.toString().trim());
            BedWakeDespawnProcedure.addLine(msgs, line4.toString().trim());
            front.m_128365_("messages", (Tag)msgs);
            tag.m_128365_("front_text", (Tag)front);
            tag.m_128359_("id", "minecraft:sign");
            sign.m_142466_(tag);
            sign.m_6596_();
            server.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
        }
    }

    private static void addLine(ListTag msgs, String text) {
        if (text.isEmpty()) {
            msgs.add((Object)StringTag.m_129297_((String)"\"\""));
        } else {
            msgs.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)text))));
        }
    }

    @SubscribeEvent
    public static void onPlayerWake(PlayerWakeUpEvent ev) {
        Player e = ev.getEntity();
        if (!(e instanceof Player)) {
            return;
        }
        Player player = e;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) != 2) {
            return;
        }
        if (!player.getPersistentData().m_128471_("wasSleeping")) {
            System.out.println("BED WAKE: Player was NOT sleeping, skipping");
            return;
        }
        if (!player.getPersistentData().m_128441_("sleepMobUUID")) {
            System.out.println("BED WAKE: No sleepMobUUID found");
            return;
        }
        System.out.println("BED WAKE: Processing wake event");
        UUID mobId = player.getPersistentData().m_128342_("sleepMobUUID");
        Entity found = server.m_8791_(mobId);
        if (found instanceof FROMTHECAVES2BEDEntity) {
            FROMTHECAVES2BEDEntity mob = (FROMTHECAVES2BEDEntity)found;
            System.out.println("BED WAKE: Found mob, applying effects and despawning");
            boolean hasCross = false;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get()) continue;
                hasCross = true;
                break;
            }
            if (hasCross) {
                String msg = CROSS_MESSAGES[server.f_46441_.m_188503_(CROSS_MESSAGES.length)];
                BedWakeDespawnProcedure.placeAngrySign(server, mob.m_20183_(), msg);
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
            SoundEvent caveEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
            if (caveEvent != null) {
                server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), caveEvent, SoundSource.AMBIENT, 1.0f, 0.9f);
            }
            mob.m_146870_();
        } else {
            System.out.println("BED WAKE: Mob not found or wrong type");
        }
        player.getPersistentData().m_128473_("sleepMobUUID");
        player.getPersistentData().m_128473_("wasSleeping");
    }

    @SubscribeEvent
    public static void onBedEntityTick(LivingEvent.LivingTickEvent ev) {
        long spawnTick;
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVES2BEDEntity)) {
            return;
        }
        FROMTHECAVES2BEDEntity mob = (FROMTHECAVES2BEDEntity)e;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) != 2) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128441_("spawnTick")) {
            System.out.println("BED MOB: No tiene spawnTick!");
            return;
        }
        long now = server.m_46467_();
        long elapsed = now - (spawnTick = data.m_128454_("spawnTick"));
        if (elapsed % 20L == 0L) {
            System.out.println("BED MOB: Elapsed ticks = " + elapsed + " / 140");
        }
        if (elapsed >= 140L) {
            UUID targetId;
            Player player;
            System.out.println("BED MOB: Auto-despawning after " + elapsed + " ticks");
            if (data.m_128441_("targetUUID") && (player = server.m_46003_(targetId = data.m_128342_("targetUUID"))) != null) {
                boolean hasCross = false;
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (stack.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get()) continue;
                    hasCross = true;
                    break;
                }
                if (hasCross) {
                    String msg = CROSS_MESSAGES[server.f_46441_.m_188503_(CROSS_MESSAGES.length)];
                    BedWakeDespawnProcedure.placeAngrySign(server, mob.m_20183_(), msg);
                }
            }
            mob.m_146870_();
        }
    }
}

