/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.AngerSystemProcedure;
import net.mcreator.fromthecaves.procedures.CrossUseCounterProcedure;
import net.mcreator.fromthecaves.procedures.Phase2PossessionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedMobExorcismProcedure {
    private static final double EXORCISM_CHANCE = 0.15;
    private static final double IRON_CROSS_CHANCE = 0.5;
    private static final int CROSS_DAMAGE = 5;
    private static final Set<UUID> EXORCISM_IN_PROGRESS = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract ev) {
        block24: {
            if (ev.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            if (ev.getLevel().m_5776_()) {
                return;
            }
            Player entity = ev.getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity player = (LivingEntity)entity;
            Entity target = ev.getTarget();
            if (!(target instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)target;
            if (!PossessedMobExorcismProcedure.isPossessedMob(mob.m_6095_())) {
                return;
            }
            UUID mobId = mob.m_20148_();
            if (!EXORCISM_IN_PROGRESS.add(mobId)) {
                return;
            }
            try {
                ServerLevel serverLevel;
                Mob vanillaMob;
                ItemStack mainStack = player.m_21205_();
                if (mainStack.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get() && mainStack.m_41720_() != FromTheCavesModItems.IRON_CROSS.get()) {
                    return;
                }
                Level level = ev.getLevel();
                if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
                    return;
                }
                double exorcismChance = 0.15;
                if (mainStack.m_41720_() == FromTheCavesModItems.IRON_CROSS.get() || player.m_21206_().m_41720_() == FromTheCavesModItems.IRON_CROSS.get()) {
                    exorcismChance = 0.5;
                }
                if (level.f_46441_.m_188500_() >= exorcismChance) {
                    return;
                }
                if (!Phase2PossessionProcedure.hasSavedData(mobId)) {
                    return;
                }
                CompoundTag savedNbt = Phase2PossessionProcedure.getSavedNBT(mobId);
                EntityType<? extends Mob> vanillaType = Phase2PossessionProcedure.getSavedOriginalType(mobId);
                BlockPos savedPos = Phase2PossessionProcedure.getSavedPosition(mobId);
                float savedYaw = Phase2PossessionProcedure.getSavedYaw(mobId);
                float savedPitch = Phase2PossessionProcedure.getSavedPitch(mobId);
                if (savedNbt == null || vanillaType == null) {
                    return;
                }
                if (!Phase2PossessionProcedure.removeSavedMobData(mobId)) {
                    return;
                }
                BlockPos pos = mob.m_20183_();
                mob.m_146870_();
                if (!(level instanceof ServerLevel) || (vanillaMob = (Mob)vanillaType.m_20615_((Level)(serverLevel = (ServerLevel)level))) == null) break block24;
                try {
                    CompoundTag restoredNbt = savedNbt.m_6426_();
                    restoredNbt.m_128473_("UUID");
                    restoredNbt.m_128359_("id", EntityType.m_20613_(vanillaType).toString());
                    vanillaMob.m_20258_(restoredNbt);
                    vanillaMob.m_20084_(UUID.randomUUID());
                    vanillaMob.m_7678_((double)savedPos.m_123341_() + 0.5, (double)savedPos.m_123342_(), (double)savedPos.m_123343_() + 0.5, savedYaw, savedPitch);
                }
                catch (Exception ex) {
                    vanillaMob.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, savedYaw, savedPitch);
                }
                serverLevel.m_7967_((Entity)vanillaMob);
                PossessedMobExorcismProcedure.spawnExorcismEffects(serverLevel, pos);
                mainStack.m_41622_(5, player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                CrossUseCounterProcedure.incrementExorcismCounter(player, level);
                AngerSystemProcedure.onExorcism(serverLevel);
            }
            finally {
                EXORCISM_IN_PROGRESS.remove(mobId);
            }
        }
    }

    private static boolean isPossessedMob(EntityType<?> type) {
        return type == FromTheCavesModEntities.POSSESSED_V.get() || type == FromTheCavesModEntities.POSSESSED_P.get() || type == FromTheCavesModEntities.POSSESSED_C.get() || type == FromTheCavesModEntities.POSSESSED_CKN.get() || type == FromTheCavesModEntities.POSSESSED_S.get() || type == FromTheCavesModEntities.POSSESSED_W.get() || type == FromTheCavesModEntities.POSSESSED_IG.get() || type == FromTheCavesModEntities.POSSESSED_Z.get() || type == FromTheCavesModEntities.POSSESSED_SK.get() || type == FromTheCavesModEntities.POSSESSED_SP.get() || type == FromTheCavesModEntities.POSSESSED_CRP.get() || type == FromTheCavesModEntities.POSSESSED_END.get() || type == FromTheCavesModEntities.POSSESSED_PILL.get() || type == FromTheCavesModEntities.POSSESSED_EV.get() || type == FromTheCavesModEntities.POSSESSED_VIND.get() || type == FromTheCavesModEntities.POSSESSED_RAVAGER.get() || type == FromTheCavesModEntities.POSSESSED_G.get() || type == FromTheCavesModEntities.POSSESSED_SQ.get() || type == FromTheCavesModEntities.POSSESSED_VEX.get() || type == FromTheCavesModEntities.POSSESSED_SAL.get();
    }

    private static void spawnExorcismEffects(ServerLevel level, BlockPos pos) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 20, 0.3, 0.3, 0.3, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 12, 0.2, 0.5, 0.2, 0.08);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 30, 0.5, 0.5, 0.5, 1.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 8, 0.3, 0.1, 0.3, 0.02);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.9f, 1.3f);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 0.7f, 0.8f);
    }
}

