/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnFrontMobProcedure {
    private static final double BASE_PROB = 2.0E-5;
    private static final double MAX_PROB = 3.5E-5;
    private static final double MIN_DIST = 5.0;
    private static final double MAX_DIST = 40.0;
    private static final double WATCH_DISTANCE = 64.0;
    private static final double CHASE_TRIGGER_DIST = 10.0;
    private static final int LOOK_TRIGGER_TICKS = 160;
    private static final double RUN_SPEED = 1.0;
    private static final int RUN_DURATION_TICKS = 160;
    private static final int BREAK_TICKS = 5;
    private static final int BREAK_SEARCH_AHEAD = 1;
    private static final double GRAVITY = 0.08;
    private static final double AGGRESSIVE_PROB = 0.4;
    private static final double DIG_HEALTH_RATIO = 0.3;
    private static final int DIG_BREAK_TICKS = 5;
    private static final int DIG_DURATION_TICKS = 40;
    private static final double DIG_DESCEND_SPEED = 0.45;
    private static final String KEY_SPAWN_TIME = "front_spawnTime";
    private static final String KEY_LOOK_START = "front_lookStart";
    private static final String KEY_RUNNING = "front_running";
    private static final String KEY_RUN_START = "front_runStart";
    private static final String KEY_LAST_BREAK = "front_lastBreakTick";
    private static final String KEY_AGGRESSIVE = "front_aggressive";
    private static final String KEY_DIGGING = "front_digging";
    private static final String KEY_DIG_START = "front_digStart";
    private static final String KEY_DIG_LAST_BREAK = "front_digLastBreak";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.m_20186_() >= 45.0) {
            player.m_9236_().m_45976_(Mob.class, player.m_20191_().m_82400_(64.0)).stream().filter(m -> m.m_6095_() == FromTheCavesModEntities.FROMTHECAVESFRONT.get()).forEach(Entity::m_146870_);
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 2 && phase != 1) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 2.0E-5, 3.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 5.0 + Math.random() * 35.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        double sy = player.m_20186_();
        Mob mob = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFRONT.get()).m_262496_(level, BlockPos.m_274561_((double)sx, (double)sy, (double)sz), MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        BlockPos mPos = mob.m_20183_();
        if (!level.m_8055_(mPos).m_60795_()) {
            mob.m_146870_();
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        CompoundTag data = mob.getPersistentData();
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128405_(KEY_LAST_BREAK, 0);
        boolean aggressive = Math.random() < 0.4;
        data.m_128379_(KEY_AGGRESSIVE, aggressive);
        data.m_128379_(KEY_DIGGING, false);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        Vec3 fleeDir;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESFRONT.get())) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 64.0);
        if (player == null && !data.m_128471_(KEY_DIGGING)) {
            return;
        }
        if (data.m_128471_(KEY_DIGGING)) {
            SpawnFrontMobProcedure.handleDigging(mob, data, level, now);
            return;
        }
        double dist = player != null ? (double)mob.m_20270_((Entity)player) : Double.MAX_VALUE;
        boolean running = data.m_128471_(KEY_RUNNING);
        boolean aggressive = data.m_128471_(KEY_AGGRESSIVE);
        if (!running) {
            if (player != null) {
                double dx = player.m_20185_() - mob.m_20185_();
                double dz = player.m_20189_() - mob.m_20189_();
                float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                mob.m_146922_(yaw);
                mob.f_20883_ = yaw;
                mob.f_20885_ = yaw;
                mob.m_146926_(0.0f);
            }
            if (player != null) {
                boolean inSightCone;
                if (dist <= 10.0) {
                    SpawnFrontMobProcedure.startRunning(mob, data, now);
                    return;
                }
                boolean hasLOS = player.m_142582_((Entity)mob);
                Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
                Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
                if (toMob.m_82553_() == 0.0) {
                    if (data.m_128441_(KEY_LOOK_START)) {
                        data.m_128473_(KEY_LOOK_START);
                    }
                    return;
                }
                Vec3 toMobNorm = toMob.m_82541_();
                double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
                boolean bl = inSightCone = dot > 0.95 && hasLOS;
                if (inSightCone) {
                    if (!data.m_128441_(KEY_LOOK_START)) {
                        data.m_128356_(KEY_LOOK_START, now);
                    } else {
                        long started = data.m_128454_(KEY_LOOK_START);
                        if (now - started >= 160L) {
                            SpawnFrontMobProcedure.startRunning(mob, data, now);
                            return;
                        }
                    }
                } else if (data.m_128441_(KEY_LOOK_START)) {
                    data.m_128473_(KEY_LOOK_START);
                }
            }
            return;
        }
        if (aggressive) {
            if (player == null) {
                mob.m_146870_();
                return;
            }
            try {
                mob.m_21557_(false);
                mob.m_20242_(false);
                mob.m_21573_().m_5624_((Entity)player, 1.4);
            }
            catch (Throwable ex) {
                Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                mob.m_20334_(dir.f_82479_ * 1.0 * 1.4, mob.m_20184_().f_82480_, dir.f_82481_ * 1.0 * 1.4);
                try {
                    mob.m_6478_(MoverType.SELF, mob.m_20184_());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            double distSq = mob.m_20280_((Entity)player);
            if (distSq <= 6.25) {
                try {
                    mob.m_7327_((Entity)player);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((double)mob.m_21223_() <= (double)mob.m_21233_() * 0.3) {
                SpawnFrontMobProcedure.startDigging(mob, data, now);
                return;
            }
            if (data.m_128441_(KEY_RUN_START) && now - data.m_128454_(KEY_RUN_START) >= 160L) {
                mob.m_146870_();
                return;
            }
            return;
        }
        if (player != null && !player.m_142582_((Entity)mob)) {
            mob.m_146870_();
            return;
        }
        Vec3 vec3 = fleeDir = player != null ? new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_()) : new Vec3(1.0, 0.0, 0.0);
        if (fleeDir.m_82556_() < 1.0E-6) {
            Vec3 look = player != null ? player.m_20252_(1.0f).m_82541_() : new Vec3(1.0, 0.0, 0.0);
            fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
        } else {
            fleeDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        }
        mob.m_21557_(true);
        mob.m_20242_(false);
        double speedFactor = 0.9;
        BlockPos belowPos = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(belowPos)) {
            BlockState belowState = level.m_8055_(belowPos);
            onGround = !belowState.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.08;
        Vec3 motion = new Vec3(fleeDir.f_82479_ * speedFactor, newY, fleeDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vec3 predicted = new Vec3(mob.m_20185_() + motion.f_82479_, mob.m_20186_() + motion.f_82480_, mob.m_20189_() + motion.f_82481_);
        double dx = predicted.f_82479_ - mob.m_20185_();
        double dz = predicted.f_82481_ - mob.m_20189_();
        if (Math.abs(dx) < 1.0E-5 && Math.abs(dz) < 1.0E-5) {
            double nudge = 0.5;
            double nx = mob.m_20185_() + fleeDir.f_82479_ * nudge;
            double nz = mob.m_20189_() + fleeDir.f_82481_ * nudge;
            mob.m_6021_(nx, mob.m_20186_(), nz);
        }
        int lastBreak = data.m_128451_(KEY_LAST_BREAK);
        data.m_128405_(KEY_LAST_BREAK, ++lastBreak);
        if (lastBreak >= 5) {
            data.m_128405_(KEY_LAST_BREAK, 0);
            double aheadX = mob.m_20185_() + fleeDir.f_82479_ * 1.0;
            double aheadY = mob.m_20186_();
            double aheadZ = mob.m_20189_() + fleeDir.f_82481_ * 1.0;
            BlockPos aheadPos = BlockPos.m_274561_((double)aheadX, (double)aheadY, (double)aheadZ);
            if (level.m_46749_(aheadPos)) {
                BlockState bs = level.m_8055_(aheadPos);
                if (!bs.m_60795_() && bs.m_60734_() != Blocks.f_50752_) {
                    if (!ProtectedBlocksProcedure.isProtected(bs)) {
                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, aheadPos, false);
                        return;
                    }
                } else {
                    BlockState bs2;
                    BlockPos tryAbove = aheadPos.m_7494_();
                    if (level.m_46749_(tryAbove) && !(bs2 = level.m_8055_(tryAbove)).m_60795_() && bs2.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs2)) {
                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, tryAbove, false);
                        return;
                    }
                }
            }
            BlockPos base = mob.m_20183_();
            for (int dxOff = -1; dxOff <= 0; ++dxOff) {
                for (int dyOff = -1; dyOff <= 0; ++dyOff) {
                    for (int dzOff = -1; dzOff <= 0; ++dzOff) {
                        BlockState bs;
                        BlockPos p = base.m_7918_(dxOff, dyOff, dzOff);
                        if (!level.m_46749_(p) || (bs = level.m_8055_(p)).m_60795_() || bs.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(bs)) continue;
                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, p, false);
                        return;
                    }
                }
            }
        }
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 160L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
        if (!aggressive && (double)mob.m_21223_() <= (double)mob.m_21233_() * 0.3) {
            SpawnFrontMobProcedure.startDigging(mob, data, now);
            return;
        }
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        data.m_128405_(KEY_LAST_BREAK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
    }

    private static void startDigging(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_DIGGING, true);
        data.m_128356_(KEY_DIG_START, now);
        data.m_128405_(KEY_DIG_LAST_BREAK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
    }

    private static void handleDigging(Mob mob, CompoundTag data, ServerLevel level, long now) {
        if (!data.m_128441_(KEY_DIG_START)) {
            data.m_128356_(KEY_DIG_START, now);
        }
        long digStart = data.m_128454_(KEY_DIG_START);
        long elapsed = now - digStart;
        int last = data.m_128451_(KEY_DIG_LAST_BREAK);
        data.m_128405_(KEY_DIG_LAST_BREAK, ++last);
        if (last >= 5) {
            BlockState bs;
            data.m_128405_(KEY_DIG_LAST_BREAK, 0);
            BlockPos below = mob.m_20183_().m_7495_();
            if (level.m_46749_(below) && !(bs = level.m_8055_(below)).m_60795_() && bs.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs)) {
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, below, false);
            }
        }
        Vec3 motion = new Vec3(0.0, -0.45, 0.0);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (elapsed >= 40L) {
            mob.m_146870_();
            return;
        }
        if (mob.m_20186_() < -16.0 || mob.m_20183_().m_123342_() <= 1) {
            mob.m_146870_();
            return;
        }
    }
}

