/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpiderUnderPlayerProcedure {
    private static final double BASE_PROB = 3.0E-5;
    private static final double MAX_PROB = 4.5E-5;
    private static final int SPAWN_DEPTH = 32;
    private static final int BREAK_INTERVAL = 20;
    private static final double NAV_SPEED = 0.45;
    private static final double RUN_SPEED = 1.0;
    private static final double ARRIVE_DISTANCE = 5.0;
    private static final double ARRIVE_Y_DIFF = 3.0;
    private static final long RUN_DESPAWN_TICKS = 60L;
    private static final double FORCE_DESPAWN_DISTANCE = 4.0;
    private static final String KEY_TARGET_X = "su_targetX";
    private static final String KEY_TARGET_Y = "su_targetY";
    private static final String KEY_TARGET_Z = "su_targetZ";
    private static final String KEY_NEXT_BREAK = "su_nextBreakTick";
    private static final String KEY_RUNNING = "su_running";
    private static final String KEY_RUN_START = "su_runStartTick";
    private static final String KEY_DESPAWN_AT = "su_despawnAtTick";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2 && phase != 3) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 3.0E-5, 4.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        if (player.m_20186_() >= 90.0) {
            return;
        }
        double sx = player.m_20185_();
        double sy = player.m_20186_() - 32.0;
        double sz = player.m_20189_();
        BlockPos center = BlockPos.m_274561_((double)sx, (double)sy, (double)sz);
        int minY = server.m_141937_() + 1;
        int maxY = server.m_151558_() - 2;
        if (center.m_123342_() < minY || center.m_123342_() > maxY) {
            return;
        }
        SpiderUnderPlayerProcedure.createSpawnCavity(server, center);
        Mob spider = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBELOWSPIDER.get()).m_20615_((Level)server);
        if (spider == null) {
            return;
        }
        spider.m_7678_((double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, 0.0f, 0.0f);
        spider.m_20242_(false);
        spider.m_21557_(false);
        spider.m_21530_();
        CompoundTag nbt = spider.getPersistentData();
        BlockPos playerPos = player.m_20183_();
        nbt.m_128405_(KEY_TARGET_X, playerPos.m_123341_());
        nbt.m_128405_(KEY_TARGET_Y, playerPos.m_123342_());
        nbt.m_128405_(KEY_TARGET_Z, playerPos.m_123343_());
        long now = server.m_46467_();
        nbt.m_128356_(KEY_NEXT_BREAK, now + 20L);
        nbt.m_128379_(KEY_RUNNING, false);
        nbt.m_128473_(KEY_RUN_START);
        nbt.m_128473_(KEY_DESPAWN_AT);
        server.m_7967_((Entity)spider);
    }

    private static void createSpawnCavity(ServerLevel level, BlockPos center) {
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                for (int dz = 0; dz <= 1; ++dz) {
                    BlockState bs;
                    BlockPos p = center.m_7918_(dx, dy, dz);
                    if (!level.m_46749_(p) || (bs = level.m_8055_(p)).m_60734_() == Blocks.f_50752_) continue;
                    try {
                        if (ProtectedBlocksProcedure.isProtected(bs)) continue;
                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, p, false);
                        continue;
                    }
                    catch (Throwable t) {
                        level.m_46597_(p, Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESBELOWSPIDER.get())) {
            return;
        }
        Level level = mob.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        CompoundTag data = mob.getPersistentData();
        long now = server.m_46467_();
        if (!(data.m_128441_(KEY_TARGET_X) && data.m_128441_(KEY_TARGET_Y) && data.m_128441_(KEY_TARGET_Z))) {
            return;
        }
        int tx = data.m_128451_(KEY_TARGET_X);
        int ty = data.m_128451_(KEY_TARGET_Y);
        int tz = data.m_128451_(KEY_TARGET_Z);
        Vec3 targetPos = new Vec3((double)tx + 0.5, (double)ty + 0.5, (double)tz + 0.5);
        if (SpiderUnderPlayerProcedure.checkForcedDespawn(server, mob)) {
            return;
        }
        boolean running = data.m_128471_(KEY_RUNNING);
        if (!running) {
            SpiderUnderPlayerProcedure.handleNavigationPhase(server, mob, data, targetPos, now);
        } else {
            SpiderUnderPlayerProcedure.handleRunningPhase(server, mob, data, tx, tz, now);
        }
    }

    private static boolean checkForcedDespawn(ServerLevel level, Mob mob) {
        double forcedDistSq = 16.0;
        for (Player p : level.m_6907_()) {
            if (!(mob.m_20280_((Entity)p) <= forcedDistSq)) continue;
            SpiderUnderPlayerProcedure.playCaveSound(level, mob.m_20182_());
            mob.m_146870_();
            return true;
        }
        return false;
    }

    private static void handleNavigationPhase(ServerLevel level, Mob mob, CompoundTag data, Vec3 targetPos, long now) {
        SpiderUnderPlayerProcedure.handleBlockBreaking(level, mob, data, targetPos, now);
        SpiderUnderPlayerProcedure.moveTowardsTarget(mob, targetPos);
        SpiderUnderPlayerProcedure.checkArrival(mob, data, targetPos, now);
    }

    private static void handleBlockBreaking(ServerLevel level, Mob mob, CompoundTag data, Vec3 targetPos, long now) {
        long nextBreak;
        if (!data.m_128441_(KEY_NEXT_BREAK)) {
            data.m_128356_(KEY_NEXT_BREAK, now + 20L);
        }
        if (now < (nextBreak = data.m_128454_(KEY_NEXT_BREAK))) {
            return;
        }
        data.m_128356_(KEY_NEXT_BREAK, now + 20L);
        Vec3 toTarget = targetPos.m_82546_(mob.m_20182_());
        double len = toTarget.m_82553_();
        int dirX = 0;
        int dirY = 0;
        int dirZ = 0;
        if (len > 1.0E-6) {
            dirX = (int)Math.signum(toTarget.f_82479_);
            dirY = (int)Math.signum(toTarget.f_82480_);
            dirZ = (int)Math.signum(toTarget.f_82481_);
        } else {
            dirZ = 1;
        }
        BlockPos base = mob.m_20183_();
        int baseYBelow = base.m_123342_() - 1;
        for (int step = 0; step <= 2; ++step) {
            BlockPos centerStep = base.m_7918_(dirX * step, dirY * step, dirZ * step);
            for (int dx = -1; dx <= 0; ++dx) {
                for (int dy = -1; dy <= 0; ++dy) {
                    for (int dz = -1; dz <= 0; ++dz) {
                        BlockState bs;
                        BlockPos bp = centerStep.m_7918_(dx, dy, dz);
                        if (bp.m_123342_() == baseYBelow || !level.m_46749_(bp) || (bs = level.m_8055_(bp)).m_60795_() || bs.m_60734_() == Blocks.f_50752_) continue;
                        try {
                            if (ProtectedBlocksProcedure.isProtected(bs)) continue;
                            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, bp, false);
                            continue;
                        }
                        catch (Throwable t) {
                            level.m_46597_(bp, Blocks.f_50016_.m_49966_());
                        }
                    }
                }
            }
        }
    }

    private static void moveTowardsTarget(Mob mob, Vec3 targetPos) {
        Vec3 toTarget = targetPos.m_82546_(mob.m_20182_());
        double distSq = toTarget.m_82556_();
        if (distSq < 1.0E-4) {
            return;
        }
        double dist = Math.sqrt(distSq);
        Vec3 dir = toTarget.m_82490_(1.0 / dist);
        double verticalDiff = toTarget.f_82480_;
        double desiredY = verticalDiff > 0.5 ? Math.min(0.3, verticalDiff * 0.1) : (verticalDiff < -0.5 ? Math.max(-0.3, verticalDiff * 0.1) : mob.m_20184_().f_82480_);
        double mx = dir.f_82479_ * 0.45;
        double mz = dir.f_82481_ * 0.45;
        Vec3 motion = new Vec3(mx, desiredY, mz);
        mob.m_21557_(true);
        mob.m_20242_(false);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vec3 predicted = new Vec3(mob.m_20185_() + motion.f_82479_, mob.m_20186_() + motion.f_82480_, mob.m_20189_() + motion.f_82481_);
        double dx = predicted.f_82479_ - mob.m_20185_();
        double dz = predicted.f_82481_ - mob.m_20189_();
        if (Math.abs(dx) < 1.0E-5 && Math.abs(dz) < 1.0E-5) {
            double nudge = 0.5;
            double nx = mob.m_20185_() + dir.f_82479_ * nudge;
            double nz = mob.m_20189_() + dir.f_82481_ * nudge;
            mob.m_6021_(nx, mob.m_20186_(), nz);
        }
    }

    private static void checkArrival(Mob mob, CompoundTag data, Vec3 targetPos, long now) {
        double dx = mob.m_20185_() - targetPos.f_82479_;
        double dy = mob.m_20186_() - targetPos.f_82480_;
        double dz = mob.m_20189_() - targetPos.f_82481_;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double yDiff = Math.abs(dy);
        if (distance <= 5.0 && yDiff <= 3.0) {
            data.m_128379_(KEY_RUNNING, true);
            data.m_128356_(KEY_RUN_START, now);
            data.m_128356_(KEY_DESPAWN_AT, now + 60L);
            mob.m_21557_(true);
            mob.m_20242_(false);
            Vec3 dir = new Vec3(mob.m_20185_() - targetPos.f_82479_, 0.0, mob.m_20189_() - targetPos.f_82481_);
            dir = dir.m_82556_() < 1.0E-6 ? mob.m_20182_().m_82546_(targetPos).m_82541_() : new Vec3(dir.f_82479_, 0.0, dir.f_82481_).m_82541_();
            Vec3 runMotion = new Vec3(dir.f_82479_ * 1.0, mob.m_20184_().f_82480_, dir.f_82481_ * 1.0);
            mob.m_20256_(runMotion);
            try {
                mob.m_6478_(MoverType.SELF, runMotion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void handleRunningPhase(ServerLevel level, Mob mob, CompoundTag data, int tx, int tz, long now) {
        long despawnAt = data.m_128454_(KEY_DESPAWN_AT);
        if (now >= despawnAt) {
            SpiderUnderPlayerProcedure.playCaveSound(level, mob.m_20182_());
            mob.m_146870_();
            return;
        }
        Vec3 dir = new Vec3(mob.m_20185_() - ((double)tx + 0.5), 0.0, mob.m_20189_() - ((double)tz + 0.5));
        dir = dir.m_82556_() < 1.0E-6 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(dir.f_82479_, 0.0, dir.f_82481_).m_82541_();
        BlockPos below = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(below)) {
            BlockState down = level.m_8055_(below);
            onGround = !down.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.08;
        Vec3 motion = new Vec3(dir.f_82479_ * 1.0, newY, dir.f_82481_ * 1.0);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void playCaveSound(ServerLevel level, Vec3 pos) {
        SoundEvent cave = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
        if (cave != null) {
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, cave, SoundSource.AMBIENT, 1.0f, 0.65f);
        }
    }
}

