/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVES2STEALEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ThiefBehaviorProcedure {
    private static final int BREAK_INTERVAL = 5;
    private static final double CHASE_SPEED = 0.7;
    private static final double ESCAPE_SPEED = 0.7;
    private static final int ESCAPE_RADIUS = 45;
    private static final long STEAL_TTL = 80L;
    private static final int IRON_CROSS_DAMAGE = 5;
    private static final int PATH_CHECK_DISTANCE = 3;
    private static final String[] WOODEN_CROSS_MESSAGES = new String[]{"That cross... it burns me.", "You should not carry that cross.", "The wooden cross enrages me.", "The cross burns me.", "Take the cross away.", "That cross hurts.", "The cross weakens me.", "I hate the cross.", "The cross... it stings.", "Hide the cross.", "The cross steals my strength.", "The cross blinds me.", "Your cross hurts.", "Drop the cross.", "That cross burns my eyes.", "The cross cracks my bones.", "The cross banishes me."};
    private static final String[] IRON_CROSS_MESSAGES = new String[]{"The iron... I cannot take it.", "Iron cross... too strong.", "The metal burns my hands.", "I fear the iron cross.", "Iron repels me.", "The blessed iron hurts.", "I cannot touch iron.", "Iron cross... it scorches.", "The iron defeats me.", "Iron cross... my weakness."};
    private static final String[] CROSS_FLOOR_MESSAGES = new String[]{"I took your ground cross.", "The gound cross is mine now.", "Your protection is gone.", "I stole your sacred relic.", "The ground cross... stolen.", "No more protection.", "I broke your circle.", "Your ground cross belongs to me.", "The ground cross is mine."};

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        long stoleAt;
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVES2STEALEntity)) {
            return;
        }
        FROMTHECAVES2STEALEntity thief = (FROMTHECAVES2STEALEntity)ent;
        if (ent.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)ent.m_9236_();
        CompoundTag data = thief.getPersistentData();
        long now = level.m_46467_();
        if (data.m_128471_("stolen") && data.m_128441_("stealTime") && now - (stoleAt = data.m_128454_("stealTime")) >= 80L) {
            ThiefBehaviorProcedure.executeEscapeEvent(thief, level, data);
            thief.m_146870_();
            return;
        }
        int bc = data.m_128451_("breakCounter") + 1;
        if (bc >= 5) {
            BlockState headSt;
            BlockPos pos = ent.m_20183_();
            Direction facing = ent.m_6350_();
            BlockPos feet = pos.m_121945_(facing);
            BlockPos head = feet.m_7494_();
            BlockState feetSt = level.m_8055_(feet);
            if (!feetSt.m_60795_()) {
                if (ProtectedBlocksProcedure.isProtected(feetSt)) {
                    bc = 0;
                    data.m_128405_("breakCounter", bc);
                    return;
                }
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, feet, false);
            }
            if (!(headSt = level.m_8055_(head)).m_60795_()) {
                if (ProtectedBlocksProcedure.isProtected(headSt)) {
                    bc = 0;
                    data.m_128405_("breakCounter", bc);
                    return;
                }
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, head, false);
            }
            bc = 0;
        }
        data.m_128405_("breakCounter", bc);
        Player target = level.m_45930_((Entity)ent, 16.0);
        if (target == null) {
            return;
        }
        boolean stolen = data.m_128471_("stolen");
        PathNavigation nav = thief.m_21573_();
        if (!stolen) {
            StealableItem stealableItem = ThiefBehaviorProcedure.findStealableItem(target);
            if ((double)ent.m_20270_((Entity)target) <= 1.6) {
                if (stealableItem == null) {
                    SoundEvent customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
                    if (customSound != null) {
                        level.m_5594_(null, ent.m_20183_(), customSound, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                    thief.m_146870_();
                    return;
                }
                ThiefBehaviorProcedure.performSteal(thief, target, level, data, now, stealableItem);
            } else {
                ThiefBehaviorProcedure.navigateTowardsTarget(thief, target, level, nav);
            }
        } else {
            ThiefBehaviorProcedure.handleEscapeBehavior(thief, target, level, data);
        }
    }

    private static void navigateTowardsTarget(FROMTHECAVES2STEALEntity thief, Player target, ServerLevel level, PathNavigation nav) {
        Vec3 thiefPos = thief.m_20182_();
        Vec3 targetPos = target.m_20182_();
        Vec3 direction = targetPos.m_82546_(thiefPos).m_82541_();
        boolean hasDirectPath = ThiefBehaviorProcedure.checkStraightPath(thief, target, level);
        if (hasDirectPath) {
            double targetX = thiefPos.f_82479_ + direction.f_82479_ * 2.0;
            double targetZ = thiefPos.f_82481_ + direction.f_82481_ * 2.0;
            nav.m_26519_(targetX, thiefPos.f_82480_, targetZ, 0.7);
        } else {
            Vec3 alternativePath = ThiefBehaviorProcedure.findClearPath(thief, target, level);
            if (alternativePath != null) {
                nav.m_26519_(alternativePath.f_82479_, alternativePath.f_82480_, alternativePath.f_82481_, 0.7);
            } else {
                Path path = nav.m_6570_((Entity)target, 0);
                if (path != null) {
                    nav.m_26536_(path, 0.7);
                }
            }
        }
    }

    private static boolean checkStraightPath(FROMTHECAVES2STEALEntity thief, Player target, ServerLevel level) {
        Vec3 start = thief.m_20182_();
        Vec3 end = target.m_20182_();
        Vec3 direction = end.m_82546_(start).m_82541_();
        double distance = start.m_82554_(end);
        int checks = Math.min((int)(distance / 0.5), 6);
        for (int i = 1; i <= checks; ++i) {
            double step = distance / (double)checks * (double)i;
            BlockPos checkPos = new BlockPos((int)(start.f_82479_ + direction.f_82479_ * step), (int)start.f_82480_, (int)(start.f_82481_ + direction.f_82481_ * step));
            BlockState feetState = level.m_8055_(checkPos);
            BlockState headState = level.m_8055_(checkPos.m_7494_());
            if ((feetState.m_60795_() || feetState.m_278721_()) && (headState.m_60795_() || headState.m_278721_())) continue;
            return false;
        }
        return true;
    }

    private static Vec3 findClearPath(FROMTHECAVES2STEALEntity thief, Player target, ServerLevel level) {
        double[] angles;
        Vec3 thiefPos = thief.m_20182_();
        Vec3 targetPos = target.m_20182_();
        Vec3 mainDirection = targetPos.m_82546_(thiefPos).m_82541_();
        for (double angle : angles = new double[]{0.0, 0.7853981633974483, -0.7853981633974483, 1.5707963267948966, -1.5707963267948966}) {
            double newZ;
            double sin;
            double cos = Math.cos(angle);
            double newX = mainDirection.f_82479_ * cos - mainDirection.f_82481_ * (sin = Math.sin(angle));
            Vec3 testDirection = new Vec3(newX, 0.0, newZ = mainDirection.f_82479_ * sin + mainDirection.f_82481_ * cos).m_82541_();
            Vec3 testPos = thiefPos.m_82549_(testDirection.m_82490_(3.0));
            if (!ThiefBehaviorProcedure.isPathClear(level, thiefPos, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private static boolean isPathClear(ServerLevel level, Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start).m_82541_();
        double distance = start.m_82554_(end);
        int steps = (int)(distance / 0.5);
        for (int i = 0; i <= steps; ++i) {
            Vec3 point = start.m_82549_(direction.m_82490_((double)i * 0.5));
            BlockPos pos = new BlockPos((int)point.f_82479_, (int)point.f_82480_, (int)point.f_82481_);
            if (level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private static StealableItem findStealableItem(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack s = player.m_150109_().m_8020_(i);
            if (s.m_41720_() == FromTheCavesModItems.WOODEN_CROSS.get()) {
                return new StealableItem(s, i, "wooden_cross");
            }
            if (s.m_41720_() == FromTheCavesModItems.IRON_CROSS.get()) {
                return new StealableItem(s, i, "iron_cross");
            }
            if (s.m_41720_() != FromTheCavesModItems.CROSS_FLOOR.get()) continue;
            return new StealableItem(s, i, "cross_floor");
        }
        return null;
    }

    private static void performSteal(FROMTHECAVES2STEALEntity thief, Player player, ServerLevel level, CompoundTag data, long now, StealableItem stealableItem) {
        if (stealableItem.itemType.equals("iron_cross")) {
            ThiefBehaviorProcedure.handleIronCrossAttempt(thief, player, level, data, stealableItem);
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(stealableItem.slot);
        ItemStack stolen = stack.m_41620_(1);
        player.m_150109_().m_6836_(stealableItem.slot, stack);
        thief.m_8061_(EquipmentSlot.MAINHAND, stolen);
        data.m_128379_("stolen", true);
        data.m_128365_("stolenItem", (Tag)stolen.serializeNBT());
        data.m_128356_("stealTime", now);
        data.m_128359_("itemType", stealableItem.itemType);
        ThiefEvent event = ThiefEvent.values()[level.f_46441_.m_188503_(ThiefEvent.values().length)];
        data.m_128359_("escapeEvent", event.name());
        String[] messages = stealableItem.itemType.equals("wooden_cross") ? WOODEN_CROSS_MESSAGES : CROSS_FLOOR_MESSAGES;
        String message = messages[level.f_46441_.m_188503_(messages.length)];
        ThiefBehaviorProcedure.placeAngrySign(level, thief.m_20183_(), message);
        ThiefBehaviorProcedure.playStealSound(level, thief.m_20183_(), event);
        Vec3 thiefPos = thief.m_20182_();
        Vec3 playerPos = player.m_20182_();
        Vec3 escapeDirection = thiefPos.m_82546_(playerPos).m_82541_();
        double ex = thiefPos.f_82479_ + escapeDirection.f_82479_ * 45.0;
        double ez = thiefPos.f_82481_ + escapeDirection.f_82481_ * 45.0;
        data.m_128347_("escapeX", ex);
        data.m_128347_("escapeY", thief.m_20186_());
        data.m_128347_("escapeZ", ez);
        data.m_128405_("eventTick", 0);
        thief.m_21051_(Attributes.f_22279_).m_22100_(0.7);
        thief.m_21573_().m_26519_(ex, thief.m_20186_(), ez, 0.7);
    }

    private static void handleIronCrossAttempt(FROMTHECAVES2STEALEntity thief, Player player, ServerLevel level, CompoundTag data, StealableItem stealableItem) {
        ItemStack ironCross = player.m_150109_().m_8020_(stealableItem.slot);
        ironCross.m_41622_(5, (LivingEntity)player, p -> {});
        SoundEvent customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
        if (customSound != null) {
            level.m_5594_(null, thief.m_20183_(), customSound, SoundSource.HOSTILE, 1.0f, 0.8f);
        }
        String message = IRON_CROSS_MESSAGES[level.f_46441_.m_188503_(IRON_CROSS_MESSAGES.length)];
        ThiefBehaviorProcedure.placeAngrySign(level, player.m_20183_(), message);
        thief.m_6469_(level.m_269111_().m_269425_(), 5.0f);
        thief.m_146870_();
    }

    private static void handleEscapeBehavior(FROMTHECAVES2STEALEntity thief, Player target, ServerLevel level, CompoundTag data) {
        double ex = data.m_128459_("escapeX");
        double ey = data.m_128459_("escapeY");
        double ez = data.m_128459_("escapeZ");
        Vec3 escapePos = new Vec3(ex, ey, ez);
        Vec3 thiefPos = thief.m_20182_();
        Vec3 escapeDirection = escapePos.m_82546_(thiefPos).m_82541_();
        double nextX = thiefPos.f_82479_ + escapeDirection.f_82479_ * 5.0;
        double nextZ = thiefPos.f_82481_ + escapeDirection.f_82481_ * 5.0;
        thief.m_21573_().m_26519_(nextX, ey, nextZ, 0.7);
        String eventName = data.m_128461_("escapeEvent");
        if (!eventName.isEmpty()) {
            ThiefEvent event = ThiefEvent.valueOf(eventName);
            int eventTick = data.m_128451_("eventTick");
            data.m_128405_("eventTick", eventTick + 1);
            if (eventTick < 20) {
                ThiefBehaviorProcedure.executeEscapeSubEvent(thief, target, level, data, event, eventTick);
            }
        }
        if (!target.m_142582_((Entity)thief) || thief.m_20270_((Entity)target) > 35.0f) {
            ThiefBehaviorProcedure.executeEscapeEvent(thief, level, data);
            thief.m_146870_();
        }
    }

    private static void executeEscapeSubEvent(FROMTHECAVES2STEALEntity thief, Player target, ServerLevel level, CompoundTag data, ThiefEvent event, int eventTick) {
        switch (event) {
            case SILENT_STEAL: {
                break;
            }
            case SIGN_TAUNT: {
                BlockPos signPos;
                if (eventTick != 10 || !level.m_8055_(signPos = thief.m_20183_().m_121945_(Direction.values()[level.f_46441_.m_188503_(4)])).m_60795_()) break;
                ThiefBehaviorProcedure.placeAngrySign(level, signPos, "Too slow!");
                break;
            }
            case SMOKE_VANISH: {
                break;
            }
            case ITEM_DROP_TRAIL: {
                break;
            }
            case TELEPORT_BEHIND: {
                if (eventTick != 15 || !(thief.m_20270_((Entity)target) > 12.0f)) break;
                double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                double distance = 4.0;
                double tx = target.m_20185_() + Math.cos(angle) * distance;
                double tz = target.m_20189_() + Math.sin(angle) * distance;
                thief.m_6021_(tx, target.m_20186_(), tz);
                SoundEvent customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_28"));
                if (customSound == null) break;
                level.m_5594_(null, thief.m_20183_(), customSound, SoundSource.HOSTILE, 1.0f, 1.0f);
                break;
            }
            case BREATH_WHISPER: {
                SoundEvent heartSound;
                if (eventTick % 15 != 0 || (heartSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "one_heart"))) == null) break;
                level.m_5594_(null, thief.m_20183_(), heartSound, SoundSource.HOSTILE, 0.5f, 0.7f);
            }
        }
    }

    private static void executeEscapeEvent(FROMTHECAVES2STEALEntity thief, ServerLevel level, CompoundTag data) {
        String eventName = data.m_128461_("escapeEvent");
        if (eventName.isEmpty()) {
            return;
        }
        ThiefEvent event = ThiefEvent.valueOf(eventName);
        switch (event) {
            case SILENT_STEAL: {
                break;
            }
            case SIGN_TAUNT: {
                break;
            }
            case SMOKE_VANISH: {
                SoundEvent customSound1 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
                if (customSound1 == null) break;
                level.m_5594_(null, thief.m_20183_(), customSound1, SoundSource.HOSTILE, 0.8f, 0.6f);
                break;
            }
            case ITEM_DROP_TRAIL: {
                break;
            }
            case TELEPORT_BEHIND: {
                SoundEvent customSound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_28"));
                if (customSound2 == null) break;
                level.m_5594_(null, thief.m_20183_(), customSound2, SoundSource.HOSTILE, 1.0f, 0.8f);
                break;
            }
            case BREATH_WHISPER: {
                SoundEvent customSound3 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "one_heart"));
                if (customSound3 == null) break;
                level.m_5594_(null, thief.m_20183_(), customSound3, SoundSource.HOSTILE, 1.0f, 0.6f);
            }
        }
    }

    private static void playStealSound(ServerLevel level, BlockPos pos, ThiefEvent event) {
        SoundEvent customSound = null;
        switch (event) {
            case SILENT_STEAL: {
                break;
            }
            case TELEPORT_BEHIND: {
                customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_28"));
                break;
            }
            case BREATH_WHISPER: {
                customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "one_heart"));
                break;
            }
            default: {
                customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
            }
        }
        if (customSound != null) {
            level.m_5594_(null, pos, customSound, SoundSource.HOSTILE, 0.8f, 0.7f);
        }
    }

    private static void placeAngrySign(ServerLevel server, BlockPos pos, String message) {
        BlockEntity be;
        RandomSource rand = server.f_46441_;
        server.m_7731_(pos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rand.m_188503_(16))), 3);
        SoundEvent customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
        if (customSound != null) {
            server.m_5594_(null, pos, customSound, SoundSource.BLOCKS, 1.0f, 0.6f);
        }
        if ((be = server.m_7702_(pos)) instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            CompoundTag tag = sign.m_187482_();
            CompoundTag front = new CompoundTag();
            ListTag msgs = new ListTag();
            String[] words = message.split(" ");
            StringBuilder line1 = new StringBuilder();
            StringBuilder line2 = new StringBuilder();
            StringBuilder line3 = new StringBuilder();
            StringBuilder line4 = new StringBuilder();
            int wordIndex = 0;
            while (wordIndex < words.length && line1.length() + words[wordIndex].length() + 1 <= 15) {
                line1.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line2.length() + words[wordIndex].length() + 1 <= 15) {
                line2.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line3.length() + words[wordIndex].length() + 1 <= 15) {
                line3.append(words[wordIndex++]).append(" ");
            }
            while (wordIndex < words.length && line4.length() + words[wordIndex].length() + 1 <= 15) {
                line4.append(words[wordIndex++]).append(" ");
            }
            ThiefBehaviorProcedure.addLine(msgs, line1.toString().trim());
            ThiefBehaviorProcedure.addLine(msgs, line2.toString().trim());
            ThiefBehaviorProcedure.addLine(msgs, line3.toString().trim());
            ThiefBehaviorProcedure.addLine(msgs, line4.toString().trim());
            front.m_128365_("messages", (Tag)msgs);
            tag.m_128365_("front_text", (Tag)front);
            tag.m_128359_("id", "minecraft:sign");
            sign.m_142466_(tag);
            sign.m_6596_();
            server.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
        }
    }

    private static void addLine(ListTag msgs, String text) {
        if (text.isEmpty()) {
            msgs.add((Object)StringTag.m_129297_((String)"\"\""));
        } else {
            msgs.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)text))));
        }
    }

    private static class StealableItem {
        ItemStack stack;
        int slot;
        String itemType;

        StealableItem(ItemStack stack, int slot, String itemType) {
            this.stack = stack;
            this.slot = slot;
            this.itemType = itemType;
        }
    }

    private static enum ThiefEvent {
        SILENT_STEAL,
        SIGN_TAUNT,
        SMOKE_VANISH,
        ITEM_DROP_TRAIL,
        TELEPORT_BEHIND,
        BREATH_WHISPER;

    }
}

