/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ToggleButtonLeverProcedure {
    private static final double PROBABILITY = 6.0E-4;
    private static final int SEARCH_RADIUS = 10;
    private static final int SEARCH_TRIES = 20;
    private static final long TOGGLE_DURATION = 40L;
    private static final List<PendingToggle> pending = new ArrayList<PendingToggle>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        if (dayTime <= 12000L) {
            return;
        }
        if (Math.random() >= 6.0E-4) {
            return;
        }
        BlockPos origin = player.m_20183_();
        ToggleButtonLeverProcedure.execute((LevelAccessor)level, origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
    }

    public static void execute(LevelAccessor world, int x, int y, int z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        BlockPos origin = new BlockPos(x, y, z);
        for (int i = 0; i < 20; ++i) {
            int dz;
            int dy;
            int dx = level.f_46441_.m_188503_(21) - 10;
            BlockPos cand = origin.m_7918_(dx, dy = level.f_46441_.m_188503_(5) - 2, dz = level.f_46441_.m_188503_(21) - 10);
            BlockState bs = level.m_8055_(cand);
            if (!(bs.m_60734_() instanceof ButtonBlock) && !(bs.m_60734_() instanceof LeverBlock) || !bs.m_61138_((Property)BlockStateProperties.f_61448_) || ((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
            level.m_7731_(cand, (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
            level.m_5594_(null, cand, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
            MinecraftServer srv = level.m_7654_();
            if (srv != null) {
                CommandSourceStack src = srv.m_129893_().m_81325_(2);
                CommandDispatcher dispatcher = srv.m_129892_().m_82094_();
                try {
                    dispatcher.execute("playsound minecraft:block.stone.break master @a ~ ~ ~ 1 1", (Object)src);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            PendingToggle pt = new PendingToggle();
            pt.dimension = level.m_46472_();
            pt.pos = cand;
            pt.revertTime = level.m_46467_() + 40L;
            pending.add(pt);
            break;
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = ev.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        long now = level2.m_46467_();
        ResourceKey currentDim = level2.m_46472_();
        Iterator<PendingToggle> it = pending.iterator();
        while (it.hasNext()) {
            PendingToggle pt = it.next();
            if (!pt.dimension.equals((Object)currentDim) || now < pt.revertTime) continue;
            BlockState bs = level2.m_8055_(pt.pos);
            if (bs.m_61138_((Property)BlockStateProperties.f_61448_)) {
                level2.m_7731_(pt.pos, (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
                level2.m_5594_(null, pt.pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            it.remove();
        }
    }

    private static class PendingToggle {
        ResourceKey<Level> dimension;
        BlockPos pos;
        long revertTime;

        private PendingToggle() {
        }
    }
}

