/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.fromthecaves.FromTheCavesMod;
import net.mcreator.fromthecaves.world.inventory.VillagerBookMenu;
import net.mcreator.fromthecaves.world.inventory.VillagerBookPage2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillagerBookButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VillagerBookButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VillagerBookButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VillagerBookButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VillagerBookButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VillagerBookButtonMessage.handleButtonAction((Entity)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Entity entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VillagerBookMenu.guistate;
        if (buttonID == 0 && entity instanceof ServerPlayer) {
            ServerPlayer _ent = (ServerPlayer)entity;
            final BlockPos _bpos = _ent.m_20183_();
            NetworkHooks.openScreen((ServerPlayer)_ent, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"VillagerBookPage2");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    return new VillagerBookPage2Menu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(_bpos));
                }
            }, (BlockPos)_bpos);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        FromTheCavesMod.addNetworkMessage(VillagerBookButtonMessage.class, VillagerBookButtonMessage::buffer, VillagerBookButtonMessage::new, VillagerBookButtonMessage::handler);
    }
}

