/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BookEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 8.0E-4;
    private static final double MAX_PROB_PHASE1 = 9.5E-4;
    private static final double BASE_PROB_PHASE2 = 9.5E-4;
    private static final double MAX_PROB_PHASE2 = 0.001;
    private static final int SCAN_RADIUS = 12;
    private static final int COOLDOWN_TICKS = 5;
    private static final String[] CREEPY_MESSAGES = new String[]{"I can see you", "Why are you here?", "It's watching", "Run while you can", "You shouldn't have come", "Don't look behind you", "It's too late", "You're not alone", "Help me", "Get out", "It hurts", "I'm still here", "Don't go to sleep", "Why?", "Help..."};
    private static final Map<UUID, Long> bookCooldowns = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 8.0E-4 : 9.5E-4;
        double maxProb = phase == 1 ? 9.5E-4 : 0.001;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<ItemEntity> validBooks = BookEventsProcedure.findValidBooks(server, player);
        if (validBooks.isEmpty()) {
            return;
        }
        ItemEntity chosen = validBooks.get(server.m_213780_().m_188503_(validBooks.size()));
        long currentTime = server.m_46467_();
        if (bookCooldowns.containsKey(chosen.m_20148_()) && currentTime < bookCooldowns.get(chosen.m_20148_())) {
            return;
        }
        bookCooldowns.put(chosen.m_20148_(), currentTime + 5L);
        BookEventsProcedure.addCreepyMessage(server, chosen);
    }

    private static List<ItemEntity> findValidBooks(ServerLevel server, Player player) {
        ArrayList<ItemEntity> books = new ArrayList<ItemEntity>();
        AABB box = new AABB(player.m_20183_()).m_82400_(12.0);
        for (Entity entity : server.m_142646_().m_142273_()) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!box.m_82390_(entity.m_20182_()) || itemEntity.m_32055_().m_41720_() != Items.f_42614_) continue;
            books.add(itemEntity);
        }
        return books;
    }

    private static void addCreepyMessage(ServerLevel server, ItemEntity bookEntity) {
        Player owner;
        ItemStack book = bookEntity.m_32055_();
        CompoundTag tag = book.m_41784_();
        ListTag pages = tag.m_128425_("pages", 8) ? tag.m_128437_("pages", 8) : new ListTag();
        String message = CREEPY_MESSAGES[server.m_213780_().m_188503_(CREEPY_MESSAGES.length)];
        pages.add((Object)StringTag.m_129297_((String)message));
        tag.m_128365_("pages", (Tag)pages);
        tag.m_128405_("generation", 0);
        book.m_41751_(tag);
        bookEntity.m_32045_(book);
        UUID ownerUUID = null;
        CompoundTag entityTag = bookEntity.getPersistentData();
        if (entityTag.m_128403_("Thrower")) {
            ownerUUID = entityTag.m_128342_("Thrower");
        }
        if (ownerUUID != null && (owner = server.m_46003_(ownerUUID)) != null && owner.m_150109_().m_36063_(book)) {
            owner.m_150109_().m_6596_();
        }
    }
}

