/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.item.CrossCompassItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CrossCompassBehaviorProcedure {
    private static final int SEARCH_INTERVAL_TICKS = 350;
    private static final int ANIMATION_UPDATE_INTERVAL_TICKS = 10;
    private static final int PARTICLE_INTERVAL_TICKS = 35;
    private static final int MARKER_HIGHLIGHT_INTERVAL_TICKS = 8;
    private static final int PROXIMITY_MESSAGE_INTERVAL = 240;
    private static final int SEARCH_RADIUS_BLOCKS = 312;
    private static final int VERTICAL_SEARCH_RANGE = 32;
    private static final double DIST_HIGH = 312.0;
    private static final double DIST_MED = 258.0;
    private static final double DIST_CLOSE = 100.0;
    private static final double DIST_VERY_CLOSE = 50.0;
    private static final double HIGHLIGHT_DISTANCE = 45.0;
    private static final String ANIM_1 = "animation.WoodenCross.1";
    private static final String ANIM_2 = "animation.WoodenCross.2";
    private static final String ANIM_3 = "animation.WoodenCross.3";
    private static final Set<String> VALID_ANIMS = Set.of("animation.WoodenCross.1", "animation.WoodenCross.2", "animation.WoodenCross.3");
    private static final Map<UUID, CompassCacheEntry> playerCache = new ConcurrentHashMap<UUID, CompassCacheEntry>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        double distanceSq;
        CompassCacheEntry cache;
        long lastAnimUpdateTick;
        boolean offIsCompass;
        Player player;
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_() || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack mainHand = player2.m_21205_();
        ItemStack offHand = player2.m_21206_();
        boolean mainIsCompass = !mainHand.m_41619_() && mainHand.m_41720_() instanceof CrossCompassItem;
        boolean bl = offIsCompass = !offHand.m_41619_() && offHand.m_41720_() instanceof CrossCompassItem;
        if (!mainIsCompass && !offIsCompass) {
            playerCache.remove(player2.m_20148_());
            return;
        }
        int currentTick = player2.f_19797_;
        UUID playerUUID = player2.m_20148_();
        ItemStack activeCompass = mainIsCompass ? mainHand : offHand;
        CompoundTag tag = activeCompass.m_41784_();
        if (currentTick % 350 == 0) {
            BlockPos markerPos = CrossCompassBehaviorProcedure.findNearestMarker(player2, (ServerLevel)player2.m_9236_());
            playerCache.put(playerUUID, new CompassCacheEntry(markerPos, currentTick));
        }
        if ((long)currentTick - (lastAnimUpdateTick = tag.m_128454_("cross_compass_last_anim_tick")) >= 10L) {
            cache = playerCache.get(playerUUID);
            BlockPos markerPos = cache != null ? cache.markerPos : null;
            String newAnimation = CrossCompassBehaviorProcedure.computeAnimationFromPos(player2, markerPos);
            boolean changed = CrossCompassBehaviorProcedure.updateStackAnimation(activeCompass, tag, newAnimation, currentTick);
            if (changed) {
                player2.f_36096_.m_38946_();
            }
            if (mainIsCompass && offIsCompass) {
                CompoundTag offTag = offHand.m_41784_();
                CrossCompassBehaviorProcedure.updateStackAnimation(offHand, offTag, newAnimation, currentTick);
            }
        }
        if (currentTick % 35 == 0 && (cache = playerCache.get(playerUUID)) != null && cache.markerPos != null) {
            CrossCompassBehaviorProcedure.spawnParticlesTowardMarker((ServerLevel)player2.m_9236_(), player2, cache.markerPos);
        }
        if (currentTick % 8 == 0 && (cache = playerCache.get(playerUUID)) != null && cache.markerPos != null && (distanceSq = player2.m_20275_((double)cache.markerPos.m_123341_() + 0.5, (double)cache.markerPos.m_123342_() + 0.5, (double)cache.markerPos.m_123343_() + 0.5)) <= 2025.0) {
            CrossCompassBehaviorProcedure.highlightMarkerBlock((ServerLevel)player2.m_9236_(), cache.markerPos, distanceSq);
        }
        if (currentTick % 240 == 0 && (cache = playerCache.get(playerUUID)) != null && cache.markerPos != null) {
            CrossCompassBehaviorProcedure.sendProximityFeedback(player2, cache.markerPos);
        }
    }

    private static boolean updateStackAnimation(ItemStack stack, CompoundTag tag, String newAnim, int currentTick) {
        String currentAnim = tag.m_128461_("cross_compass_anim");
        if (currentAnim.isEmpty() || !VALID_ANIMS.contains(currentAnim)) {
            currentAnim = ANIM_1;
        }
        boolean changed = false;
        if (!newAnim.equals(currentAnim)) {
            tag.m_128359_("cross_compass_anim", newAnim);
            changed = true;
        }
        tag.m_128356_("cross_compass_last_anim_tick", (long)currentTick);
        return changed;
    }

    private static String computeAnimationFromPos(ServerPlayer player, BlockPos markerPos) {
        double dz;
        if (markerPos == null) {
            return ANIM_1;
        }
        double dx = player.m_20185_() - ((double)markerPos.m_123341_() + 0.5);
        double horizDistSq = dx * dx + (dz = player.m_20189_() - ((double)markerPos.m_123343_() + 0.5)) * dz;
        if (horizDistSq > 97344.0) {
            return ANIM_1;
        }
        if (horizDistSq > 66564.0) {
            return ANIM_2;
        }
        return ANIM_3;
    }

    private static BlockPos findNearestMarker(ServerPlayer player, ServerLevel level) {
        BlockPos playerPos = player.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int r = 0; r <= 312; ++r) {
            for (int i = 0; i < r * 2; ++i) {
                int x1 = playerPos.m_123341_() - r + i;
                int z1 = playerPos.m_123343_() - r;
                if (CrossCompassBehaviorProcedure.checkVerticalSlice(level, mutablePos.m_122178_(x1, playerPos.m_123342_(), z1), playerPos.m_123342_())) {
                    return mutablePos.m_7949_();
                }
                int x2 = playerPos.m_123341_() + r;
                int z2 = playerPos.m_123343_() - r + i;
                if (CrossCompassBehaviorProcedure.checkVerticalSlice(level, mutablePos.m_122178_(x2, playerPos.m_123342_(), z2), playerPos.m_123342_())) {
                    return mutablePos.m_7949_();
                }
                int x3 = playerPos.m_123341_() + r - i;
                int z3 = playerPos.m_123343_() + r;
                if (CrossCompassBehaviorProcedure.checkVerticalSlice(level, mutablePos.m_122178_(x3, playerPos.m_123342_(), z3), playerPos.m_123342_())) {
                    return mutablePos.m_7949_();
                }
                int x4 = playerPos.m_123341_() - r;
                int z4 = playerPos.m_123343_() + r - i;
                if (!CrossCompassBehaviorProcedure.checkVerticalSlice(level, mutablePos.m_122178_(x4, playerPos.m_123342_(), z4), playerPos.m_123342_())) continue;
                return mutablePos.m_7949_();
            }
        }
        return null;
    }

    private static boolean checkVerticalSlice(ServerLevel level, BlockPos.MutableBlockPos mutablePos, int playerY) {
        for (int dy = 0; dy <= 32; ++dy) {
            mutablePos.m_142448_(playerY + dy);
            if (level.m_46749_((BlockPos)mutablePos) && level.m_8055_((BlockPos)mutablePos).m_60713_((Block)FromTheCavesModBlocks.CEMETERY_MARKER.get())) {
                return true;
            }
            if (dy == 0) continue;
            mutablePos.m_142448_(playerY - dy);
            if (!level.m_46749_((BlockPos)mutablePos) || !level.m_8055_((BlockPos)mutablePos).m_60713_((Block)FromTheCavesModBlocks.CEMETERY_MARKER.get())) continue;
            return true;
        }
        return false;
    }

    private static void spawnParticlesTowardMarker(ServerLevel level, ServerPlayer player, BlockPos markerPos) {
        double mz;
        double dz;
        double my;
        double dy;
        double px = player.m_20185_();
        double py = player.m_20186_() + (double)player.m_20192_() * 0.75;
        double pz = player.m_20189_();
        double mx = (double)markerPos.m_123341_() + 0.5;
        double dx = mx - px;
        double dist = Math.sqrt(dx * dx + (dy = (my = (double)markerPos.m_123342_() + 0.5) - py) * dy + (dz = (mz = (double)markerPos.m_123343_() + 0.5) - pz) * dz);
        if (dist < 1.0) {
            return;
        }
        int particleCount = 25;
        double step = dist / (double)(particleCount - 1);
        SoundEvent whisperSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.vex.ambient"));
        if (whisperSound != null && level.f_46441_.m_188501_() < 0.3f) {
            level.m_6263_(null, px, py, pz, whisperSound, SoundSource.PLAYERS, 0.4f, 0.5f + level.f_46441_.m_188501_() * 0.5f);
        }
        for (int i = 0; i < particleCount; ++i) {
            double frac = (double)i * step / dist;
            double cx = px + frac * dx;
            double cy = py + frac * dy;
            double cz = pz + frac * dz;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, cx, cy, cz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void sendProximityFeedback(ServerPlayer player, BlockPos markerPos) {
        double dx = player.m_20185_() - ((double)markerPos.m_123341_() + 0.5);
        double dz = player.m_20189_() - ((double)markerPos.m_123343_() + 0.5);
        double distance = Math.sqrt(dx * dx + dz * dz);
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (distance <= 50.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\u271f \u00a74Very Close... \u00a7c\u00a7l\u271f"), true);
            SoundEvent closeSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient"));
            if (closeSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), closeSound, SoundSource.PLAYERS, 0.15f, 1.8f);
            }
            for (int i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 * (double)i / 8.0;
                double radius = 2.0;
                double particleX = player.m_20185_() + Math.cos(angle) * radius;
                double particleZ = player.m_20189_() + Math.sin(angle) * radius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, particleX, player.m_20186_(), particleZ, 1, 0.0, 0.1, 0.0, 0.01);
            }
        } else if (distance <= 100.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\u271f Getting closer... \u271f"), true);
            SoundEvent medSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.soul_sand.step"));
            if (medSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), medSound, SoundSource.PLAYERS, 0.1f, 1.2f);
            }
        } else if (distance <= 258.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a77\u271f I sense something... \u271f"), true);
        }
    }

    private static void highlightMarkerBlock(ServerLevel level, BlockPos markerPos, double distanceSq) {
        int i;
        double distance = Math.sqrt(distanceSq);
        double intensityFactor = 1.0 - distance / 45.0;
        intensityFactor = Math.max(0.2, Math.min(1.0, intensityFactor));
        int particleCount = (int)(8.0 + intensityFactor * 12.0);
        double centerX = (double)markerPos.m_123341_() + 0.5;
        double centerY = (double)markerPos.m_123342_() + 0.5;
        double centerZ = (double)markerPos.m_123343_() + 0.5;
        SoundEvent bellSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.bell.resonate"));
        if (bellSound != null && level.f_46441_.m_188501_() < 0.05f) {
            level.m_6263_(null, centerX, centerY, centerZ, bellSound, SoundSource.BLOCKS, 0.05f, 0.5f);
        }
        for (i = 0; i < particleCount; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.2;
            double offsetY = level.f_46441_.m_188500_() * 1.5;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.2;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, 0.0, 0.02, 0.0, 0.01);
        }
        if (intensityFactor > 0.7) {
            for (i = 0; i < 3; ++i) {
                double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 0.8;
                double spiralX = centerX + Math.cos(angle) * radius;
                double spiralZ = centerZ + Math.sin(angle) * radius;
                double spiralY = centerY + level.f_46441_.m_188500_() * 2.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, spiralX, spiralY, spiralZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private record CompassCacheEntry(BlockPos markerPos, int foundAtTick) {
    }
}

