/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemEntityEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_RADIUS = 16;
    private static final Map<Integer, ItemEventState> activeEvents = new HashMap<Integer, ItemEventState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (Math.random() >= dynamicProb) {
            return;
        }
        List<ItemEntity> validItems = ItemEntityEventsProcedure.findValidItems(server, player);
        if (validItems.isEmpty()) {
            return;
        }
        ItemEntity chosen = validItems.get(server.m_213780_().m_188503_(validItems.size()));
        ItemEvent event = ItemEvent.values()[server.m_213780_().m_188503_(ItemEvent.values().length)];
        activeEvents.put(eventIdCounter++, new ItemEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ItemEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ItemEventState> entry = iterator.next();
            ItemEventState state = entry.getValue();
            if (state.player == null || state.player.m_213877_() || state.itemEntity == null || state.itemEntity.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case PULL_TO_PLAYER: {
                    ItemEntityEventsProcedure.handlePullToPlayer(server, state);
                    if (state.tickCount < 4) break;
                    ItemEntityEventsProcedure.resetItemPhysics(state);
                    iterator.remove();
                    break;
                }
                case PUSH_RANDOM: {
                    ItemEntityEventsProcedure.handlePushRandom(server, state);
                    if (state.tickCount < 4) break;
                    ItemEntityEventsProcedure.resetItemPhysics(state);
                    iterator.remove();
                    break;
                }
                case LEVITATE: {
                    ItemEntityEventsProcedure.handleLevitate(server, state);
                    if (state.tickCount < 40) break;
                    ItemEntityEventsProcedure.resetItemPhysics(state);
                    iterator.remove();
                }
            }
        }
    }

    private static List<ItemEntity> findValidItems(ServerLevel server, Player player) {
        ArrayList<ItemEntity> items = new ArrayList<ItemEntity>();
        for (Entity entity : server.m_8583_()) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!(entity.m_20280_((Entity)player) <= 256.0) || itemEntity.m_32059_() <= 20) continue;
            items.add(itemEntity);
        }
        return items;
    }

    private static void handlePullToPlayer(ServerLevel server, ItemEventState state) {
        if (state.tickCount == 1 && state.player.m_20280_((Entity)state.itemEntity) <= 36.0) {
            server.m_5594_(null, state.itemEntity.m_20183_(), SoundEvents.f_11898_, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
        Vec3 playerPos = state.player.m_20182_().m_82520_(0.0, 1.0, 0.0);
        Vec3 itemPos = state.itemEntity.m_20182_();
        Vec3 direction = playerPos.m_82546_(itemPos).m_82541_();
        double force = 0.8;
        state.itemEntity.m_20256_(direction.m_82490_(force));
        server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, itemPos.f_82479_, itemPos.f_82480_ + 0.2, itemPos.f_82481_, 3, 0.1, 0.1, 0.1, 0.02);
    }

    private static void handlePushRandom(ServerLevel server, ItemEventState state) {
        if (state.tickCount == 1) {
            if (state.player.m_20280_((Entity)state.itemEntity) <= 36.0) {
                server.m_5594_(null, state.itemEntity.m_20183_(), SoundEvents.f_11874_, SoundSource.BLOCKS, 0.4f, 1.8f);
            }
            double randomX = (server.m_213780_().m_188500_() - 0.5) * 2.0;
            double randomY = server.m_213780_().m_188500_() * 0.8 + 0.2;
            double randomZ = (server.m_213780_().m_188500_() - 0.5) * 2.0;
            Vec3 randomForce = new Vec3(randomX, randomY, randomZ).m_82541_().m_82490_(1.2);
            state.itemEntity.m_20256_(randomForce);
        }
        Vec3 itemPos = state.itemEntity.m_20182_();
        server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, itemPos.f_82479_, itemPos.f_82480_ + 0.2, itemPos.f_82481_, 2, 0.1, 0.1, 0.1, 0.02);
    }

    private static void handleLevitate(ServerLevel server, ItemEventState state) {
        if (state.tickCount == 1) {
            if (state.player.m_20280_((Entity)state.itemEntity) <= 36.0) {
                server.m_5594_(null, state.itemEntity.m_20183_(), SoundEvents.f_12286_, SoundSource.BLOCKS, 0.3f, 2.0f);
            }
            state.itemEntity.m_20242_(true);
        }
        if (state.tickCount <= 20) {
            currentVel = state.itemEntity.m_20184_();
            state.itemEntity.m_20334_(currentVel.f_82479_ * 0.8, 0.15, currentVel.f_82481_ * 0.8);
        } else if (state.tickCount <= 30) {
            state.itemEntity.m_20334_(0.0, 0.0, 0.0);
        } else {
            currentVel = state.itemEntity.m_20184_();
            state.itemEntity.m_20334_(currentVel.f_82479_ * 0.8, -0.1, currentVel.f_82481_ * 0.8);
        }
        if (state.tickCount % 3 == 0) {
            Vec3 itemPos = state.itemEntity.m_20182_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, itemPos.f_82479_, itemPos.f_82480_ + 0.2, itemPos.f_82481_, 5, 0.15, 0.15, 0.15, 0.02);
        }
    }

    private static void resetItemPhysics(ItemEventState state) {
        if (state.itemEntity != null && !state.itemEntity.m_213877_()) {
            state.itemEntity.m_20242_(!state.hadGravity);
        }
    }

    private static enum ItemEvent {
        PULL_TO_PLAYER,
        PUSH_RANDOM,
        LEVITATE;

    }

    private static class ItemEventState {
        ItemEvent event;
        Player player;
        ItemEntity itemEntity;
        int tickCount;
        Vec3 originalPos;
        boolean hadGravity;

        ItemEventState(ItemEvent event, Player player, ItemEntity itemEntity) {
            this.event = event;
            this.player = player;
            this.itemEntity = itemEntity;
            this.tickCount = 0;
            this.originalPos = itemEntity.m_20182_();
            this.hadGravity = !itemEntity.m_20068_();
        }
    }
}

