/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhaseProjectileAttackProcedure {
    private static final Random RAND = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.player == null) {
            return;
        }
        Level level = ev.player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!(ev.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)ev.player;
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.m_20186_() >= 50.0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, (Player)player, 6.0E-5, 7.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        boolean logicalArrow = RAND.nextBoolean();
        double offsetX = (RAND.nextDouble() - 0.5) * 16.0;
        double offsetZ = (RAND.nextDouble() - 0.5) * 16.0;
        double spawnY = player.m_20186_() + 6.0 + RAND.nextDouble() * 10.0;
        double spawnX = player.m_20185_() + offsetX;
        double spawnZ = player.m_20189_() + offsetZ;
        Vec3 target = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 spawnPos = new Vec3(spawnX, spawnY, spawnZ);
        Vec3 dir = target.m_82546_(spawnPos);
        double dist = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82480_ * dir.f_82480_ + dir.f_82481_ * dir.f_82481_);
        if (dist < 1.0E-6) {
            return;
        }
        Vec3 velocity = dir.m_82490_(1.0 / dist);
        double speed = logicalArrow ? 1.6 : 1.2;
        Vec3 finalVel = new Vec3(velocity.f_82479_ * speed, velocity.f_82480_ * speed, velocity.f_82481_ * speed);
        try {
            Arrow arrow = (Arrow)EntityType.f_20548_.m_20615_((Level)serverLevel);
            if (arrow == null) {
                return;
            }
            arrow.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            arrow.m_20256_(finalVel);
            try {
                if (!logicalArrow) {
                    arrow.m_6593_((Component)Component.m_237113_((String)"fromthecaves_snow_variant"));
                } else {
                    arrow.m_6593_((Component)Component.m_237113_((String)"fromthecaves_arrow_variant"));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean damageSet = false;
            try {
                Method m = arrow.getClass().getMethod("setBaseDamage", Double.TYPE);
                m.invoke((Object)arrow, 1.0);
                damageSet = true;
            }
            catch (Throwable m) {
                // empty catch block
            }
            if (!damageSet) {
                String[] altNames;
                for (String name : altNames = new String[]{"setDamage", "setArrowDamage", "setDamageAmount"}) {
                    try {
                        Method m2 = arrow.getClass().getMethod(name, Double.TYPE);
                        m2.invoke((Object)arrow, 1.0);
                        damageSet = true;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            if (!damageSet) {
                try {
                    Field f = arrow.getClass().getDeclaredField("damage");
                    f.setAccessible(true);
                    f.setDouble(arrow, 1.0);
                    damageSet = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            serverLevel.m_7967_((Entity)arrow);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }
}

