/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;

public class StairAmbushManagerProcedure {
    public static final int MIN_STAIR_LENGTH = 7;
    public static final int SEARCH_RADIUS = 50;
    public static final int LOOK_TICKS = 25;
    public static final double CHASE_SPEED = 0.8;
    public static final double DESPAWN_DIST_SQ = 9.0;
    public static final Set<UUID> alerted = new HashSet<UUID>();
    public static final Map<UUID, PathfinderMob> spawned = new HashMap<UUID, PathfinderMob>();
    public static final Map<UUID, Integer> lookCountdown = new HashMap<UUID, Integer>();
    public static final Set<UUID> chasing = new HashSet<UUID>();

    public static void registerSpawn(UUID uid, PathfinderMob mob) {
        spawned.put(uid, mob);
        alerted.add(uid);
    }

    public static void cleanupFor(UUID uid) {
        PathfinderMob m = spawned.remove(uid);
        if (m != null && !m.m_213877_()) {
            try {
                m.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        lookCountdown.remove(uid);
        chasing.remove(uid);
        alerted.remove(uid);
    }

    public static BlockPos detectStairTop(ServerPlayer player, ServerLevel world) {
        BlockPos origin = player.m_20183_();
        BlockPos best = null;
        int bestY = origin.m_123342_();
        for (int dx = -50; dx <= 50; ++dx) {
            for (int dz = -50; dz <= 50; ++dz) {
                for (int dy = 1; dy <= 50; ++dy) {
                    BlockPos topCandidate;
                    BlockPos pos = origin.m_7918_(dx, dy, dz);
                    BlockState state = world.m_8055_(pos);
                    if (!(state.m_60734_() instanceof StairBlock) || pos.m_123342_() <= origin.m_123342_() || !StairAmbushManagerProcedure.traceStairsTowardsPlayer(topCandidate = StairAmbushManagerProcedure.findTopOfStairChain(pos, origin, world), origin, world) || topCandidate.m_123342_() <= bestY) continue;
                    bestY = topCandidate.m_123342_();
                    best = topCandidate;
                }
            }
        }
        return best;
    }

    public static BlockPos findTopOfStairChain(BlockPos start, BlockPos player, ServerLevel world) {
        BlockPos.MutableBlockPos cursor = start.m_122032_();
        int maxSteps = 60;
        for (int i = 0; i < maxSteps; ++i) {
            BlockPos next;
            int stepX = Integer.signum(cursor.m_123341_() - player.m_123341_());
            int stepZ = Integer.signum(cursor.m_123343_() - player.m_123343_());
            if (stepX == 0 && stepZ == 0) {
                stepX = 1;
            }
            if (!(world.m_8055_(next = cursor.m_7918_(stepX, 1, stepZ)).m_60734_() instanceof StairBlock)) break;
            cursor.m_122184_(stepX, 1, stepZ);
        }
        return cursor.m_7949_();
    }

    public static boolean traceStairsTowardsPlayer(BlockPos start, BlockPos target, ServerLevel world) {
        BlockPos.MutableBlockPos cursor = start.m_122032_();
        int maxSteps = Math.abs(start.m_123342_() - target.m_123342_()) + 10;
        for (int i = 0; i < maxSteps; ++i) {
            if (cursor.m_123342_() <= target.m_123342_()) {
                return true;
            }
            int stepX = Integer.signum(target.m_123341_() - cursor.m_123341_());
            int stepZ = Integer.signum(target.m_123343_() - cursor.m_123343_());
            cursor.m_122184_(stepX, -1, stepZ);
            if (world.m_8055_((BlockPos)cursor).m_60734_() instanceof StairBlock) continue;
            return false;
        }
        return false;
    }

    public static int measureStairLength(BlockPos top, BlockPos playerPos, ServerLevel world) {
        int count = 0;
        BlockPos.MutableBlockPos cursor = top.m_122032_();
        int maxSteps = Math.abs(top.m_123342_() - playerPos.m_123342_()) + 10;
        for (int i = 0; i < maxSteps && cursor.m_123342_() > playerPos.m_123342_(); ++i) {
            int stepX = Integer.signum(playerPos.m_123341_() - cursor.m_123341_());
            int stepZ = Integer.signum(playerPos.m_123343_() - cursor.m_123343_());
            cursor.m_122184_(stepX, -1, stepZ);
            if (!(world.m_8055_((BlockPos)cursor).m_60734_() instanceof StairBlock)) break;
            ++count;
        }
        return count;
    }
}

