/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.NoAfectarProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MobsSuperInteligentesProcedure {
    private static final int BREAK_INTERVAL = 20;
    private static final int SWITCH_COOLDOWN = 20;
    private static final double BUILD_MAX_DIST_SQR = 400.0;
    private static final long BUILD_DELAY = 16L;
    private static final double BREAK_RANGE = 1.0;
    private static final double FOLLOW_SPEED = 0.7;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        Player player;
        Player near;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)ent;
        if (NoAfectarProcedure.shouldSkip((Entity)mob)) {
            return;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null || !key.m_135827_().equals("from_the_caves")) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        String idPath = key.m_135815_().toLowerCase();
        boolean isPossessed = idPath.startsWith("possessed_");
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128471_("jumpEnhanced")) {
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, 1, false, false, false));
            data.m_128379_("jumpEnhanced", true);
        }
        mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        MobsSuperInteligentesProcedure.freezeNearbyWater(mob, 1);
        if (MobsSuperInteligentesProcedure.hasAdjacentWater(mob) && (near = server.m_45930_((Entity)mob, 10.0)) != null) {
            Vec3 dir = new Vec3(near.m_20185_() - mob.m_20185_(), 0.0, near.m_20189_() - mob.m_20189_()).m_82541_();
            mob.m_20256_(mob.m_20184_().m_82549_(dir));
        }
        if ((player = server.m_45930_((Entity)mob, 42.0)) == null) {
            return;
        }
        mob.m_21573_().m_5624_((Entity)player, 0.7);
        if (!isPossessed && mob.m_21573_().m_26571_() && mob.f_19797_ % 20 == 0) {
            MobsSuperInteligentesProcedure.breakAdjacentBlocks(server, mob);
        }
        if (mob.m_21573_().m_26571_()) {
            BlockPos climbable;
            long nextSwitch;
            long tick = server.m_46467_();
            if (tick >= (nextSwitch = data.m_128454_("nextSwitchTick"))) {
                MobsSuperInteligentesProcedure.toggleNearbySwitches(server, mob, 2);
                data.m_128356_("nextSwitchTick", tick + 20L);
            }
            if ((climbable = MobsSuperInteligentesProcedure.findNearbyClimbable(server, mob.m_20183_(), 3)) != null) {
                mob.m_21573_().m_26519_((double)climbable.m_123341_() + 0.5, (double)climbable.m_123342_() + 0.5, (double)climbable.m_123343_() + 0.5, 0.7);
            }
        }
        MobsSuperInteligentesProcedure.updateCollisionAndJump(mob, (Level)server);
    }

    private static void breakAdjacentBlocks(ServerLevel server, PathfinderMob mob) {
        BlockPos[] adj;
        BlockPos o = mob.m_20183_();
        for (BlockPos p : adj = new BlockPos[]{o.m_122012_(), o.m_122019_(), o.m_122029_(), o.m_122024_(), o.m_7494_()}) {
            BlockState st = server.m_8055_(p);
            if (st.m_60795_() || !(st.m_60800_((BlockGetter)server, p) >= 0.0f)) continue;
            server.m_46961_(p, false);
            return;
        }
    }

    private static void freezeNearbyWater(PathfinderMob mob, int r) {
        Level world = mob.m_9236_();
        BlockPos o = mob.m_20183_();
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos p = o.m_7918_(dx, -1, dz);
                if (world.m_8055_(p).m_60734_() != Blocks.f_49990_) continue;
                world.m_46597_(p, Blocks.f_50126_.m_49966_());
            }
        }
    }

    private static boolean hasAdjacentWater(PathfinderMob mob) {
        Level world = mob.m_9236_();
        BlockPos o = mob.m_20183_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || world.m_8055_(o.m_7918_(dx, 0, dz)).m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }

    private static void toggleNearbySwitches(ServerLevel server, PathfinderMob mob, int r) {
        BlockPos o = mob.m_20183_();
        BooleanProperty prop = BlockStateProperties.f_61448_;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos p = o.m_7918_(dx, dy, dz);
                    BlockState st = server.m_8055_(p);
                    if (st.m_61138_((Property)prop)) {
                        server.m_46597_(p, (BlockState)st.m_61124_((Property)prop, (Comparable)Boolean.valueOf((Boolean)st.m_61143_((Property)prop) == false)));
                        continue;
                    }
                    if (!(st.m_60734_() instanceof LeverBlock) && !(st.m_60734_() instanceof ButtonBlock) || !st.m_61138_((Property)prop)) continue;
                    server.m_46597_(p, (BlockState)st.m_61124_((Property)prop, (Comparable)Boolean.valueOf((Boolean)st.m_61143_((Property)prop) == false)));
                }
            }
        }
    }

    private static BlockPos findNearbyClimbable(ServerLevel server, BlockPos origin, int radius) {
        for (int r = 1; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -1; dy <= 2; ++dy) {
                    for (int dz = -r; dz <= r; ++dz) {
                        BlockPos p = origin.m_7918_(dx, dy, dz);
                        Block block = server.m_8055_(p).m_60734_();
                        if (!(block instanceof StairBlock) && !(block instanceof LadderBlock)) continue;
                        return p;
                    }
                }
            }
        }
        return null;
    }

    private static void updateCollisionAndJump(PathfinderMob mob, Level world) {
        int R = 3;
        BlockPos o = mob.m_20183_();
        boolean hole = MobsSuperInteligentesProcedure.findNearby1x1Hole(world, o, 3);
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128441_("orig_minX")) {
            AABB bb = mob.m_20191_();
            data.m_128347_("orig_minX", bb.f_82288_);
            data.m_128347_("orig_minY", bb.f_82289_);
            data.m_128347_("orig_minZ", bb.f_82290_);
            data.m_128347_("orig_maxX", bb.f_82291_);
            data.m_128347_("orig_maxY", bb.f_82292_);
            data.m_128347_("orig_maxZ", bb.f_82293_);
        }
        boolean shrunk = data.m_128471_("shrunk_collision");
        if (hole && !shrunk) {
            MobsSuperInteligentesProcedure.setCollision(mob, 0.5f, 0.5f);
            data.m_128379_("shrunk_collision", true);
        } else if (!hole && shrunk) {
            double minX = data.m_128459_("orig_minX");
            double minY = data.m_128459_("orig_minY");
            double minZ = data.m_128459_("orig_minZ");
            double maxX = data.m_128459_("orig_maxX");
            double maxY = data.m_128459_("orig_maxY");
            double maxZ = data.m_128459_("orig_maxZ");
            mob.m_20011_(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            data.m_128379_("shrunk_collision", false);
        }
    }

    private static boolean findNearby1x1Hole(Level world, BlockPos origin, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos c = origin.m_7918_(dx, dy, dz);
                    if (!world.m_8055_(c).m_60812_((BlockGetter)world, c).m_83281_() || world.m_8055_(c.m_7494_()).m_60812_((BlockGetter)world, c.m_7494_()).m_83281_() || world.m_8055_(c.m_122012_()).m_60812_((BlockGetter)world, c.m_122012_()).m_83281_() || world.m_8055_(c.m_122019_()).m_60812_((BlockGetter)world, c.m_122019_()).m_83281_() || world.m_8055_(c.m_122029_()).m_60812_((BlockGetter)world, c.m_122029_()).m_83281_() || world.m_8055_(c.m_122024_()).m_60812_((BlockGetter)world, c.m_122024_()).m_83281_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void setCollision(PathfinderMob mob, float w, float h) {
        AABB old = mob.m_20191_();
        double y0 = old.f_82289_;
        double cx = mob.m_20185_();
        double cz = mob.m_20189_();
        mob.m_20011_(new AABB(cx - (double)(w / 2.0f), y0, cz - (double)(w / 2.0f), cx + (double)(w / 2.0f), y0 + (double)h, cz + (double)(w / 2.0f)));
    }
}

