/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase3BiteRecoveryProcedure {
    private static final int RECOVERY_DELAY = 400;
    private static final Map<UUID, Integer> RECOVERY_TIMERS = new ConcurrentHashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        if (ev.player.m_9236_().f_46443_) {
            return;
        }
        Player player = ev.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        CompoundTag pd = ev.player.getPersistentData();
        UUID uuid = ev.player.m_20148_();
        if (pd.m_128441_("origSpeed") && pd.m_128441_("origWalking")) {
            RECOVERY_TIMERS.putIfAbsent(uuid, 400);
            int ticksLeft = RECOVERY_TIMERS.get(uuid) - 1;
            if (ticksLeft > 0) {
                RECOVERY_TIMERS.put(uuid, ticksLeft);
            } else {
                double origSpeed = pd.m_128459_("origSpeed");
                float origWalking = pd.m_128457_("origWalking");
                ev.player.m_21051_(Attributes.f_22279_).m_22100_(origSpeed);
                ev.player.m_150110_().m_35948_(origWalking);
                sp.m_6885_();
                pd.m_128473_("origSpeed");
                pd.m_128473_("origWalking");
                ev.player.m_21195_(MobEffects.f_19603_);
                if (pd.m_128471_("hadJumpEffect")) {
                    int amp = pd.m_128451_("origJumpAmp");
                    int dur = pd.m_128451_("origJumpDur");
                    ev.player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, dur, amp, false, false));
                    pd.m_128473_("hadJumpEffect");
                    pd.m_128473_("origJumpAmp");
                    pd.m_128473_("origJumpDur");
                }
                BlockPos pos = ev.player.m_20183_();
                ev.player.m_9236_().m_5594_(null, pos, (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                RECOVERY_TIMERS.remove(uuid);
            }
        }
    }
}

