/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CandleProtectionProcedure {
    public static boolean isCandle(BlockState state) {
        if (state == null || state.m_60795_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof CandleBlock) {
            return true;
        }
        if (block instanceof CandleCakeBlock) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144265_)) {
            return true;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId != null) {
            String path = blockId.m_135815_().toLowerCase();
            String namespace = blockId.m_135827_().toLowerCase();
            if (path.contains("candle")) {
                return true;
            }
            if (path.equals("white_candle") || path.equals("orange_candle") || path.equals("magenta_candle") || path.equals("light_blue_candle") || path.equals("yellow_candle") || path.equals("lime_candle") || path.equals("pink_candle") || path.equals("gray_candle") || path.equals("light_gray_candle") || path.equals("cyan_candle") || path.equals("purple_candle") || path.equals("blue_candle") || path.equals("brown_candle") || path.equals("green_candle") || path.equals("red_candle") || path.equals("black_candle")) {
                return true;
            }
            if (path.equals("candle_cake")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFromTheCavesMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        return entityId.m_135827_().equals("from_the_caves");
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player breaker = event.getPlayer();
        if (breaker != null && breaker.m_6095_().toString().contains("player")) {
            return;
        }
        if (breaker == null) {
            return;
        }
        if (!CandleProtectionProcedure.isCandle(state)) {
            return;
        }
        if (!CandleProtectionProcedure.isFromTheCavesMob((Entity)breaker)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityBreakBlock(BlockEvent.EntityPlaceEvent event) {
        BlockPos[] adjacent;
        Entity entity = event.getEntity();
        if (entity != null && entity.m_6095_().toString().contains("player")) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (!CandleProtectionProcedure.isFromTheCavesMob(entity)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        for (BlockPos adjPos : adjacent = new BlockPos[]{pos.m_7494_(), pos.m_7495_(), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_()}) {
            try {
                BlockState adjState = event.getLevel().m_8055_(adjPos);
                if (!CandleProtectionProcedure.isCandle(adjState)) continue;
                event.setCanceled(true);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isCandleAt(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        try {
            BlockState state = level.m_8055_(pos);
            return CandleProtectionProcedure.isCandle(state);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean shouldPreventCandleBreak(Entity entity, BlockState block) {
        if (entity == null || block == null) {
            return false;
        }
        return CandleProtectionProcedure.isFromTheCavesMob(entity) && CandleProtectionProcedure.isCandle(block);
    }

    public static List<BlockPos> findNearbyCandlesAround(Level level, BlockPos center, int radius) {
        ArrayList<BlockPos> candles = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    if (!CandleProtectionProcedure.isCandleAt(level, pos)) continue;
                    candles.add(pos);
                }
            }
        }
        return candles;
    }
}

