/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.SessionVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves", value={Dist.CLIENT})
public class DbMeterRendererProcedure {
    private static final int BAR_WIDTH_NORMAL = 10;
    private static final int BAR_HEIGHT_NORMAL = 110;
    private static final int BAR_WIDTH_SMALL = 8;
    private static final int BAR_HEIGHT_SMALL = 60;
    private static final int MARGIN = 10;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        boolean isVisible = mc.f_91074_.getPersistentData().m_128471_("fromthecaves_dbMeterVisible");
        if (!isVisible && !mc.f_91074_.getPersistentData().m_128441_("fromthecaves_dbMeterVisible")) {
            isVisible = false;
        }
        if (!isVisible) {
            return;
        }
        String position = mc.f_91074_.getPersistentData().m_128461_("fromthecaves_dbMeterPosition");
        if (position.isEmpty()) {
            position = "left";
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        double dbLevel = SessionVariables.currentDbLevels.getOrDefault(mc.f_91074_.m_20148_(), -60.0);
        switch (position) {
            case "left": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, 10, screenHeight / 2 - 55, 10, 110, false);
                break;
            }
            case "right": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, screenWidth - 10 - 10, screenHeight / 2 - 55, 10, 110, true);
                break;
            }
            case "top_left": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, 10, 10, 10, 110, false);
                break;
            }
            case "top_right": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, screenWidth - 10 - 10, 10, 10, 110, true);
                break;
            }
            case "bottom_left": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, 10, screenHeight - 10 - 110, 10, 110, false);
                break;
            }
            case "bottom_right": {
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, screenWidth - 10 - 10, screenHeight - 10 - 110, 10, 110, true);
                break;
            }
            case "hotbar_left": {
                int hotbarY = screenHeight - 22;
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, 10, hotbarY - 60 - 5, 8, 60, false);
                break;
            }
            case "hotbar_right": {
                int hotbarY2 = screenHeight - 22;
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, screenWidth - 10 - 8, hotbarY2 - 60 - 5, 8, 60, true);
                break;
            }
            case "above_hotbar": {
                DbMeterRendererProcedure.renderHorizontalBar(guiGraphics, mc, dbLevel, screenWidth / 2 - 45, screenHeight - 50, 90, 6);
                break;
            }
            case "hotbar_right_side": {
                int hotbarRightX = screenWidth / 2 + 91 + 5;
                int hotbarCenterY = screenHeight - 22 - 18;
                DbMeterRendererProcedure.renderVerticalBar(guiGraphics, mc, dbLevel, hotbarRightX, hotbarCenterY, 8, 60, false);
            }
        }
    }

    private static void renderVerticalBar(GuiGraphics guiGraphics, Minecraft mc, double dbLevel, int x, int y, int width, int height, boolean textOnLeft) {
        int fillHeight = (int)((dbLevel + 60.0) / 60.0 * (double)height);
        fillHeight = Math.max(0, Math.min(fillHeight, height));
        guiGraphics.m_280509_(x, y, x + width, y + height, -1442840576);
        guiGraphics.m_280509_(x - 1, y - 1, x + width + 1, y, -11184811);
        guiGraphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, -11184811);
        guiGraphics.m_280509_(x - 1, y, x, y + height, -11184811);
        guiGraphics.m_280509_(x + width, y, x + width + 1, y + height, -11184811);
        if (fillHeight > 0) {
            int color = DbMeterRendererProcedure.getColorForDb(dbLevel);
            int fillStartY = y + height - fillHeight;
            guiGraphics.m_280509_(x, fillStartY, x + width, y + height, color);
        }
        String dbText = String.format("%.0f", dbLevel);
        int textX = textOnLeft ? x - mc.f_91062_.m_92895_(dbText) - 4 : x + width + 4;
        int textY = y + height + 4;
        guiGraphics.m_280056_(mc.f_91062_, dbText, textX + 1, textY + 1, -1442840576, false);
        guiGraphics.m_280056_(mc.f_91062_, dbText, textX, textY, -1, false);
        String dbLabel = "dB";
        int labelX = textOnLeft ? x - mc.f_91062_.m_92895_(dbLabel) - 4 : x + width + 4;
        int labelY = textY + 10;
        guiGraphics.m_280056_(mc.f_91062_, dbLabel, labelX + 1, labelY + 1, -1442840576, false);
        guiGraphics.m_280056_(mc.f_91062_, dbLabel, labelX, labelY, -5592406, false);
    }

    private static void renderHorizontalBar(GuiGraphics guiGraphics, Minecraft mc, double dbLevel, int x, int y, int width, int height) {
        int fillWidth = (int)((dbLevel + 60.0) / 60.0 * (double)width);
        fillWidth = Math.max(0, Math.min(fillWidth, width));
        guiGraphics.m_280509_(x, y, x + width, y + height, -1442840576);
        guiGraphics.m_280509_(x - 1, y - 1, x + width + 1, y, -11184811);
        guiGraphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, -11184811);
        guiGraphics.m_280509_(x - 1, y, x, y + height, -11184811);
        guiGraphics.m_280509_(x + width, y, x + width + 1, y + height, -11184811);
        if (fillWidth > 0) {
            int color = DbMeterRendererProcedure.getColorForDb(dbLevel);
            guiGraphics.m_280509_(x, y, x + fillWidth, y + height, color);
        }
        String dbText = String.format("%.0f dB", dbLevel);
        int textX = x + width / 2 - mc.f_91062_.m_92895_(dbText) / 2;
        int textY = y - 10;
        guiGraphics.m_280056_(mc.f_91062_, dbText, textX + 1, textY + 1, -1442840576, false);
        guiGraphics.m_280056_(mc.f_91062_, dbText, textX, textY, -1, false);
    }

    private static int getColorForDb(double dbLevel) {
        if (dbLevel < -50.0) {
            return -587137280;
        }
        if (dbLevel < -30.0) {
            return -570425600;
        }
        if (dbLevel < -15.0) {
            return -570456064;
        }
        return -570490880;
    }
}

