/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESROOFEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModSounds;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoofMobBehaviorProcedure {
    private static final long BREAK_INTERVAL = 20L;
    private static final long LIFETIME_TICKS = 300L;
    private static final long BLINDNESS_DELAY = 40L;
    private static final int BLINDNESS_DURATION = 100;
    private static final long CLOSE_DESPAWN_DELAY = 20L;

    @SubscribeEvent
    public static void onRoofMobTick(LivingEvent.LivingTickEvent event) {
        long spawnTick;
        double thresholdSq;
        double dz;
        double dy;
        double dx;
        double distSq;
        Vec3 toMobVec;
        UUID targetUUID;
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVESROOFEntity)) {
            return;
        }
        FROMTHECAVESROOFEntity roof = (FROMTHECAVESROOFEntity)ent;
        if (roof.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)roof.m_9236_();
        CompoundTag nbt = roof.getPersistentData();
        long now = server.m_46467_();
        if (!nbt.m_128441_("targetPlayerUUID")) {
            roof.m_146870_();
            return;
        }
        if (nbt.m_128423_("targetPlayerUUID") == null) {
            roof.m_146870_();
            return;
        }
        try {
            targetUUID = nbt.m_128342_("targetPlayerUUID");
        }
        catch (Throwable ex) {
            roof.m_146870_();
            return;
        }
        Player target = server.m_46003_(targetUUID);
        if (target == null) {
            roof.m_146870_();
            return;
        }
        Vec3 eyeVec = target.m_20154_().m_82541_();
        double dot = eyeVec.m_82526_(toMobVec = roof.m_20182_().m_82546_(target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0)).m_82541_());
        if (dot > 0.95 && target.m_142582_((Entity)roof)) {
            if (target instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)target;
                ResourceLocation appearRL = ForgeRegistries.SOUND_EVENTS.getKey((Object)((SoundEvent)FromTheCavesModSounds.APPEAR_1.get()));
                sp.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(appearRL, SoundSource.HOSTILE));
            }
            server.m_5594_(null, roof.m_20183_(), (SoundEvent)FromTheCavesModSounds.APPEAR_1.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            roof.m_146870_();
            return;
        }
        Vec3 dir = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0).m_82546_(roof.m_20182_().m_82520_(0.0, (double)roof.m_20192_(), 0.0)).m_82541_();
        float yaw = (float)(Math.atan2(dir.f_82481_, dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 180.0 / Math.PI);
        roof.m_146922_(yaw);
        roof.f_20883_ = yaw;
        roof.f_20885_ = yaw;
        roof.m_146926_(pitch);
        long lastBreak = nbt.m_128454_("lastBreakTick");
        if (lastBreak == 0L) {
            nbt.m_128356_("lastBreakTick", now);
            lastBreak = now;
        }
        if (now - lastBreak >= 20L) {
            double py = target.m_20186_();
            if (roof.m_20186_() > py + 1.0 || roof.m_20186_() < py - 1.0) {
                BlockState bs;
                BlockPos below = roof.m_20183_().m_7495_();
                if (!server.m_46859_(below) && !ProtectedBlocksProcedure.isProtected(bs = server.m_8055_(below))) {
                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, below, false);
                    nbt.m_128356_("lastBreakTick", now);
                    return;
                }
                nbt.m_128356_("lastBreakTick", now);
            }
        }
        if ((distSq = (dx = roof.m_20185_() - target.m_20185_()) * dx + (dy = roof.m_20186_() - target.m_20186_()) * dy + (dz = roof.m_20189_() - target.m_20189_()) * dz) <= (thresholdSq = 4.0)) {
            if (!nbt.m_128441_("closeTick")) {
                nbt.m_128356_("closeTick", now);
            } else {
                long closeTick = nbt.m_128454_("closeTick");
                if (now - closeTick >= 20L) {
                    roof.m_146870_();
                    return;
                }
            }
        } else if (nbt.m_128441_("closeTick")) {
            nbt.m_128473_("closeTick");
        }
        long seenTick = nbt.m_128454_("seenTick");
        if (seenTick == 0L) {
            for (ServerPlayer p : server.m_6907_()) {
                if (!p.m_142582_((Entity)roof)) continue;
                nbt.m_128356_("seenTick", now);
                break;
            }
        }
        if (seenTick != 0L && now - seenTick == 40L) {
            for (ServerPlayer p : server.m_6907_()) {
                if (!p.m_142582_((Entity)roof)) continue;
                p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                SoundEvent ambient = (SoundEvent)SoundEvents.f_11689_.get();
                server.m_5594_(null, p.m_20183_(), ambient, SoundSource.AMBIENT, 1.0f, 0.75f);
            }
        }
        if (now - (spawnTick = nbt.m_128454_("spawnTick")) >= 300L) {
            roof.m_146870_();
        }
    }
}

