/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.client.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InkedOverlay {
    private static final ResourceLocation INK_TEXTURE = new ResourceLocation("from_the_caves:textures/screens/55.png");
    private static volatile boolean isInkedClient = false;
    private static final AtomicLong inkedUntilClient = new AtomicLong(0L);

    public static void setClientInked(long inkedUntil) {
        isInkedClient = true;
        inkedUntilClient.set(inkedUntil);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        if (!isInkedClient) {
            return;
        }
        if (minecraft.f_91073_ == null) {
            isInkedClient = false;
            inkedUntilClient.set(0L);
            return;
        }
        long now = minecraft.f_91073_.m_46467_();
        long inkedUntil = inkedUntilClient.get();
        long ticksLeft = inkedUntil - now;
        if (ticksLeft <= 0L) {
            isInkedClient = false;
            inkedUntilClient.set(0L);
            return;
        }
        InkedOverlay.renderInkOverlay(event, minecraft, ticksLeft);
    }

    private static void renderInkOverlay(RenderGuiEvent.Post event, Minecraft minecraft, long timeLeftTicks) {
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        float alpha = 1.0f;
        if (timeLeftTicks < 20L) {
            alpha = (float)timeLeftTicks / 20.0f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)INK_TEXTURE);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.7f));
        event.getGuiGraphics().m_280163_(INK_TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

