/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class SetPlayerSpawnInVillageProcedure {
    private static final File CONFIG_FILE = FMLPaths.CONFIGDIR.get().resolve("fromthecavesserver.toml").toFile();
    private static final TagKey<Structure> DEFAULT_VILLAGE_TAG = StructureTags.f_215889_;
    private static final String PERSISTED_TAG = "PlayerPersisted";
    private static final String FLAG_KEY = "FromTheCavesFirstSpawn";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CompoundTag root = player.getPersistentData();
        CompoundTag persisted = root.m_128425_(PERSISTED_TAG, 10) ? root.m_128469_(PERSISTED_TAG) : new CompoundTag();
        if (persisted.m_128471_(FLAG_KEY)) {
            return;
        }
        boolean spawnInVillageEnabled = false;
        String locateVillageTag = "#minecraft:village";
        boolean keepDefaultVillageTagBackup = true;
        boolean startInPhase1 = false;
        double defaultSingleplayerMultiplier = 0.85;
        double defaultMultiplayerScale = 0.25;
        CommentedFileConfig config = null;
        try {
            if (!CONFIG_FILE.exists()) {
                File parent = CONFIG_FILE.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                config = (CommentedFileConfig)CommentedFileConfig.builder((File)CONFIG_FILE).sync().autosave().writingMode(WritingMode.REPLACE).build();
                config.set("spawn_in_village_enabled", (Object)spawnInVillageEnabled);
                config.set("locateVillageTag", (Object)locateVillageTag);
                config.set("keepDefaultVillageTagBackup", (Object)keepDefaultVillageTagBackup);
                config.set("start_in_phase_1", (Object)startInPhase1);
                config.set("default_singleplayer_multiplier", (Object)defaultSingleplayerMultiplier);
                config.setComment("default_singleplayer_multiplier", "Min: 0.0 | Max: 1.5 | Default: 0.85");
                config.set("default_multiplayer_scale", (Object)defaultMultiplayerScale);
                config.setComment("default_multiplayer_scale", "Min: 0.0 | Max: 1.0 | Default: 0.25");
                config.save();
                config.close();
            }
            config = (CommentedFileConfig)CommentedFileConfig.builder((File)CONFIG_FILE).sync().autosave().writingMode(WritingMode.REPLACE).build();
            config.load();
            spawnInVillageEnabled = (Boolean)config.getOrElse("spawn_in_village_enabled", (Object)false);
            locateVillageTag = (String)config.getOrElse("locateVillageTag", (Object)"#minecraft:village");
            keepDefaultVillageTagBackup = (Boolean)config.getOrElse("keepDefaultVillageTagBackup", (Object)true);
            startInPhase1 = (Boolean)config.getOrElse("start_in_phase_1", (Object)false);
            try {
                defaultSingleplayerMultiplier = (Double)config.getOrElse("default_singleplayer_multiplier", (Object)0.85);
                defaultSingleplayerMultiplier = Math.max(0.0, Math.min(1.5, defaultSingleplayerMultiplier));
            }
            catch (Exception e) {
                defaultSingleplayerMultiplier = 0.85;
            }
            try {
                defaultMultiplayerScale = (Double)config.getOrElse("default_multiplayer_scale", (Object)0.25);
                defaultMultiplayerScale = Math.max(0.0, Math.min(1.0, defaultMultiplayerScale));
            }
            catch (Exception e) {
                defaultMultiplayerScale = 0.25;
            }
        }
        catch (Exception e) {
            spawnInVillageEnabled = false;
        }
        finally {
            if (config != null) {
                try {
                    config.close();
                }
                catch (Exception e) {}
            }
        }
        ChunkTensionProcedure.setSingleplayerMultiplier(defaultSingleplayerMultiplier);
        ChunkTensionProcedure.setMultiplayerScaleFactor(defaultMultiplayerScale);
        if (startInPhase1) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)serverLevel, 1);
        }
        if (!spawnInVillageEnabled) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        BlockPos structPos = null;
        if (locateVillageTag != null && !locateVillageTag.isEmpty()) {
            try {
                String tagName = locateVillageTag.startsWith("#") ? locateVillageTag.substring(1) : locateVillageTag;
                TagKey structureTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(tagName));
                structPos = serverLevel.m_215011_(structureTag, player.m_20183_(), 100, false);
            }
            catch (Exception tagName) {
                // empty catch block
            }
        }
        if (structPos == null && keepDefaultVillageTagBackup) {
            try {
                structPos = serverLevel.m_215011_(DEFAULT_VILLAGE_TAG, player.m_20183_(), 100, false);
            }
            catch (Exception tagName) {
                // empty catch block
            }
        }
        if (structPos == null) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        int x = structPos.m_123341_();
        int z = structPos.m_123343_();
        int maxHeight = serverLevel.m_151558_();
        int highestNonAirY = -1;
        for (int y = maxHeight - 1; y >= 0; --y) {
            BlockPos checkPos = new BlockPos(x, y, z);
            BlockState state = serverLevel.m_8055_(checkPos);
            if (state.m_60795_()) continue;
            highestNonAirY = y;
            break;
        }
        if (highestNonAirY < 0 && (highestNonAirY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z)) > 0) {
            --highestNonAirY;
        }
        if (highestNonAirY < 0) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        BlockPos spawnPos = new BlockPos(x, highestNonAirY + 1, z);
        player.m_9158_(serverLevel.m_46472_(), spawnPos, 0.0f, true, false);
        try {
            player.m_6021_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        }
        catch (NoSuchMethodError nsme) {
            try {
                player.m_8999_(serverLevel, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        persisted.m_128379_(FLAG_KEY, true);
        root.m_128365_(PERSISTED_TAG, (Tag)persisted);
    }
}

