/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SkyStormEffectProcedure {
    private static final double DETECTION_RADIUS = 120.0;
    private static final int STORM_DURATION = 1200;
    private static final int CHECK_INTERVAL = 20;
    private static final int LIGHTNING_INTERVAL = 300;
    private static final double LIGHTNING_SPAWN_RADIUS = 40.0;
    private static final Map<String, Long> stormExpiryByDimension = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Boolean> stormOwnedByDimension = new ConcurrentHashMap<String, Boolean>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer() == null) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            String dimKey;
            long now;
            if (!level.m_46472_().equals((Object)Level.f_46428_) || (now = level.m_46467_()) % 20L != 0L) continue;
            try {
                dimKey = level.m_46472_().m_135782_().toString();
            }
            catch (Throwable t) {
                dimKey = level.m_46472_().toString();
            }
            List skyMobs = level.m_6249_((Entity)null, new AABB(-3.0E7, -100.0, -3.0E7, 3.0E7, 400.0, 3.0E7), entity -> entity.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESSKY.get()));
            if (!skyMobs.isEmpty()) {
                long expiry = now + 1200L;
                stormExpiryByDimension.put(dimKey, expiry);
                if (!level.m_46470_()) {
                    level.m_8606_(0, 1200, true, true);
                    stormOwnedByDimension.put(dimKey, true);
                } else {
                    stormOwnedByDimension.putIfAbsent(dimKey, false);
                }
                for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
                    p.getPersistentData().m_128356_("skyMobStormTime", now);
                    p.getPersistentData().m_128379_("skyMobStormActive", true);
                }
                if (now % 300L != 0L) continue;
                for (Entity skyMob : skyMobs) {
                    SkyStormEffectProcedure.spawnLightningAroundMob(level, skyMob);
                }
                continue;
            }
            Long expiry = stormExpiryByDimension.get(dimKey);
            boolean stillStorm = expiry != null && expiry > now;
            boolean owned = stormOwnedByDimension.getOrDefault(dimKey, false);
            if (stillStorm) {
                if (owned) {
                    int remaining = (int)Math.max(1L, expiry - now);
                    level.m_8606_(0, remaining, true, true);
                }
                for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
                    p.getPersistentData().m_128356_("skyMobStormTime", now);
                    p.getPersistentData().m_128379_("skyMobStormActive", true);
                }
                continue;
            }
            stormExpiryByDimension.remove(dimKey);
            if (owned && (level.m_46470_() || level.m_46471_())) {
                level.m_8606_(6000, 0, false, false);
            }
            for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
                p.getPersistentData().m_128379_("skyMobStormActive", false);
            }
            stormOwnedByDimension.remove(dimKey);
        }
    }

    private static void spawnLightningAroundMob(ServerLevel level, Entity mob) {
        AABB searchBox = mob.m_20191_().m_82400_(120.0);
        List nearbyPlayers = level.m_45976_(ServerPlayer.class, searchBox);
        if (nearbyPlayers.isEmpty()) {
            return;
        }
        int lightningCount = 2 + level.f_46441_.m_188503_(3);
        for (int i = 0; i < lightningCount; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double distance = 10.0 + level.f_46441_.m_188500_() * 40.0;
            double lx = mob.m_20185_() + Math.cos(angle) * distance;
            double lz = mob.m_20189_() + Math.sin(angle) * distance;
            BlockPos approx = new BlockPos((int)lx, (int)mob.m_20186_(), (int)lz);
            BlockPos strikePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, approx);
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
            if (lightning != null) {
                lightning.m_20219_(Vec3.m_82539_((Vec3i)strikePos));
                lightning.m_20874_(false);
                level.m_7967_((Entity)lightning);
            }
            level.m_5594_(null, strikePos, SoundEvents.f_12090_, SoundSource.WEATHER, 2.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        }
    }
}

