/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVES2STEALEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ThiefBehaviorProcedure {
    private static final int BREAK_INTERVAL = 5;
    private static final double CHASE_SPEED = 0.7;
    private static final double ESCAPE_SPEED = 0.8;
    private static final int ESCAPE_RADIUS = 40;
    private static final long STEAL_TTL = 100L;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        long stoleAt;
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVES2STEALEntity)) {
            return;
        }
        FROMTHECAVES2STEALEntity thief = (FROMTHECAVES2STEALEntity)ent;
        if (ent.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)ent.m_9236_();
        CompoundTag data = thief.getPersistentData();
        long now = level.m_46467_();
        if (data.m_128471_("stolen") && data.m_128441_("stealTime") && now - (stoleAt = data.m_128454_("stealTime")) >= 100L) {
            thief.m_146870_();
            return;
        }
        int bc = data.m_128451_("breakCounter") + 1;
        if (bc >= 5) {
            BlockPos pos = ent.m_20183_();
            Direction facing = ent.m_6350_();
            BlockPos feet = pos.m_121945_(facing);
            BlockPos head = feet.m_7494_();
            if (!level.m_8055_(feet).m_60795_()) {
                level.m_46961_(feet, true);
            }
            if (!level.m_8055_(head).m_60795_()) {
                level.m_46961_(head, false);
            }
            bc = 0;
        }
        data.m_128405_("breakCounter", bc);
        Player target = level.m_45930_((Entity)ent, 16.0);
        if (target == null) {
            return;
        }
        boolean stolen = data.m_128471_("stolen");
        PathNavigation nav = thief.m_21573_();
        if (!stolen) {
            boolean hasCross = false;
            for (ItemStack s : target.m_150109_().f_35974_) {
                if (s.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get()) continue;
                hasCross = true;
                break;
            }
            if ((double)ent.m_20270_((Entity)target) <= 1.0) {
                if (!hasCross) {
                    level.m_5594_(null, ent.m_20183_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                    thief.m_146870_();
                    return;
                }
                ThiefBehaviorProcedure.stealCrossFromPlayer(thief, target, level, data, now);
            } else {
                Path path = nav.m_6570_((Entity)target, 0);
                if (path != null) {
                    nav.m_26536_(path, 0.7);
                }
            }
        } else {
            double ex = data.m_128459_("escapeX");
            double ey = data.m_128459_("escapeY");
            double ez = data.m_128459_("escapeZ");
            nav.m_26519_(ex, ey, ez, 0.8);
            if (!target.m_142582_((Entity)ent)) {
                thief.m_146870_();
            }
        }
    }

    private static void stealCrossFromPlayer(FROMTHECAVES2STEALEntity thief, Player player, ServerLevel level, CompoundTag data, long now) {
        int crossSlot = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack s = player.m_150109_().m_8020_(i);
            if (s.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get()) continue;
            crossSlot = i;
            break;
        }
        if (crossSlot < 0) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(crossSlot);
        ItemStack stolen = stack.m_41620_(1);
        player.m_150109_().m_6836_(crossSlot, stack);
        thief.m_8061_(EquipmentSlot.MAINHAND, stolen);
        data.m_128379_("stolen", true);
        data.m_128365_("stolenItem", (Tag)stolen.serializeNBT());
        data.m_128356_("stealTime", now);
        RandomSource rng = player.m_217043_();
        double ex = thief.m_20185_() + (rng.m_188500_() * 2.0 - 1.0) * 40.0;
        double ez = thief.m_20189_() + (rng.m_188500_() * 2.0 - 1.0) * 40.0;
        data.m_128347_("escapeX", ex);
        data.m_128347_("escapeY", thief.m_20186_());
        data.m_128347_("escapeZ", ez);
        thief.m_21051_(Attributes.f_22279_).m_22100_(0.8);
        thief.m_21573_().m_26519_(ex, thief.m_20186_(), ez, 0.8);
    }
}

