/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FrontTunnelTriggerProcedure {
    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null || !key.m_135827_().equals("from_the_caves")) {
            return;
        }
        FrontTunnelTriggerProcedure.handleFrontEdgeTunnel(mob);
    }

    private static void handleFrontEdgeTunnel(Mob mob) {
        Vec3 lookXZ;
        Level world = mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128441_("orig_width")) {
            data.m_128347_("orig_width", (double)mob.m_20205_());
            data.m_128347_("orig_height", (double)mob.m_20206_());
            Pose p = mob.m_20089_();
            data.m_128359_("orig_pose", p == null ? Pose.STANDING.name() : p.name());
            data.m_128379_("in_front_tunnel_state", false);
        }
        boolean currentlyInState = data.m_128471_("in_front_tunnel_state");
        Vec3 look = mob.m_20154_();
        if (look == null) {
            look = new Vec3(0.0, 0.0, 1.0);
        }
        if ((lookXZ = new Vec3(look.f_82479_, 0.0, look.f_82481_)).m_82553_() == 0.0) {
            lookXZ = new Vec3(0.0, 0.0, 1.0);
        }
        lookXZ = lookXZ.m_82541_();
        double halfWidth = (double)mob.m_20205_() / 2.0;
        double checkDist = halfWidth + 1.0;
        double px = mob.m_20185_() + lookXZ.f_82479_ * checkDist;
        double pz = mob.m_20189_() + lookXZ.f_82481_ * checkDist;
        double py = mob.m_20186_();
        BlockPos checkPos = new BlockPos((int)Math.floor(px), (int)Math.floor(py), (int)Math.floor(pz));
        boolean bottomEmpty = world.m_46859_(checkPos);
        boolean topEmpty = world.m_46859_(checkPos.m_7494_());
        if (topEmpty && !bottomEmpty && !currentlyInState) {
            mob.m_20124_(Pose.CROUCHING);
            double tx = (double)checkPos.m_123341_() + 0.5;
            double ty = (double)checkPos.m_123342_() + 1.0;
            double tz = (double)checkPos.m_123343_() + 0.5;
            mob.m_6034_(tx, ty, tz);
            FrontTunnelTriggerProcedure.setBoundingBox(mob, 0.5, 0.5);
            data.m_128379_("in_front_tunnel_state", true);
            data.m_128379_("forceCrawl", true);
            data.m_128347_("destX", tx);
            data.m_128347_("destY", ty);
            data.m_128347_("destZ", tz);
            data.m_128347_("moveSpeed", 0.4);
        } else if (topEmpty && bottomEmpty && !currentlyInState) {
            mob.m_20124_(Pose.CROUCHING);
            FrontTunnelTriggerProcedure.setBoundingBox(mob, 0.5, 0.5);
            data.m_128379_("in_front_tunnel_state", true);
            data.m_128379_("forceCrawl", false);
        } else if (!topEmpty && currentlyInState) {
            FrontTunnelTriggerProcedure.restoreState(mob, data);
        } else if (topEmpty && !currentlyInState || topEmpty || !currentlyInState) {
            // empty if block
        }
    }

    private static void restoreState(Mob mob, CompoundTag data) {
        String origPoseName = data.m_128461_("orig_pose");
        Pose origPose = Pose.STANDING;
        try {
            if (origPoseName != null && !origPoseName.isEmpty()) {
                origPose = Pose.valueOf((String)origPoseName);
            }
        }
        catch (IllegalArgumentException ex) {
            origPose = Pose.STANDING;
        }
        mob.m_20124_(origPose);
        double origWidth = data.m_128459_("orig_width");
        double origHeight = data.m_128459_("orig_height");
        FrontTunnelTriggerProcedure.setBoundingBox(mob, origWidth, origHeight);
        data.m_128379_("in_front_tunnel_state", false);
        data.m_128379_("forceCrawl", false);
    }

    private static void setBoundingBox(Mob mob, double fullWidth, double height) {
        double halfW = fullWidth / 2.0;
        double x = mob.m_20185_();
        double y = mob.m_20186_();
        double z = mob.m_20189_();
        AABB bb = new AABB(x - halfW, y, z - halfW, x + halfW, y + height, z + halfW);
        mob.m_20011_(bb);
    }
}

