/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PossessedWatcherSpawnProcedure {
    private static final double SPAWN_PROB = 2.5E-4;
    private static final double MIN_DIST = 23.0;
    private static final double MAX_DIST = 40.0;
    private static final double WATCH_DISTANCE = 64.0;
    private static final double CHASE_TRIGGER_DIST = 20.0;
    private static final int LOOK_TRIGGER_TICKS = 160;
    private static final double RUN_SPEED = 0.7;
    private static final int RUN_DURATION_TICKS = 160;
    private static final int BREAK_TICKS = 5;
    private static final int BREAK_SEARCH_AHEAD = 1;
    private static final String KEY_SPAWN_TIME = "pw_spawnTime";
    private static final String KEY_LOOK_START = "pw_lookStart";
    private static final String KEY_RUNNING = "pw_running";
    private static final String KEY_RUN_START = "pw_runStart";
    private static final String KEY_LAST_BREAK = "pw_lastBreakTick";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (Math.random() >= 2.5E-4) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 23.0 + Math.random() * 17.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        double sy = player.m_20186_();
        Mob mob = (Mob)((EntityType)FromTheCavesModEntities.POSSESSED_WATCHER.get()).m_262496_(level, BlockPos.m_274561_((double)sx, (double)sy, (double)sz), MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        BlockPos mPos = mob.m_20183_();
        if (!level.m_8055_(mPos).m_60795_()) {
            mob.m_146870_();
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        CompoundTag data = mob.getPersistentData();
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128405_(KEY_LAST_BREAK, 0);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_WATCHER.get())) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 64.0);
        if (player == null) {
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        boolean running = data.m_128471_(KEY_RUNNING);
        if (!running) {
            boolean inSightCone;
            double dx = player.m_20185_() - mob.m_20185_();
            double dz = player.m_20189_() - mob.m_20189_();
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20883_ = yaw;
            mob.f_20885_ = yaw;
            mob.m_146926_(0.0f);
            if (dist <= 20.0) {
                PossessedWatcherSpawnProcedure.startRunning(mob, data, now);
                return;
            }
            boolean hasLOS = player.m_142582_((Entity)mob);
            Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
            Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
            if (toMob.m_82553_() == 0.0) {
                if (data.m_128441_(KEY_LOOK_START)) {
                    data.m_128473_(KEY_LOOK_START);
                }
                return;
            }
            Vec3 toMobNorm = toMob.m_82541_();
            double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
            boolean bl = inSightCone = dot > 0.95 && hasLOS;
            if (inSightCone) {
                if (!data.m_128441_(KEY_LOOK_START)) {
                    data.m_128356_(KEY_LOOK_START, now);
                } else {
                    long started = data.m_128454_(KEY_LOOK_START);
                    if (now - started >= 160L) {
                        PossessedWatcherSpawnProcedure.startRunning(mob, data, now);
                        return;
                    }
                }
            } else if (data.m_128441_(KEY_LOOK_START)) {
                data.m_128473_(KEY_LOOK_START);
            }
            return;
        }
        if (!player.m_142582_((Entity)mob)) {
            mob.m_146870_();
            return;
        }
        Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
        if (fleeDir.m_82556_() < 1.0E-6) {
            Vec3 look = player.m_20252_(1.0f).m_82541_();
            fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
        } else {
            fleeDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        }
        mob.m_21557_(true);
        mob.m_20242_(false);
        double speedFactor = 0.63;
        Vec3 motion = new Vec3(fleeDir.f_82479_ * speedFactor, mob.m_20184_().f_82480_, fleeDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable yaw) {
            // empty catch block
        }
        Vec3 predicted = new Vec3(mob.m_20185_() + motion.f_82479_, mob.m_20186_() + motion.f_82480_, mob.m_20189_() + motion.f_82481_);
        double dx = predicted.f_82479_ - mob.m_20185_();
        double dz = predicted.f_82481_ - mob.m_20189_();
        if (Math.abs(dx) < 1.0E-5 && Math.abs(dz) < 1.0E-5) {
            double nudge = 0.5;
            double nx = mob.m_20185_() + fleeDir.f_82479_ * nudge;
            double nz = mob.m_20189_() + fleeDir.f_82481_ * nudge;
            mob.m_6021_(nx, mob.m_20186_(), nz);
        }
        int lastBreak = data.m_128451_(KEY_LAST_BREAK);
        data.m_128405_(KEY_LAST_BREAK, ++lastBreak);
        if (lastBreak >= 5) {
            data.m_128405_(KEY_LAST_BREAK, 0);
            double aheadX = mob.m_20185_() + fleeDir.f_82479_ * 1.0;
            double aheadY = mob.m_20186_();
            double aheadZ = mob.m_20189_() + fleeDir.f_82481_ * 1.0;
            BlockPos aheadPos = BlockPos.m_274561_((double)aheadX, (double)aheadY, (double)aheadZ);
            if (level.m_46749_(aheadPos)) {
                BlockState bs = level.m_8055_(aheadPos);
                if (!bs.m_60795_() && bs.m_60734_() != Blocks.f_50752_) {
                    level.m_46961_(aheadPos, true);
                } else {
                    BlockState bs2;
                    BlockPos tryAbove = aheadPos.m_7494_();
                    if (level.m_46749_(tryAbove) && !(bs2 = level.m_8055_(tryAbove)).m_60795_() && bs2.m_60734_() != Blocks.f_50752_) {
                        level.m_46961_(tryAbove, true);
                    }
                }
            }
        }
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 160L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        data.m_128405_(KEY_LAST_BREAK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
    }
}

