/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVESTORCHEntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TorchBreakProcedure {
    private static final int BREAK_DELAY = 20;
    private static final int MAX_BREAKS = 6;
    private static final int RADIUS = 3;
    private static final double SOUND_CHANCE_BREAK = 0.1;
    private static final int BLINDNESS_DURATION = 300;

    @SubscribeEvent
    public static void onTorchMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVESTORCHEntity)) {
            return;
        }
        FROMTHECAVESTORCHEntity mob = (FROMTHECAVESTORCHEntity)ent;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)lvl);
        if (phase < 1 || phase > 3) {
            return;
        }
        ServerLevel server = (ServerLevel)lvl;
        CompoundTag data = mob.getPersistentData();
        long tick = server.m_46467_();
        if (!data.m_128441_("torchStartTick")) {
            data.m_128356_("torchStartTick", tick);
            data.m_128405_("torchBreakCount", 0);
            data.m_128356_("nextTorchBreakTick", tick);
        }
        int broken = data.m_128451_("torchBreakCount");
        long start = data.m_128454_("torchStartTick");
        if (broken >= 6 || tick - start >= 120L) {
            mob.m_146870_();
            return;
        }
        long nextBreak = data.m_128454_("nextTorchBreakTick");
        if (tick < nextBreak) {
            return;
        }
        BlockPos origin = mob.m_20183_();
        BlockPos toBreak = null;
        block0: for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos pos = origin.m_7918_(dx, dy, dz);
                    BlockState st = lvl.m_8055_(pos);
                    if (st.m_60734_() != Blocks.f_50081_ && st.m_60734_() != Blocks.f_50082_ && st.m_60734_() != Blocks.f_152482_ && st.m_60734_() != Blocks.f_152525_ && st.m_60734_() != Blocks.f_50681_ && st.m_60734_() != Blocks.f_50139_ && st.m_60734_() != Blocks.f_50140_ && st.m_60734_() != Blocks.f_50682_) continue;
                    toBreak = pos;
                    break block0;
                }
            }
        }
        if (toBreak != null) {
            server.m_46961_(toBreak, false);
            if (Math.random() < 0.1) {
                Player p;
                SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_10"));
                if (se != null) {
                    server.m_5594_(null, toBreak, se, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                if ((p = server.m_45930_((Entity)mob, 16.0)) != null) {
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 255, false, true));
                    p.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 300, 255, false, true));
                    server.m_5594_(null, p.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "heartbeat")), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        data.m_128405_("torchBreakCount", broken + 1);
        data.m_128356_("nextTorchBreakTick", tick + 20L);
    }
}

