/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSHADOWEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WindowEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int FACE_DURATION = 60;
    private static final int FACE_DESPAWN_DELAY = 6;
    private static final int TAP_CYCLES = 3;
    private static final int TAP_INTERVAL = 16;
    private static final int SHADOW_DURATION = 10;
    private static final int GLASS_DURATION = 60;
    private static final Map<Integer, WindowEventState> activeEvents = new HashMap<Integer, WindowEventState>();
    private static final Map<BlockPos, Long> windowCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<WindowInfo> validWindows = WindowEventsProcedure.findValidWindows(server, player);
        if (validWindows.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validWindows.removeIf(window -> windowCooldowns.containsKey(window.glassPos) && currentTime < windowCooldowns.get(window.glassPos));
        if (validWindows.isEmpty()) {
            return;
        }
        WindowInfo chosen = validWindows.get(server.m_213780_().m_188503_(validWindows.size()));
        WindowEvent event = WindowEvent.values()[server.m_213780_().m_188503_(WindowEvent.values().length)];
        windowCooldowns.put(chosen.glassPos, currentTime + 5L);
        FROMTHECAVESSHADOWEntity entity = null;
        if ((event == WindowEvent.FACE_IN_WINDOW || event == WindowEvent.SHADOW_PASS) && FromTheCavesModEntities.FROMTHECAVESSHADOW.get() != null) {
            entity = (FROMTHECAVESSHADOWEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get()).m_20615_((Level)server);
            if (entity == null) {
                return;
            }
            entity.getPersistentData().m_128379_("FromWindowsEvent", true);
            entity.getPersistentData().m_128405_("WindowTicksAlive", 0);
        }
        activeEvents.put(eventIdCounter++, new WindowEventState(event, player, chosen, entity));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        SoundEvent knockSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "singleknock"));
        if (knockSound == null) {
            knockSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.hit"));
        }
        if (knockSound == null) {
            knockSound = SoundEvents.f_12630_;
        }
        ArrayList<Map.Entry<Integer, WindowEventState>> entries = new ArrayList<Map.Entry<Integer, WindowEventState>>(activeEvents.entrySet());
        for (Map.Entry entry : entries) {
            CompoundTag data;
            Integer id = (Integer)entry.getKey();
            WindowEventState state = (WindowEventState)entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                activeEvents.remove(id);
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            if (state.entity != null && state.entity.m_6084_() && (data = state.entity.getPersistentData()).m_128471_("FromWindowsEvent")) {
                int aliveTicks = data.m_128451_("WindowTicksAlive") + 1;
                data.m_128405_("WindowTicksAlive", aliveTicks);
                if (aliveTicks >= 60) {
                    state.entity.m_146870_();
                }
            }
            switch (state.event) {
                case FACE_IN_WINDOW: {
                    WindowEventsProcedure.handleFaceInWindow(server, state);
                    if (state.tickCount < 60 && (state.entity == null || state.entity.m_6084_())) break;
                    activeEvents.remove(id);
                    break;
                }
                case WINDOW_TAP: {
                    WindowEventsProcedure.handleWindowTap(server, state, knockSound);
                    if (state.cycle > 0) break;
                    activeEvents.remove(id);
                    break;
                }
                case SHADOW_PASS: {
                    WindowEventsProcedure.handleShadowPass(server, state);
                    if (state.entity != null && state.entity.m_6084_()) break;
                    activeEvents.remove(id);
                    break;
                }
                case BROKEN_GLASS: {
                    WindowEventsProcedure.handleBrokenGlass(server, state);
                    if (state.tickCount < 60) break;
                    activeEvents.remove(id);
                }
            }
        }
    }

    private static List<WindowInfo> findValidWindows(ServerLevel server, Player player) {
        ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        int radiusChunks = 1;
        int playerChunkX = player.m_146902_().f_45578_;
        int playerChunkZ = player.m_146902_().f_45579_;
        int playerY = player.m_20183_().m_123342_();
        int minY = Math.max(0, playerY - 6);
        int maxY = Math.min(server.m_151558_() - 1, playerY + 6);
        for (int dx = -radiusChunks; dx <= radiusChunks; ++dx) {
            for (int dz = -radiusChunks; dz <= radiusChunks; ++dz) {
                LevelChunk chunk = server.m_6325_(playerChunkX + dx, playerChunkZ + dz);
                int baseX = chunk.m_7697_().m_45604_();
                int baseZ = chunk.m_7697_().m_45605_();
                for (int lx = 0; lx < 16; ++lx) {
                    for (int lz = 0; lz < 16; ++lz) {
                        block4: for (int y = minY; y <= maxY; ++y) {
                            BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                            BlockState state = server.m_8055_(pos);
                            if (!WindowEventsProcedure.isGlassBlock(state)) continue;
                            for (Direction dir : Direction.Plane.HORIZONTAL) {
                                BlockPos outside = pos.m_121945_(dir);
                                if (!server.m_8055_(outside).m_60795_()) continue;
                                windows.add(new WindowInfo(pos.m_7949_(), dir, outside.m_7949_(), state));
                                continue block4;
                            }
                        }
                    }
                }
            }
        }
        return windows;
    }

    private static void handleFaceInWindow(ServerLevel server, WindowEventState state) {
        if (state.tickCount == 1 && state.entity != null) {
            Vec3 spawnPos = new Vec3((double)state.window.outsidePos.m_123341_() + 0.5, (double)state.window.outsidePos.m_123342_(), (double)state.window.outsidePos.m_123343_() + 0.5);
            double dx = state.player.m_20185_() - spawnPos.f_82479_;
            double dz = state.player.m_20189_() - spawnPos.f_82481_;
            float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            state.entity.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, yaw, 0.0f);
            state.entity.m_146922_(yaw);
            state.entity.f_20885_ = yaw;
            state.entity.f_20883_ = yaw;
            state.entity.m_21557_(true);
            state.entity.m_20242_(true);
            state.entity.m_20124_(Pose.CROUCHING);
            state.entity.m_20225_(true);
            CompoundTag nbt = state.entity.getPersistentData();
            nbt.m_128356_("window_spawnTime", server.m_46467_());
            nbt.m_128362_("window_owner", state.player.m_20148_());
            nbt.m_128359_("window_role", "face");
            nbt.m_128379_("FromWindowsEvent", true);
            server.m_7967_((Entity)state.entity);
        } else if (state.entity != null && state.entity.m_6084_()) {
            Vec3 mobPos = state.entity.m_20182_();
            Vec3 toPlayer = state.player.m_146892_().m_82546_(mobPos);
            float yaw = (float)Math.toDegrees(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_)) - 90.0f;
            state.entity.m_146922_(yaw);
            state.entity.f_20885_ = yaw;
            state.entity.f_20883_ = yaw;
            Vec3 playerLook = state.player.m_20154_().m_82541_();
            Vec3 toEntity = mobPos.m_82546_(state.player.m_146892_()).m_82541_();
            double dot = playerLook.m_82526_(toEntity);
            if (dot > 0.85 && !state.playerSawEntity) {
                state.playerSawEntity = true;
                state.sawEntityTick = server.m_46467_();
            }
            if (state.playerSawEntity && server.m_46467_() - state.sawEntityTick >= 6L) {
                state.entity.m_146870_();
            }
            if (state.tickCount >= 60) {
                state.entity.m_146870_();
            }
        }
    }

    private static void handleWindowTap(ServerLevel server, WindowEventState state, SoundEvent knockSound) {
        if (state.tickCount % 16 == 0 && state.cycle > 0) {
            server.m_5594_(null, state.window.glassPos, knockSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            --state.cycle;
        }
    }

    private static void handleShadowPass(ServerLevel server, WindowEventState state) {
        if (state.entity == null) {
            return;
        }
        if (state.tickCount == 1) {
            Direction facing = state.window.facing;
            Direction perp = facing.m_122427_();
            int range = 8;
            BlockPos start = state.window.outsidePos.m_5484_(perp, -range);
            BlockPos end = state.window.outsidePos.m_5484_(perp, range);
            double y = (double)state.window.outsidePos.m_123342_() + 0.5;
            state.entity.m_7678_((double)start.m_123341_() + 0.5, y, (double)start.m_123343_() + 0.5, 0.0f, 0.0f);
            state.entity.m_21557_(true);
            state.entity.m_20242_(true);
            state.entity.m_20225_(true);
            CompoundTag data = state.entity.getPersistentData();
            data.m_128405_("shadowStartX", start.m_123341_());
            data.m_128405_("shadowStartZ", start.m_123343_());
            data.m_128405_("shadowEndX", end.m_123341_());
            data.m_128405_("shadowEndZ", end.m_123343_());
            data.m_128347_("shadowY", y);
            data.m_128347_("shadowSpeed", 0.8);
            data.m_128356_("window_spawnTime", server.m_46467_());
            data.m_128362_("window_owner", state.player.m_20148_());
            data.m_128359_("window_role", "pass");
            data.m_128379_("FromWindowsEvent", true);
            server.m_7967_((Entity)state.entity);
        } else {
            CompoundTag data = state.entity.getPersistentData();
            if (state.tickCount >= 10) {
                state.entity.m_146870_();
                return;
            }
            double speed = data.m_128459_("shadowSpeed");
            int endX = data.m_128451_("shadowEndX");
            int endZ = data.m_128451_("shadowEndZ");
            double y = data.m_128459_("shadowY");
            Vec3 targetPos = new Vec3((double)endX + 0.5, y, (double)endZ + 0.5);
            Vec3 currentPos = state.entity.m_20182_();
            Vec3 dir = targetPos.m_82546_(currentPos);
            double len = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
            Vec3 toPlayer = state.player.m_146892_().m_82546_(currentPos);
            float yawToPlayer = (float)Math.toDegrees(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_)) - 90.0f;
            state.entity.m_146922_(yawToPlayer);
            state.entity.f_20885_ = yawToPlayer;
            state.entity.f_20883_ = yawToPlayer;
            if (len > 0.5) {
                Vec3 vel = new Vec3(dir.f_82479_ / len * speed, 0.0, dir.f_82481_ / len * speed);
                state.entity.m_20256_(vel);
            } else {
                state.entity.m_146870_();
            }
        }
    }

    private static void handleBrokenGlass(ServerLevel server, WindowEventState state) {
        if (state.tickCount == 1) {
            server.m_7731_(state.window.glassPos, Blocks.f_50016_.m_49966_(), 3);
            SoundEvent s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.glass.break"));
            if (s == null) {
                s = SoundEvents.f_11983_;
            }
            server.m_5594_(null, state.window.glassPos, s, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (state.tickCount >= 60) {
            server.m_7731_(state.window.glassPos, state.window.originalState, 3);
            SoundEvent s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.glass.place"));
            if (s == null) {
                s = SoundEvents.f_11986_;
            }
            server.m_5594_(null, state.window.glassPos, s, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static boolean isGlassBlock(BlockState state) {
        String blockName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString().toLowerCase();
        if (blockName.contains("glass")) {
            return true;
        }
        try {
            if (state.m_60739_(null, null) < 15 && state.m_60800_(null, null) < 1.0f) {
                if (state.m_60795_()) {
                    return false;
                }
                return state.m_60819_().m_76178_();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class WindowInfo {
        final BlockPos glassPos;
        final Direction facing;
        final BlockPos outsidePos;
        final BlockState originalState;

        WindowInfo(BlockPos glassPos, Direction facing, BlockPos outsidePos, BlockState originalState) {
            this.glassPos = glassPos;
            this.facing = facing;
            this.outsidePos = outsidePos;
            this.originalState = originalState;
        }
    }

    private static enum WindowEvent {
        FACE_IN_WINDOW,
        WINDOW_TAP,
        SHADOW_PASS,
        BROKEN_GLASS;

    }

    private static class WindowEventState {
        WindowEvent event;
        Player player;
        WindowInfo window;
        int tickCount;
        int cycle;
        FROMTHECAVESSHADOWEntity entity;
        boolean playerSawEntity;
        long sawEntityTick;

        WindowEventState(WindowEvent event, Player player, WindowInfo window, FROMTHECAVESSHADOWEntity entity) {
            this.event = event;
            this.player = player;
            this.window = window;
            this.tickCount = 0;
            this.cycle = event == WindowEvent.WINDOW_TAP ? 3 : 0;
            this.entity = entity;
            this.playerSawEntity = false;
            this.sawEntityTick = 0L;
        }
    }
}

