/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FalseOreMiningProcedure {
    private static final double BASE_PROB = 0.001;
    private static final double MAX_PROB = 0.002;
    private static final double SPAWN_DISTANCE = 1.0;
    private static final long COOLDOWN_TICKS = 1200L;
    private static final double LOOK_FOV_COS = Math.cos(Math.toRadians(50.0));
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor.m_5776_()) {
            return;
        }
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)levelAccessor;
        Player player = ev.getPlayer();
        if (player == null || player.m_7500_()) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        BlockPos pos = ev.getPos();
        if (server.m_45517_(LightLayer.BLOCK, pos) >= 18) {
            return;
        }
        if (!FalseOreMiningProcedure.isOre(server.m_8055_(pos).m_60734_())) {
            return;
        }
        long now = server.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1200L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 0.001, 0.002);
        if (Math.random() >= dynamicProb) {
            return;
        }
        FalseOreMiningProcedure.spawnBehindMob(server, player);
        playerCooldowns.put(player.m_20148_(), now);
    }

    private static void spawnBehindMob(ServerLevel server, Player player) {
        Mob behind;
        boolean headObstructed;
        Vec3 lookDir = player.m_20154_();
        Vec3 behindDir = new Vec3(-lookDir.f_82479_, 0.0, -lookDir.f_82481_);
        double len = Math.sqrt(behindDir.f_82479_ * behindDir.f_82479_ + behindDir.f_82481_ * behindDir.f_82481_);
        if (len < 1.0E-6) {
            return;
        }
        behindDir = behindDir.m_82541_();
        Vec3 playerPos = player.m_20182_();
        Vec3 spawnPos = playerPos.m_82549_(behindDir.m_82490_(1.0));
        int spawnX = (int)Math.floor(spawnPos.f_82479_);
        int spawnY = (int)Math.floor(playerPos.f_82480_);
        int spawnZ = (int)Math.floor(spawnPos.f_82481_);
        if (spawnY < server.m_141937_() + 1 || spawnY > server.m_151558_() - 2) {
            return;
        }
        Vec3 toSpawnPos = spawnPos.m_82546_(playerPos);
        double dotProduct = lookDir.m_82526_(toSpawnPos.m_82541_());
        if (dotProduct > 0.0) {
            return;
        }
        BlockPos spawnPosBlock = new BlockPos(spawnX, spawnY, spawnZ);
        BlockState blockState = server.m_8055_(spawnPosBlock);
        BlockState blockStateAbove = server.m_8055_(spawnPosBlock.m_7494_());
        boolean feetObstructed = !blockState.m_60795_() && blockState.m_60819_().m_76178_();
        boolean bl = headObstructed = !blockStateAbove.m_60795_() && blockStateAbove.m_60819_().m_76178_();
        if (feetObstructed || headObstructed) {
            BlockState finalFeetState;
            for (int dy = -1; dy <= 1; ++dy) {
                boolean tryHeadObstructed;
                if (dy == 0) continue;
                BlockPos tryPos = spawnPosBlock.m_7918_(0, dy, 0);
                BlockState tryState = server.m_8055_(tryPos);
                BlockState tryStateAbove = server.m_8055_(tryPos.m_7494_());
                boolean tryFeetObstructed = !tryState.m_60795_() && tryState.m_60819_().m_76178_();
                boolean bl2 = tryHeadObstructed = !tryStateAbove.m_60795_() && tryStateAbove.m_60819_().m_76178_();
                if (tryFeetObstructed || tryHeadObstructed) continue;
                spawnPos = new Vec3(spawnPos.f_82479_, (double)(spawnY += dy), spawnPos.f_82481_);
                break;
            }
            if (!(finalFeetState = server.m_8055_(new BlockPos(spawnX, spawnY, spawnZ))).m_60795_() && finalFeetState.m_60819_().m_76178_()) {
                return;
            }
        }
        if ((behind = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHINDTWO.get()).m_20615_((Level)server)) == null) {
            return;
        }
        behind.m_7678_(spawnPos.f_82479_, (double)spawnY, spawnPos.f_82481_, 0.0f, 0.0f);
        float oppositeYaw = (float)(Math.atan2(-behindDir.f_82481_, -behindDir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        behind.m_146922_(oppositeYaw);
        behind.f_20885_ = oppositeYaw;
        behind.f_20883_ = oppositeYaw;
        behind.m_21530_();
        behind.m_21557_(true);
        CompoundTag nbt = behind.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", server.m_46467_());
        nbt.m_128379_("isBehindTwoMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128379_("isRotating", false);
        nbt.m_128405_("rotationTicks", 0);
        boolean added = server.m_7967_((Entity)behind);
        if (!added || !behind.m_6084_()) {
            return;
        }
    }

    @SubscribeEvent
    public static void onBehindTwoMobTick(LivingEvent.LivingTickEvent ev) {
        UUID targetId;
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isBehindTwoMob")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            mob.m_146870_();
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        Player target = server.m_46003_(targetId = nbt.m_128342_("targetUUID"));
        if (target == null) {
            mob.m_146870_();
            return;
        }
        mob.m_21557_(true);
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        Vec3 playerEyePos = target.m_20299_(1.0f);
        Vec3 playerLook = target.m_20154_().m_82541_();
        Vec3 toMob = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
        double distToMob = toMob.m_82553_();
        if (distToMob > 1.0E-6 && distToMob < 30.0) {
            Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
            double dot = playerLook.m_82526_(toMobNorm);
            if (dot > LOOK_FOV_COS) {
                int lookingTicks = nbt.m_128451_("lookingAtTicks");
                nbt.m_128405_("lookingAtTicks", ++lookingTicks);
                if (!nbt.m_128471_("isRotating")) {
                    nbt.m_128379_("isRotating", true);
                    nbt.m_128405_("rotationTicks", 0);
                }
                if (nbt.m_128471_("isRotating")) {
                    int rotationTicks = nbt.m_128451_("rotationTicks");
                    nbt.m_128405_("rotationTicks", ++rotationTicks);
                    Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
                    float targetYaw = (float)(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_) * 180.0 / Math.PI) - 90.0f;
                    Vec3 behindDir = new Vec3(-playerLook.f_82479_, 0.0, -playerLook.f_82481_).m_82541_();
                    float startYaw = (float)(Math.atan2(-behindDir.f_82481_, -behindDir.f_82479_) * 180.0 / Math.PI) - 90.0f;
                    float progress = Math.min((float)rotationTicks / 5.0f, 1.0f);
                    float currentYaw = startYaw + (targetYaw - startYaw) * progress;
                    mob.m_146922_(currentYaw);
                    mob.f_20885_ = currentYaw;
                    mob.f_20883_ = currentYaw;
                }
                if (lookingTicks >= 10) {
                    server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.HOSTILE, 1.0f, 0.7f);
                    mob.m_146870_();
                    return;
                }
            } else if (nbt.m_128451_("lookingAtTicks") > 0) {
                nbt.m_128405_("lookingAtTicks", 0);
                nbt.m_128379_("isRotating", false);
                nbt.m_128405_("rotationTicks", 0);
            }
        }
        long spawnTick = nbt.m_128454_("spawnTick");
        long now = server.m_46467_();
        if (now - spawnTick > 3600L) {
            mob.m_146870_();
            return;
        }
    }

    private static boolean isOre(Block block) {
        return block == Blocks.f_49997_ || block == Blocks.f_49996_ || block == Blocks.f_49995_ || block == Blocks.f_50089_ || block == Blocks.f_50264_ || block == Blocks.f_50059_ || block == Blocks.f_50173_ || block == Blocks.f_152505_ || block == Blocks.f_152469_ || block == Blocks.f_152468_ || block == Blocks.f_152467_ || block == Blocks.f_152474_ || block == Blocks.f_152479_ || block == Blocks.f_152472_ || block == Blocks.f_152473_ || block == Blocks.f_152506_;
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 2400L);
    }
}

