/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerHeadEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.0E-5;
    private static final double BASE_PROB_PHASE2 = 4.0E-5;
    private static final double MAX_PROB_PHASE2 = 4.5E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int EVENT_DURATION = 240;
    private static final Map<Integer, HeadEventState> activeEvents = new HashMap<Integer, HeadEventState>();
    private static final Map<BlockPos, Long> headCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double maxProb = phase == 1 ? 4.0E-5 : 4.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validHeads = PlayerHeadEventsProcedure.findValidHeads(server, player);
        if (validHeads.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validHeads.removeIf(pos -> headCooldowns.containsKey(pos) && currentTime < headCooldowns.get(pos));
        if (validHeads.isEmpty()) {
            return;
        }
        BlockPos chosen = validHeads.get(server.m_213780_().m_188503_(validHeads.size()));
        HeadEvent event = HeadEvent.values()[server.m_213780_().m_188503_(HeadEvent.values().length)];
        headCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new HeadEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, HeadEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, HeadEventState> entry = iterator.next();
            HeadEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case HEAD_ROTATION: {
                    PlayerHeadEventsProcedure.handleHeadRotation(server, state);
                    break;
                }
                case HEAD_BREATHING: {
                    PlayerHeadEventsProcedure.handleBreathing(server, state);
                    break;
                }
                case HEAD_DARKENING: {
                    PlayerHeadEventsProcedure.handleDarkening(server, state);
                }
            }
            if (state.tickCount < 240) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidHeads(ServerLevel server, Player player) {
        ArrayList<BlockPos> heads = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof SkullBlock) && !(state.m_60734_() instanceof WallSkullBlock)) continue;
                    heads.add(pos.m_7949_());
                }
            }
        }
        return heads;
    }

    private static void handleHeadRotation(ServerLevel server, HeadEventState state) {
        BlockState headState = server.m_8055_(state.headPos);
        if (!(headState.m_60734_() instanceof SkullBlock)) {
            return;
        }
        if (state.tickCount % 8 == 0) {
            double dx = state.player.m_20185_() - ((double)state.headPos.m_123341_() + 0.5);
            double dz = state.player.m_20189_() - ((double)state.headPos.m_123343_() + 0.5);
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) + 90.0f;
            int rotation = Math.floorMod((int)(targetYaw / 22.5f), 16);
            server.m_7731_(state.headPos, (BlockState)headState.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation)), 3);
        }
    }

    private static void handleBreathing(ServerLevel server, HeadEventState state) {
        if (state.tickCount % 40 == 0) {
            server.m_5594_(null, state.headPos, SoundEvents.f_12320_, SoundSource.BLOCKS, 0.4f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
            ++state.breathingCycle;
        }
        if (state.tickCount % 20 == 0 && state.breathingCycle > 0) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.headPos.m_123341_() + 0.5, (double)state.headPos.m_123342_() + 0.3, (double)state.headPos.m_123343_() + 0.5, 3, 0.1, 0.05, 0.1, 0.01);
        }
    }

    private static void handleDarkening(ServerLevel server, HeadEventState state) {
        if (state.tickCount % 10 == 0) {
            int particleCount = Math.min(state.tickCount / 10, 8);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.headPos.m_123341_() + 0.5, (double)state.headPos.m_123342_() + 0.5, (double)state.headPos.m_123343_() + 0.5, particleCount, 0.15, 0.15, 0.15, 0.005);
        }
        if (state.tickCount % 60 == 0 && state.tickCount > 60) {
            server.m_5594_(null, state.headPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 0.5f);
        }
    }

    private static enum HeadEvent {
        HEAD_ROTATION,
        HEAD_BREATHING,
        HEAD_DARKENING;

    }

    private static class HeadEventState {
        HeadEvent event;
        Player player;
        BlockPos headPos;
        int tickCount;
        int breathingCycle;

        HeadEventState(HeadEvent event, Player player, BlockPos headPos) {
            this.event = event;
            this.player = player;
            this.headPos = headPos;
            this.tickCount = 0;
            this.breathingCycle = 0;
        }
    }
}

