/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2BEDEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2FLYINGEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2WALLEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2WINDOWEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVES3BUILDEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVES3DOPPELEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESAMETHYSTEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESBEHINDEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESBEHINDTWOEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESBELOWSPIDEREntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESBIRCHLOGSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESBIRCHPLANKSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESCAVESPIDEREntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESCOBBLESTONEEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESCROSSDEMONEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESDARKOAKLOGSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESEYELESSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESEYESEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESFAREntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESFRONTEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESHIDEEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESJUNGLELOGSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESOAKLOGSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESOAKPLANKSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESPARTRUNEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESROOFEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSIGNEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSKYEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSOUNDMIMICEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPIDEREntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPRUCELOGSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPRUCEPLANKSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSTAIRSEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSTONEEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESTHROWEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESWALLFULLEntity;
import net.mcreator.fromthecaves.entity.PossessedWatcherEntity;
import net.mcreator.fromthecaves.entity.WATCHEYESEntity;
import net.mcreator.fromthecaves.entity.WatcherPEntity;
import net.mcreator.fromthecaves.entity.WatcherSEntity;
import net.mcreator.fromthecaves.entity.WatcherWEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SilenceEffectProcedure {
    private static final double SILENCE_RADIUS = 4.0;
    private static final float SILENCED_VOLUME = 0.02f;
    private static final int CHECK_INTERVAL = 10;
    private static final double SILENCE_CHANCE = 0.5;
    private static VolumeSettings originalVolumes = null;
    private static boolean isSilenced = false;
    private static long lastCheckTick = 0L;
    private static final Map<Integer, Boolean> processedEntities = new HashMap<Integer, Boolean>();

    private static boolean isDangerousMob(Entity entity) {
        return entity instanceof FROMTHECAVESBEHINDEntity || entity instanceof FROMTHECAVES2WALLEntity || entity instanceof FROMTHECAVES3BUILDEntity || entity instanceof FROMTHECAVESSPIDEREntity || entity instanceof FROMTHECAVESTHROWEntity || entity instanceof FROMTHECAVESHIDEEntity || entity instanceof FROMTHECAVESBEHINDTWOEntity || entity instanceof FROMTHECAVESFAREntity || entity instanceof FROMTHECAVESROOFEntity || entity instanceof FROMTHECAVESCAVESPIDEREntity || entity instanceof FROMTHECAVESEYELESSEntity || entity instanceof WATCHEYESEntity || entity instanceof FROMTHECAVES2WINDOWEntity || entity instanceof PossessedWatcherEntity || entity instanceof FROMTHECAVESPARTRUNEntity || entity instanceof FROMTHECAVES3DOPPELEntity || entity instanceof FROMTHECAVESSIGNEntity || entity instanceof FROMTHECAVESSKYEntity || entity instanceof FROMTHECAVESCROSSDEMONEntity || entity instanceof FROMTHECAVES2FLYINGEntity || entity instanceof WatcherSEntity || entity instanceof WatcherWEntity || entity instanceof WatcherPEntity || entity instanceof FROMTHECAVESBELOWSPIDEREntity || entity instanceof FROMTHECAVESSOUNDMIMICEntity || entity instanceof FROMTHECAVESOAKPLANKSEntity || entity instanceof FROMTHECAVESBIRCHPLANKSEntity || entity instanceof FROMTHECAVESSTAIRSEntity || entity instanceof FROMTHECAVESWALLFULLEntity || entity instanceof FROMTHECAVESSPRUCEPLANKSEntity || entity instanceof FROMTHECAVESDARKOAKLOGSEntity || entity instanceof FROMTHECAVESOAKLOGSEntity || entity instanceof FROMTHECAVESBIRCHLOGSEntity || entity instanceof FROMTHECAVESJUNGLELOGSEntity || entity instanceof FROMTHECAVESSPRUCELOGSEntity || entity instanceof FROMTHECAVESSTONEEntity || entity instanceof FROMTHECAVESCOBBLESTONEEntity || entity instanceof FROMTHECAVESAMETHYSTEntity || entity instanceof FROMTHECAVES2BEDEntity || entity instanceof FROMTHECAVESEYESEntity || entity instanceof FROMTHECAVESFRONTEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        long currentTick = level.m_46467_();
        if (currentTick - lastCheckTick < 10L) {
            return;
        }
        lastCheckTick = currentTick;
        boolean dangersNearby = SilenceEffectProcedure.checkForDangerousEntities((Player)player, (Level)level, mc);
        if (dangersNearby && !isSilenced) {
            SilenceEffectProcedure.applySilenceEffect(mc);
        } else if (!dangersNearby && isSilenced) {
            SilenceEffectProcedure.removeSilenceEffect(mc);
        }
        SilenceEffectProcedure.cleanupProcessedEntities((Player)player, (Level)level);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean checkForDangerousEntities(Player player, Level level, Minecraft mc) {
        AABB searchBox = player.m_20191_().m_82400_(4.0);
        List nearbyEntities = level.m_45933_((Entity)player, searchBox);
        boolean shouldSilence = false;
        for (Entity entity : nearbyEntities) {
            double distance;
            if (!SilenceEffectProcedure.isDangerousMob(entity) || !((distance = (double)player.m_20270_(entity)) <= 4.0)) continue;
            int entityId = entity.m_19879_();
            if (!processedEntities.containsKey(entityId)) {
                boolean trigger = mc.f_91073_.f_46441_.m_188500_() < 0.5;
                processedEntities.put(entityId, trigger);
                shouldSilence |= trigger;
                continue;
            }
            shouldSilence |= processedEntities.get(entityId).booleanValue();
        }
        return shouldSilence;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void cleanupProcessedEntities(Player player, Level level) {
        HashSet<Integer> toRemove = new HashSet<Integer>();
        for (int id : processedEntities.keySet()) {
            Entity entity = level.m_6815_(id);
            if (entity != null && !entity.m_213877_() && !((double)player.m_20270_(entity) > 8.0)) continue;
            toRemove.add(id);
        }
        for (int id : toRemove) {
            processedEntities.remove(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applySilenceEffect(Minecraft mc) {
        if (originalVolumes == null) {
            originalVolumes = new VolumeSettings(mc);
        }
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.MUSIC, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.RECORDS, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.WEATHER, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.HOSTILE, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.NEUTRAL, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.AMBIENT, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.VOICE, 0.02f);
        SilenceEffectProcedure.setSoundVolume(mc, SoundSource.BLOCKS, 0.02f);
        isSilenced = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void removeSilenceEffect(Minecraft mc) {
        if (originalVolumes != null) {
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.MUSIC, SilenceEffectProcedure.originalVolumes.music);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.RECORDS, SilenceEffectProcedure.originalVolumes.records);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.WEATHER, SilenceEffectProcedure.originalVolumes.weather);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.HOSTILE, SilenceEffectProcedure.originalVolumes.hostile);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.NEUTRAL, SilenceEffectProcedure.originalVolumes.neutral);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.AMBIENT, SilenceEffectProcedure.originalVolumes.ambient);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.VOICE, SilenceEffectProcedure.originalVolumes.voice);
            SilenceEffectProcedure.setSoundVolume(mc, SoundSource.BLOCKS, SilenceEffectProcedure.originalVolumes.blocks);
            originalVolumes = null;
        }
        isSilenced = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setSoundVolume(Minecraft mc, SoundSource source, float volume) {
        OptionInstance option = mc.f_91066_.m_246669_(source);
        if (option != null) {
            option.m_231514_((Object)volume);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientDisconnect(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null && isSilenced) {
            originalVolumes = null;
            isSilenced = false;
            lastCheckTick = 0L;
            processedEntities.clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isSilenceActive() {
        return isSilenced;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void forceDeactivate() {
        Minecraft mc = Minecraft.m_91087_();
        if (isSilenced) {
            SilenceEffectProcedure.removeSilenceEffect(mc);
        }
    }

    public static double getSilenceRadius() {
        return 4.0;
    }

    public static float getSilencedVolume() {
        return 0.02f;
    }

    private static class VolumeSettings {
        float music;
        float records;
        float weather;
        float hostile;
        float neutral;
        float ambient;
        float voice;
        float blocks;

        VolumeSettings(Minecraft mc) {
            this.music = mc.f_91066_.m_92147_(SoundSource.MUSIC);
            this.records = mc.f_91066_.m_92147_(SoundSource.RECORDS);
            this.weather = mc.f_91066_.m_92147_(SoundSource.WEATHER);
            this.hostile = mc.f_91066_.m_92147_(SoundSource.HOSTILE);
            this.neutral = mc.f_91066_.m_92147_(SoundSource.NEUTRAL);
            this.ambient = mc.f_91066_.m_92147_(SoundSource.AMBIENT);
            this.voice = mc.f_91066_.m_92147_(SoundSource.VOICE);
            this.blocks = mc.f_91066_.m_92147_(SoundSource.BLOCKS);
        }
    }
}

