/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnFarMobProcedure {
    private static final double BASE_PROB = 3.5E-5;
    private static final double MAX_PROB = 5.0E-5;
    private static final double MIN_SPAWN_DIST = 15.0;
    private static final double MAX_SPAWN_DIST = 25.0;
    private static final int MAX_Y_DIFFERENCE = 8;
    private static final double MAX_DISTANCE_DESPAWN = 50.0;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 1800L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player.m_20186_() >= 50.0) {
            return;
        }
        long now = server.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1800L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 3.5E-5, 5.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos spawnPos = SpawnFarMobProcedure.findValidSpawnPosition(server, player);
        if (spawnPos == null) {
            return;
        }
        StalkingEvent event = StalkingEvent.values()[server.f_46441_.m_188503_(StalkingEvent.values().length)];
        EntityType<?> mobType = SpawnFarMobProcedure.chooseMobType(event, server);
        Mob stalker = (Mob)mobType.m_20615_((Level)server);
        if (stalker == null) {
            return;
        }
        stalker.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        stalker.m_21530_();
        stalker.m_21557_(false);
        stalker.m_20225_(true);
        CompoundTag nbt = stalker.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128379_("isStalkerMob", true);
        nbt.m_128359_("stalkingEvent", event.name());
        nbt.m_128356_("lastHeartbeat", now);
        nbt.m_128405_("heartbeatInterval", 20 + server.f_46441_.m_188503_(11));
        nbt.m_128347_("circleAngle", server.f_46441_.m_188500_() * 360.0);
        nbt.m_128379_("clockwise", server.f_46441_.m_188499_());
        nbt.m_128347_("targetDistance", 10.0 + server.f_46441_.m_188500_() * 6.0);
        nbt.m_128405_("peekTimer", 0);
        nbt.m_128379_("isHiding", false);
        nbt.m_128347_("lastPlayerX", player.m_20185_());
        nbt.m_128347_("lastPlayerY", player.m_20186_());
        nbt.m_128347_("lastPlayerZ", player.m_20189_());
        server.m_7967_((Entity)stalker);
        playerCooldowns.put(player.m_20148_(), now);
    }

    private static EntityType<?> chooseMobType(StalkingEvent event, ServerLevel server) {
        if (event == StalkingEvent.SHADOW_STALKING) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get();
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isStalkerMob")) {
            return;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        SpawnFarMobProcedure.handleStalkerBehavior(mob, server);
    }

    private static void handleStalkerBehavior(Mob stalker, ServerLevel server) {
        CompoundTag nbt = stalker.getPersistentData();
        if (!nbt.m_128403_("targetUUID")) {
            stalker.m_146870_();
            return;
        }
        UUID targetId = nbt.m_128342_("targetUUID");
        Player target = server.m_46003_(targetId);
        if (target == null) {
            stalker.m_146870_();
            return;
        }
        double distToPlayer = stalker.m_20270_((Entity)target);
        if (distToPlayer > 50.0) {
            stalker.m_146870_();
            return;
        }
        long now = server.m_46467_();
        if (now - nbt.m_128454_("spawnTick") > 6000L) {
            stalker.m_146870_();
            return;
        }
        SpawnFarMobProcedure.playHeartbeatSound(stalker, target, nbt, server);
        String eventName = nbt.m_128461_("stalkingEvent");
        StalkingEvent event = StalkingEvent.valueOf(eventName);
        switch (event) {
            case SILENT_DISAPPEAR: {
                SpawnFarMobProcedure.handleSilentDisappear(stalker, target, distToPlayer);
                break;
            }
            case CIRCLE_STALKING: {
                SpawnFarMobProcedure.handleCircleStalking(stalker, target, nbt, server, distToPlayer);
                break;
            }
            case SHADOW_STALKING: {
                SpawnFarMobProcedure.handleShadowStalking(stalker, target, distToPlayer);
                break;
            }
            case STATIC_WATCHER: {
                SpawnFarMobProcedure.handleStaticWatcher(stalker, target, distToPlayer);
                break;
            }
            case PEEK_AND_HIDE: {
                SpawnFarMobProcedure.handlePeekAndHide(stalker, target, nbt, server, distToPlayer);
                break;
            }
            case MIMIC_MOVEMENT: {
                SpawnFarMobProcedure.handleMimicMovement(stalker, target, nbt, server, distToPlayer);
                break;
            }
            case DISTANT_FOLLOWER: {
                SpawnFarMobProcedure.handleDistantFollower(stalker, target, nbt, server, distToPlayer);
                break;
            }
            case CORNER_LURKER: {
                SpawnFarMobProcedure.handleCornerLurker(stalker, target, nbt, server, distToPlayer);
            }
        }
    }

    private static void playHeartbeatSound(Mob stalker, Player target, CompoundTag nbt, ServerLevel server) {
        int interval;
        long lastHeartbeat;
        long now = server.m_46467_();
        if (now - (lastHeartbeat = nbt.m_128454_("lastHeartbeat")) >= (long)(interval = nbt.m_128451_("heartbeatInterval"))) {
            SoundEvent heartSound;
            if (server.f_46441_.m_188500_() < 0.3 && (heartSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "one_heart"))) != null) {
                server.m_5594_(null, stalker.m_20183_(), heartSound, SoundSource.HOSTILE, 0.4f, 0.8f + server.f_46441_.m_188501_() * 0.4f);
            }
            nbt.m_128356_("lastHeartbeat", now);
            nbt.m_128405_("heartbeatInterval", 20 + server.f_46441_.m_188503_(11));
        }
    }

    private static void handleSilentDisappear(Mob stalker, Player target, double distToPlayer) {
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
        stalker.m_20334_(0.0, stalker.m_20184_().f_82480_, 0.0);
        stalker.m_21573_().m_26573_();
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
        }
    }

    private static void handleCircleStalking(Mob stalker, Player target, CompoundTag nbt, ServerLevel server, double distToPlayer) {
        double dz;
        double dx;
        double dist;
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
            return;
        }
        double targetDistance = nbt.m_128459_("targetDistance");
        double currentAngle = nbt.m_128459_("circleAngle");
        boolean clockwise = nbt.m_128471_("clockwise");
        double angleIncrement = clockwise ? 3.0 : -3.0;
        if ((currentAngle += angleIncrement) >= 360.0) {
            currentAngle -= 360.0;
        }
        if (currentAngle < 0.0) {
            currentAngle += 360.0;
        }
        nbt.m_128347_("circleAngle", currentAngle);
        double angleRad = Math.toRadians(currentAngle);
        double offsetX = Math.cos(angleRad) * targetDistance;
        double offsetZ = Math.sin(angleRad) * targetDistance;
        BlockPos targetPos = new BlockPos((int)(target.m_20185_() + offsetX), (int)target.m_20186_(), (int)(target.m_20189_() + offsetZ));
        BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, targetPos, stalker.m_20183_(), 5);
        if (walkable != null && (dist = Math.sqrt((dx = (double)walkable.m_123341_() + 0.5 - stalker.m_20185_()) * dx + (dz = (double)walkable.m_123343_() + 0.5 - stalker.m_20189_()) * dz)) > 1.0) {
            stalker.m_21573_().m_26519_((double)walkable.m_123341_() + 0.5, (double)walkable.m_123342_(), (double)walkable.m_123343_() + 0.5, 1.0);
        }
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
    }

    private static void handleShadowStalking(Mob stalker, Player target, double distToPlayer) {
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
        stalker.m_20334_(0.0, stalker.m_20184_().f_82480_, 0.0);
        stalker.m_21573_().m_26573_();
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
        }
    }

    private static void handleStaticWatcher(Mob stalker, Player target, double distToPlayer) {
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
        stalker.m_20334_(0.0, stalker.m_20184_().f_82480_, 0.0);
        stalker.m_21573_().m_26573_();
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
        }
    }

    private static void handlePeekAndHide(Mob stalker, Player target, CompoundTag nbt, ServerLevel server, double distToPlayer) {
        int peekTimer = nbt.m_128451_("peekTimer");
        boolean isHiding = nbt.m_128471_("isHiding");
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
            return;
        }
        if (!isHiding) {
            SpawnFarMobProcedure.lookAtPlayer(stalker, target);
            stalker.m_20334_(0.0, stalker.m_20184_().f_82480_, 0.0);
            stalker.m_21573_().m_26573_();
            if (++peekTimer >= 60) {
                nbt.m_128379_("isHiding", true);
                nbt.m_128405_("peekTimer", 0);
            }
        } else {
            Vec3 awayDir = stalker.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            BlockPos hidePos = stalker.m_20183_().m_7918_((int)(awayDir.f_82479_ * 4.0), 0, (int)(awayDir.f_82481_ * 4.0));
            BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, hidePos, stalker.m_20183_(), 5);
            if (walkable != null) {
                stalker.m_21573_().m_26519_((double)walkable.m_123341_() + 0.5, (double)walkable.m_123342_(), (double)walkable.m_123343_() + 0.5, 1.3);
            }
            if (++peekTimer >= 40) {
                nbt.m_128379_("isHiding", false);
                nbt.m_128405_("peekTimer", 0);
            }
        }
        nbt.m_128405_("peekTimer", peekTimer);
    }

    private static void handleMimicMovement(Mob stalker, Player target, CompoundTag nbt, ServerLevel server, double distToPlayer) {
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
            return;
        }
        double lastX = nbt.m_128459_("lastPlayerX");
        double lastY = nbt.m_128459_("lastPlayerY");
        double lastZ = nbt.m_128459_("lastPlayerZ");
        Vec3 playerMovement = new Vec3(target.m_20185_() - lastX, target.m_20186_() - lastY, target.m_20189_() - lastZ);
        if (playerMovement.m_82556_() > 0.05) {
            Vec3 mirroredMovement = playerMovement.m_82490_(-1.5);
            BlockPos newPos = stalker.m_20183_().m_7918_((int)mirroredMovement.f_82479_, 0, (int)mirroredMovement.f_82481_);
            BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, newPos, stalker.m_20183_(), 5);
            if (walkable != null) {
                stalker.m_21573_().m_26519_((double)walkable.m_123341_() + 0.5, (double)walkable.m_123342_(), (double)walkable.m_123343_() + 0.5, 0.9);
            }
        }
        nbt.m_128347_("lastPlayerX", target.m_20185_());
        nbt.m_128347_("lastPlayerY", target.m_20186_());
        nbt.m_128347_("lastPlayerZ", target.m_20189_());
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
    }

    private static void handleDistantFollower(Mob stalker, Player target, CompoundTag nbt, ServerLevel server, double distToPlayer) {
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
            return;
        }
        double targetDistance = 12.0;
        if (distToPlayer < targetDistance - 2.0) {
            Vec3 awayDir = stalker.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            BlockPos movePos = stalker.m_20183_().m_7918_((int)(awayDir.f_82479_ * 3.0), 0, (int)(awayDir.f_82481_ * 3.0));
            BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, movePos, stalker.m_20183_(), 5);
            if (walkable != null) {
                stalker.m_21573_().m_26519_((double)walkable.m_123341_() + 0.5, (double)walkable.m_123342_(), (double)walkable.m_123343_() + 0.5, 1.0);
            }
        } else if (distToPlayer > targetDistance + 2.0) {
            Vec3 towardsDir = target.m_20182_().m_82546_(stalker.m_20182_()).m_82541_();
            BlockPos movePos = stalker.m_20183_().m_7918_((int)(towardsDir.f_82479_ * 3.0), 0, (int)(towardsDir.f_82481_ * 3.0));
            BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, movePos, stalker.m_20183_(), 5);
            if (walkable != null) {
                stalker.m_21573_().m_26519_((double)walkable.m_123341_() + 0.5, (double)walkable.m_123342_(), (double)walkable.m_123343_() + 0.5, 0.8);
            }
        } else {
            stalker.m_21573_().m_26573_();
        }
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
    }

    private static void handleCornerLurker(Mob stalker, Player target, CompoundTag nbt, ServerLevel server, double distToPlayer) {
        if (distToPlayer <= 7.0) {
            stalker.m_146870_();
            return;
        }
        SpawnFarMobProcedure.lookAtPlayer(stalker, target);
        stalker.m_20334_(0.0, stalker.m_20184_().f_82480_, 0.0);
        stalker.m_21573_().m_26573_();
        if (server.m_46467_() % 100L == 0L) {
            Vec3 right = new Vec3(-target.m_20154_().f_82481_, 0.0, target.m_20154_().f_82479_).m_82541_();
            boolean moveRight = server.f_46441_.m_188499_();
            Vec3 sideDir = moveRight ? right : right.m_82490_(-1.0);
            BlockPos newCorner = stalker.m_20183_().m_7918_((int)(sideDir.f_82479_ * 3.0), 0, (int)(sideDir.f_82481_ * 3.0));
            BlockPos walkable = SpawnFarMobProcedure.findNearestWalkablePosition(server, newCorner, stalker.m_20183_(), 3);
            if (walkable != null) {
                stalker.m_21573_().m_26519_((double)walkable.m_123341_(), (double)walkable.m_123342_(), (double)walkable.m_123343_(), 1.0);
            }
        }
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, Player player) {
        Vec3 playerPos = player.m_20182_();
        int playerY = (int)playerPos.f_82480_;
        for (int attempt = 0; attempt < 20; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double distance = 15.0 + Math.random() * 10.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            int spawnX = (int)Math.floor(playerPos.f_82479_ + offsetX);
            int spawnZ = (int)Math.floor(playerPos.f_82481_ + offsetZ);
            int minY = Math.max(level.m_141937_() + 1, playerY - 8);
            int maxY = Math.min(level.m_151558_() - 2, playerY + 8);
            for (int yOffset = 0; yOffset <= 16; ++yOffset) {
                BlockPos pos;
                int checkY = playerY + (yOffset % 2 == 0 ? yOffset / 2 : -(yOffset + 1) / 2);
                if (checkY < minY || checkY > maxY || !SpawnFarMobProcedure.isValidSpawnLocation(level, pos = new BlockPos(spawnX, checkY, spawnZ))) continue;
                return pos;
            }
        }
        return null;
    }

    private static boolean isValidSpawnLocation(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return SpawnFarMobProcedure.isSolidGround(below) && SpawnFarMobProcedure.isPassable(at) && SpawnFarMobProcedure.isPassable(above);
    }

    private static boolean isPassable(BlockState state) {
        return state.m_60795_() || !state.m_60815_();
    }

    private static boolean isSolidGround(BlockState state) {
        return !state.m_60795_() && state.m_60815_();
    }

    private static BlockPos findNearestWalkablePosition(ServerLevel level, BlockPos target, BlockPos start, int maxRadius) {
        if (SpawnFarMobProcedure.isWalkablePosition(level, target)) {
            return target;
        }
        for (int radius = 1; radius <= maxRadius; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius) continue;
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos check = target.m_7918_(dx, dy, dz);
                        if (!SpawnFarMobProcedure.isWalkablePosition(level, check)) continue;
                        return check;
                    }
                }
            }
        }
        return start;
    }

    private static boolean isWalkablePosition(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return SpawnFarMobProcedure.isSolidGround(below) && SpawnFarMobProcedure.isPassable(at) && SpawnFarMobProcedure.isPassable(above);
    }

    private static void lookAtPlayer(Mob mob, Player target) {
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        if (toPlayer.m_82556_() > 1.0E-6) {
            Vec3 toPlayerNorm = toPlayer.m_82541_();
            float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 3600L);
    }

    private static enum StalkingEvent {
        SILENT_DISAPPEAR,
        CIRCLE_STALKING,
        SHADOW_STALKING,
        STATIC_WATCHER,
        PEEK_AND_HIDE,
        MIMIC_MOVEMENT,
        DISTANT_FOLLOWER,
        CORNER_LURKER;

    }
}

