/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Random;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSPIDEREntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpiderSpawnProcedure {
    private static final double BASE_PROB = 6.0E-5;
    private static final double MAX_PROB = 7.0E-5;
    private static final int MIN_DIST = 15;
    private static final int MAX_DIST = 30;
    private static final int MIN_STONE = 5;
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 6.0E-5, 7.0E-5);
        if (RNG.nextDouble() >= dynamicProb) {
            return;
        }
        BlockPos spawnPos = SpiderSpawnProcedure.findValidSpawn(level, player);
        if (spawnPos == null) {
            return;
        }
        FROMTHECAVESSPIDEREntity spider = (FROMTHECAVESSPIDEREntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSPIDER.get()).m_20615_((Level)server);
        if (spider == null) {
            return;
        }
        spider.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, RNG.nextFloat() * 360.0f, 0.0f);
        spider.m_21557_(false);
        spider.m_21530_();
        server.m_7967_((Entity)spider);
        SpiderSpawnProcedure.teleportToNearestAir(spider, player, server);
    }

    private static BlockPos findValidSpawn(Level level, Player player) {
        BlockPos ppos = player.m_20183_();
        for (int i = 0; i < 10; ++i) {
            BlockPos down;
            VoxelShape shape;
            double angle = RNG.nextDouble() * Math.PI * 2.0;
            double dist = 15.0 + RNG.nextDouble() * 15.0;
            double dx = Math.cos(angle) * dist;
            double dz = Math.sin(angle) * dist;
            int cx = Mth.m_14107_((double)(player.m_20185_() + dx));
            int cz = Mth.m_14107_((double)(player.m_20189_() + dz));
            int cy = ppos.m_123342_();
            BlockPos cand = new BlockPos(cx, cy, cz);
            if (!level.m_46859_(cand) || (shape = level.m_8055_(down = cand.m_7495_()).m_60812_((BlockGetter)level, down)).m_83281_()) continue;
            int count = 0;
            for (int xx = -3; xx <= 3 && count < 5; ++xx) {
                for (int yy = -1; yy <= 3 && count < 5; ++yy) {
                    for (int zz = -3; zz <= 3 && count < 5; ++zz) {
                        BlockPos check = cand.m_7918_(xx, yy, zz);
                        Block block = level.m_8055_(check).m_60734_();
                        if (block != Blocks.f_50069_ && block != Blocks.f_152550_) continue;
                        ++count;
                    }
                }
            }
            if (count < 5) continue;
            return cand;
        }
        return null;
    }

    private static void teleportToNearestAir(FROMTHECAVESSPIDEREntity spider, Player player, ServerLevel server) {
        ServerLevel level = server;
        BlockPos pos = spider.m_20183_();
        VoxelShape shapeHere = level.m_8055_(pos).m_60812_((BlockGetter)level, pos);
        if (shapeHere.m_83281_()) {
            return;
        }
        BlockPos ppos = player.m_20183_();
        int maxRadius = 30;
        double minDistSq = 225.0;
        double maxDistSq = 900.0;
        for (int r = 1; r <= maxRadius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    for (int dy = -1; dy <= 3; ++dy) {
                        BlockPos below;
                        VoxelShape shapeDown;
                        double pdz;
                        double pdy;
                        double pdx;
                        double distSq;
                        BlockPos candidate = pos.m_7918_(dx, dy, dz);
                        if (!level.m_46859_(candidate) || (distSq = (pdx = (double)candidate.m_123341_() + 0.5 - ((double)ppos.m_123341_() + 0.5)) * pdx + (pdy = (double)candidate.m_123342_() - ((double)ppos.m_123342_() + 0.5)) * pdy + (pdz = (double)candidate.m_123343_() + 0.5 - ((double)ppos.m_123343_() + 0.5)) * pdz) < minDistSq || distSq > maxDistSq || (shapeDown = level.m_8055_(below = candidate.m_7495_()).m_60812_((BlockGetter)level, below)).m_83281_()) continue;
                        spider.m_6021_((double)candidate.m_123341_() + 0.5, candidate.m_123342_(), (double)candidate.m_123343_() + 0.5);
                        return;
                    }
                }
            }
        }
    }
}

