/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnimalFearManagerProcedure {
    private static final double DETECT_RADIUS = 20.0;
    private static final double AVOID_DISTANCE = 10.0;
    private static final double FLEE_SPEED = 0.5;
    private static final ResourceLocation[] PARROT_IT_SOUNDS = new ResourceLocation[]{new ResourceLocation("from_the_caves", "it_13"), new ResourceLocation("from_the_caves", "it_14"), new ResourceLocation("from_the_caves", "it_15"), new ResourceLocation("from_the_caves", "it_16"), new ResourceLocation("from_the_caves", "it_18"), new ResourceLocation("from_the_caves", "it_19"), new ResourceLocation("from_the_caves", "it_20"), new ResourceLocation("from_the_caves", "it_21"), new ResourceLocation("from_the_caves", "it_22"), new ResourceLocation("from_the_caves", "it_23"), new ResourceLocation("from_the_caves", "it_24"), new ResourceLocation("from_the_caves", "it_25"), new ResourceLocation("from_the_caves", "it_26"), new ResourceLocation("from_the_caves", "it_27"), new ResourceLocation("from_the_caves", "it_28")};
    private static final int MIN_DELAY_TICKS = 200;
    private static final int MAX_DELAY_TICKS = 600;
    private static final Map<UUID, Long> lastSoundTick = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel server = ev.getServer().m_129783_();
        if (server == null) {
            return;
        }
        for (Player player : server.m_6907_()) {
            AABB detectBox = player.m_20191_().m_82400_(20.0);
            ArrayList<Entity> dangers = new ArrayList<Entity>();
            for (Entity en : server.m_6443_(Entity.class, detectBox, e -> true)) {
                ResourceLocation typeRL;
                if (en == null || en.m_213877_() || (typeRL = ForgeRegistries.ENTITY_TYPES.getKey((Object)en.m_6095_())) == null || !"from_the_caves".equals(typeRL.m_135827_()) || en instanceof Player) continue;
                dangers.add(en);
            }
            if (dangers.isEmpty()) continue;
            long now = server.m_46467_();
            for (Entity en : server.m_6443_(Entity.class, detectBox, e -> true)) {
                double dist;
                Vec3 move;
                SoundEvent sound;
                float yaw;
                boolean playSound;
                if (en == null || en.m_213877_()) continue;
                Entity nearestDanger = null;
                double nearestDist = Double.MAX_VALUE;
                for (Entity danger : dangers) {
                    double d = en.m_20280_(danger);
                    if (!(d < nearestDist)) continue;
                    nearestDist = d;
                    nearestDanger = danger;
                }
                if (nearestDanger == null || nearestDist > 400.0) continue;
                UUID id = en.m_20148_();
                long allowedAt = lastSoundTick.getOrDefault(id, 0L);
                boolean bl = playSound = now >= allowedAt;
                if (en.m_6095_() == EntityType.f_20499_ && en instanceof Wolf) {
                    Wolf w = (Wolf)en;
                    double dx = nearestDanger.m_20185_() - w.m_20185_();
                    double dz = nearestDanger.m_20189_() - w.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    w.m_146922_(yaw);
                    w.f_20885_ = w.m_146908_();
                    w.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.wolf.growl");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, w.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20553_ && en instanceof Cat) {
                    Cat c = (Cat)en;
                    double dx = nearestDanger.m_20185_() - c.m_20185_();
                    double dz = nearestDanger.m_20189_() - c.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    c.m_146922_(yaw);
                    c.f_20885_ = c.m_146908_();
                    c.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.cat.hiss");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, c.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20508_ && en instanceof Parrot) {
                    Parrot p = (Parrot)en;
                    float yaw2 = (float)(Math.atan2(nearestDanger.m_20189_() - p.m_20189_(), nearestDanger.m_20185_() - p.m_20185_()) * 180.0 / Math.PI) - 90.0f;
                    p.m_146922_(yaw2);
                    p.f_20885_ = p.m_146908_();
                    p.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = PARROT_IT_SOUNDS[server.m_213780_().m_188503_(PARROT_IT_SOUNDS.length)];
                    SoundEvent sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound2 != null) {
                        server.m_5594_(null, p.m_20183_(), sound2, SoundSource.NEUTRAL, 0.3f, 1.6f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20457_ && en instanceof Horse) {
                    Horse h = (Horse)en;
                    double dx = nearestDanger.m_20185_() - h.m_20185_();
                    double dz = nearestDanger.m_20189_() - h.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    h.m_146922_(yaw);
                    h.f_20885_ = h.m_146908_();
                    h.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.horse.angry");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, h.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20452_ && en instanceof Fox) {
                    Fox f = (Fox)en;
                    double dx = nearestDanger.m_20185_() - f.m_20185_();
                    double dz = nearestDanger.m_20189_() - f.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    f.m_146922_(yaw);
                    f.f_20885_ = f.m_146908_();
                    f.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.fox.screech");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, f.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20517_ && en instanceof Rabbit) {
                    Rabbit r = (Rabbit)en;
                    double dx = nearestDanger.m_20185_() - r.m_20185_();
                    double dz = nearestDanger.m_20189_() - r.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    r.m_146922_(yaw);
                    r.f_20885_ = r.m_146908_();
                    r.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.rabbit.hurt");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, r.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20555_ && en instanceof Chicken) {
                    Chicken ch = (Chicken)en;
                    double dx = nearestDanger.m_20185_() - ch.m_20185_();
                    double dz = nearestDanger.m_20189_() - ch.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    ch.m_146922_(yaw);
                    ch.f_20885_ = ch.m_146908_();
                    ch.m_20256_(Vec3.f_82478_);
                    if (!playSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.chicken.hurt");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, ch.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                    continue;
                }
                if (en.m_6095_() == EntityType.f_20492_ && en instanceof Villager) {
                    double dist2;
                    Villager v = (Villager)en;
                    double dx = nearestDanger.m_20185_() - v.m_20185_();
                    double dz = nearestDanger.m_20189_() - v.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    v.m_146922_(yaw);
                    v.f_20885_ = v.m_146908_();
                    if (playSound) {
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.villager.no");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            server.m_5594_(null, v.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + server.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                    }
                    if ((dist2 = Math.sqrt(nearestDist)) < 10.0) {
                        Vec3 away = v.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
                        move = away.m_82490_(0.5).m_82520_(0.0, v.m_20184_().f_82480_, 0.0);
                        v.m_20256_(move);
                        continue;
                    }
                    v.m_20256_(Vec3.f_82478_);
                    continue;
                }
                if (en.m_6095_() != EntityType.f_20460_ || !(en instanceof IronGolem)) continue;
                IronGolem g = (IronGolem)en;
                double dx = nearestDanger.m_20185_() - g.m_20185_();
                double dz = nearestDanger.m_20189_() - g.m_20189_();
                yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                g.m_146922_(yaw);
                g.f_20885_ = g.m_146908_();
                if (playSound) {
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.iron_golem.hurt");
                    sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, g.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    lastSoundTick.put(id, now + (long)delay);
                }
                if ((dist = Math.sqrt(nearestDist)) < 10.0) {
                    Vec3 away = g.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
                    move = away.m_82490_(0.5).m_82520_(0.0, g.m_20184_().f_82480_, 0.0);
                    g.m_20256_(move);
                    continue;
                }
                g.m_20256_(Vec3.f_82478_);
            }
        }
    }
}

